package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MAD_EXPT category record details about
 *  a MAD phasing experiment, such as the number of experiments that
 *  were clustered together to produce a set of phases or the
 *  statistics for those phases.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_exptCategory>
 *  <PDBx:phasing_MAD_expt id="1">
 *  <PDBx:number_clust>2</PDBx:number_clust>
 *  <PDBx:R_normal_all>0.063</PDBx:R_normal_all>
 *  <PDBx:R_normal_anom_scat>0.451</PDBx:R_normal_anom_scat>
 *  <PDBx:delta_delta_phi>58.5</PDBx:delta_delta_phi>
 *  <PDBx:delta_phi_sigma>20.3</PDBx:delta_phi_sigma>
 *  <PDBx:mean_fom>0.88</PDBx:mean_fom>
 *  </PDBx:phasing_MAD_expt>
 *  <PDBx:phasing_MAD_expt id="2">
 *  <PDBx:number_clust>1</PDBx:number_clust>
 *  <PDBx:R_normal_all>0.051</PDBx:R_normal_all>
 *  <PDBx:R_normal_anom_scat>0.419</PDBx:R_normal_anom_scat>
 *  <PDBx:delta_delta_phi>36.8</PDBx:delta_delta_phi>
 *  <PDBx:delta_phi_sigma>18.2</PDBx:delta_phi_sigma>
 *  <PDBx:mean_fom>0.93</PDBx:mean_fom>
 *  </PDBx:phasing_MAD_expt>
 *  </PDBx:phasing_MAD_exptCategory>
 * </pre>
 */
public class Phasing_MAD_expt extends org.pdb.beans.Phasing_MAD_expt implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MAD_expt";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MAD_expt()
	{
	}

	/** Full constructor */
	public Phasing_MAD_expt(
		Datablock datablock,
		java.lang.Float R_normal_all,
		java.lang.Float R_normal_anom_scat,
		java.lang.Float delta_delta_phi,
		java.lang.Float delta_phi,
		java.lang.Float delta_phi_sigma,
		java.lang.String id_,
		java.lang.Float mean_fom,
		java.lang.Integer number_clust)
	{
		this.datablock = datablock;
		this.R_normal_all = R_normal_all;
		this.R_normal_anom_scat = R_normal_anom_scat;
		this.delta_delta_phi = delta_delta_phi;
		this.delta_phi = delta_phi;
		this.delta_phi_sigma = delta_phi_sigma;
		this.id_ = id_;
		this.mean_fom = mean_fom;
		this.number_clust = number_clust;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MAD_expt");
		sb.append("\n");
		if (R_normal_all != null)
		{
			sb.append("R_normal_all = ");
			sb.append(R_normal_all);
			sb.append('\n');
		}
		if (R_normal_anom_scat != null)
		{
			sb.append("R_normal_anom_scat = ");
			sb.append(R_normal_anom_scat);
			sb.append('\n');
		}
		if (delta_delta_phi != null)
		{
			sb.append("delta_delta_phi = ");
			sb.append(delta_delta_phi);
			sb.append('\n');
		}
		if (delta_phi != null)
		{
			sb.append("delta_phi = ");
			sb.append(delta_phi);
			sb.append('\n');
		}
		if (delta_phi_sigma != null)
		{
			sb.append("delta_phi_sigma = ");
			sb.append(delta_phi_sigma);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (mean_fom != null)
		{
			sb.append("mean_fom = ");
			sb.append(mean_fom);
			sb.append('\n');
		}
		if (number_clust != null)
		{
			sb.append("number_clust = ");
			sb.append(number_clust);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_normal_all = null;
		R_normal_anom_scat = null;
		delta_delta_phi = null;
		delta_phi = null;
		delta_phi_sigma = null;
		id_ = null;
		mean_fom = null;
		number_clust = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MAD_expt)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MAD_expt>\n");
			if (R_normal_all != null) ow.write(indent + " <PDBx:R_normal_all>" + R_normal_all + "</PDBx:R_normal_all>\n");
			if (R_normal_anom_scat != null) ow.write(indent + " <PDBx:R_normal_anom_scat>" + R_normal_anom_scat + "</PDBx:R_normal_anom_scat>\n");
			if (delta_delta_phi != null) ow.write(indent + " <PDBx:delta_delta_phi>" + delta_delta_phi + "</PDBx:delta_delta_phi>\n");
			if (delta_phi != null) ow.write(indent + " <PDBx:delta_phi>" + delta_phi + "</PDBx:delta_phi>\n");
			if (delta_phi_sigma != null) ow.write(indent + " <PDBx:delta_phi_sigma>" + delta_phi_sigma + "</PDBx:delta_phi_sigma>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (mean_fom != null) ow.write(indent + " <PDBx:mean_fom>" + mean_fom + "</PDBx:mean_fom>\n");
			if (number_clust != null) ow.write(indent + " <PDBx:number_clust>" + number_clust + "</PDBx:number_clust>\n");
			ow.write(indent + "</PDBx:phasing_MAD_expt>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
