package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MAD_RATIO category record
 *  the ratios of phasing statistics between pairs of data sets
 *  in a MAD phasing experiment, in given shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_ratioCategory>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.4013">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.084</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.076</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3857">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.067</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.051</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.044</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.110</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.049</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.049</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.067</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.149</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.072</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.039</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.102</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.071</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.4013">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.114</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.111</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3857">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.089</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.086</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.077</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.140</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.127</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.085</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.089</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.155</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.119</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.082</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.124</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.120</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.075</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.027</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.041</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.060</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.057</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.072</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.105</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.032</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.036</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.044</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.065</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.072</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.031</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.040</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.059</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.059</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.032</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.059</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.2862" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.058</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.028</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.078</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.075</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.059</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.067</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.084</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.073</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.101</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.088</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.066</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.082</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.085</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.097</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.074</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.081</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.085</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.114</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.089</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.103</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.2862" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.062</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.060</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7263">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.035</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.026</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7251">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.028</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.023</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.025</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.026</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7251">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.060</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.026</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.029</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.031</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.035</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.075</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.030</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.023</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.027</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.069</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.026</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.024</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7217" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.060</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.028</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7263">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.060</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.050</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7251">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.056</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.055</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.053</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.056</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7251">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.089</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.050</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.054</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.058</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.063</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.104</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.057</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.052</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.057</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.098</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.052</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.054</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7217" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.089</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.060</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  </PDBx:phasing_MAD_ratioCategory>
 * </pre>
 */
public class Phasing_MAD_ratio extends org.pdb.beans.Phasing_MAD_ratio implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MAD_ratio";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MAD_ratio()
	{
	}

	/** Full constructor */
	public Phasing_MAD_ratio(
		Datablock datablock,
		java.lang.String clust_id,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String expt_id,
		java.lang.Float ratio_one_wl,
		java.lang.Float ratio_one_wl_centric,
		java.lang.Float ratio_two_wl,
		java.lang.Float wavelength_1,
		java.lang.Float wavelength_2)
	{
		this.datablock = datablock;
		this.clust_id = clust_id;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.expt_id = expt_id;
		this.ratio_one_wl = ratio_one_wl;
		this.ratio_one_wl_centric = ratio_one_wl_centric;
		this.ratio_two_wl = ratio_two_wl;
		this.wavelength_1 = wavelength_1;
		this.wavelength_2 = wavelength_2;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MAD_ratio");
		sb.append("\n");
		if (clust_id != null)
		{
			sb.append("clust_id = ");
			sb.append(clust_id);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (expt_id != null)
		{
			sb.append("expt_id = ");
			sb.append(expt_id);
			sb.append('\n');
		}
		if (ratio_one_wl != null)
		{
			sb.append("ratio_one_wl = ");
			sb.append(ratio_one_wl);
			sb.append('\n');
		}
		if (ratio_one_wl_centric != null)
		{
			sb.append("ratio_one_wl_centric = ");
			sb.append(ratio_one_wl_centric);
			sb.append('\n');
		}
		if (ratio_two_wl != null)
		{
			sb.append("ratio_two_wl = ");
			sb.append(ratio_two_wl);
			sb.append('\n');
		}
		if (wavelength_1 != null)
		{
			sb.append("wavelength_1 = ");
			sb.append(wavelength_1);
			sb.append('\n');
		}
		if (wavelength_2 != null)
		{
			sb.append("wavelength_2 = ");
			sb.append(wavelength_2);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		clust_id = null;
		d_res_high = null;
		d_res_low = null;
		expt_id = null;
		ratio_one_wl = null;
		ratio_one_wl_centric = null;
		ratio_two_wl = null;
		wavelength_1 = null;
		wavelength_2 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MAD_ratio)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MAD_ratio>\n");
			if (clust_id != null) ow.write(indent + " <PDBx:clust_id>" + clust_id + "</PDBx:clust_id>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (expt_id != null) ow.write(indent + " <PDBx:expt_id>" + expt_id + "</PDBx:expt_id>\n");
			if (ratio_one_wl != null) ow.write(indent + " <PDBx:ratio_one_wl>" + ratio_one_wl + "</PDBx:ratio_one_wl>\n");
			if (ratio_one_wl_centric != null) ow.write(indent + " <PDBx:ratio_one_wl_centric>" + ratio_one_wl_centric + "</PDBx:ratio_one_wl_centric>\n");
			if (ratio_two_wl != null) ow.write(indent + " <PDBx:ratio_two_wl>" + ratio_two_wl + "</PDBx:ratio_two_wl>\n");
			if (wavelength_1 != null) ow.write(indent + " <PDBx:wavelength_1>" + wavelength_1 + "</PDBx:wavelength_1>\n");
			if (wavelength_2 != null) ow.write(indent + " <PDBx:wavelength_2>" + wavelength_2 + "</PDBx:wavelength_2>\n");
			ow.write(indent + "</PDBx:phasing_MAD_ratio>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
