package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MAD_SET category record
 *  details about the individual data sets used in a MAD phasing
 *  experiment.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_setCategory>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="aa" wavelength="1.4013">
 *  <PDBx:wavelength_details>pre-edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-12.48</PDBx:f_prime>
 *  <PDBx:f_double_prime>3.80</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="bb" wavelength="1.3857">
 *  <PDBx:wavelength_details>peak</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-31.22</PDBx:f_prime>
 *  <PDBx:f_double_prime>17.20</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="cc" wavelength="1.3852">
 *  <PDBx:wavelength_details>edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-13.97</PDBx:f_prime>
 *  <PDBx:f_double_prime>29.17</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="dd" wavelength="1.3847">
 *  <PDBx:wavelength_details>remote</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-6.67</PDBx:f_prime>
 *  <PDBx:f_double_prime>17.34</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="ee" wavelength="1.3857">
 *  <PDBx:wavelength_details>ascending edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-28.33</PDBx:f_prime>
 *  <PDBx:f_double_prime>14.84</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="ff" wavelength="1.3852">
 *  <PDBx:wavelength_details>peak</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-21.50</PDBx:f_prime>
 *  <PDBx:f_double_prime>30.23</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="gg" wavelength="1.3847">
 *  <PDBx:wavelength_details>descending edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-10.71</PDBx:f_prime>
 *  <PDBx:f_double_prime>20.35</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="hh" wavelength="1.3784">
 *  <PDBx:wavelength_details>remote 1</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-14.45</PDBx:f_prime>
 *  <PDBx:f_double_prime>11.84</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="ii" wavelength="1.2862">
 *  <PDBx:wavelength_details>remote 2</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-9.03</PDBx:f_prime>
 *  <PDBx:f_double_prime>9.01</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="jj" wavelength="0.7263">
 *  <PDBx:wavelength_details>pre-edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-21.10</PDBx:f_prime>
 *  <PDBx:f_double_prime>4.08</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="kk" wavelength="0.7251">
 *  <PDBx:wavelength_details>edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-34.72</PDBx:f_prime>
 *  <PDBx:f_double_prime>7.92</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="ll" wavelength="0.7248">
 *  <PDBx:wavelength_details>peak</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-24.87</PDBx:f_prime>
 *  <PDBx:f_double_prime>10.30</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="mm" wavelength="0.7246">
 *  <PDBx:wavelength_details>descending edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-17.43</PDBx:f_prime>
 *  <PDBx:f_double_prime>9.62</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="nn" wavelength="0.7217">
 *  <PDBx:wavelength_details>remote</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-13.26</PDBx:f_prime>
 *  <PDBx:f_double_prime>8.40</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  </PDBx:phasing_MAD_setCategory>
 * </pre>
 */
public class Phasing_MAD_set extends org.pdb.beans.Phasing_MAD_set implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MAD_set";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MAD_set()
	{
	}

	/** Full constructor */
	public Phasing_MAD_set(
		Datablock datablock,
		java.lang.String clust_id,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String expt_id,
		java.lang.Float f_double_prime,
		java.lang.Float f_prime,
		java.lang.String pdbx_atom_type,
		java.lang.Float pdbx_f_double_prime_refined,
		java.lang.Float pdbx_f_prime_refined,
		java.lang.String set_id,
		java.lang.Float wavelength,
		java.lang.String wavelength_details)
	{
		this.datablock = datablock;
		this.clust_id = clust_id;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.expt_id = expt_id;
		this.f_double_prime = f_double_prime;
		this.f_prime = f_prime;
		this.pdbx_atom_type = pdbx_atom_type;
		this.pdbx_f_double_prime_refined = pdbx_f_double_prime_refined;
		this.pdbx_f_prime_refined = pdbx_f_prime_refined;
		this.set_id = set_id;
		this.wavelength = wavelength;
		this.wavelength_details = wavelength_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MAD_set");
		sb.append("\n");
		if (clust_id != null)
		{
			sb.append("clust_id = ");
			sb.append(clust_id);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (expt_id != null)
		{
			sb.append("expt_id = ");
			sb.append(expt_id);
			sb.append('\n');
		}
		if (f_double_prime != null)
		{
			sb.append("f_double_prime = ");
			sb.append(f_double_prime);
			sb.append('\n');
		}
		if (f_prime != null)
		{
			sb.append("f_prime = ");
			sb.append(f_prime);
			sb.append('\n');
		}
		if (pdbx_atom_type != null)
		{
			sb.append("pdbx_atom_type = ");
			sb.append(pdbx_atom_type);
			sb.append('\n');
		}
		if (pdbx_f_double_prime_refined != null)
		{
			sb.append("pdbx_f_double_prime_refined = ");
			sb.append(pdbx_f_double_prime_refined);
			sb.append('\n');
		}
		if (pdbx_f_prime_refined != null)
		{
			sb.append("pdbx_f_prime_refined = ");
			sb.append(pdbx_f_prime_refined);
			sb.append('\n');
		}
		if (set_id != null)
		{
			sb.append("set_id = ");
			sb.append(set_id);
			sb.append('\n');
		}
		if (wavelength != null)
		{
			sb.append("wavelength = ");
			sb.append(wavelength);
			sb.append('\n');
		}
		if (wavelength_details != null)
		{
			sb.append("wavelength_details = ");
			sb.append(wavelength_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		clust_id = null;
		d_res_high = null;
		d_res_low = null;
		expt_id = null;
		f_double_prime = null;
		f_prime = null;
		pdbx_atom_type = null;
		pdbx_f_double_prime_refined = null;
		pdbx_f_prime_refined = null;
		set_id = null;
		wavelength = null;
		wavelength_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MAD_set)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MAD_set>\n");
			if (clust_id != null) ow.write(indent + " <PDBx:clust_id>" + clust_id + "</PDBx:clust_id>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (expt_id != null) ow.write(indent + " <PDBx:expt_id>" + expt_id + "</PDBx:expt_id>\n");
			if (f_double_prime != null) ow.write(indent + " <PDBx:f_double_prime>" + f_double_prime + "</PDBx:f_double_prime>\n");
			if (f_prime != null) ow.write(indent + " <PDBx:f_prime>" + f_prime + "</PDBx:f_prime>\n");
			if (pdbx_atom_type != null) ow.write(indent + " <PDBx:pdbx_atom_type>" + pdbx_atom_type + "</PDBx:pdbx_atom_type>\n");
			if (pdbx_f_double_prime_refined != null) ow.write(indent + " <PDBx:pdbx_f_double_prime_refined>" + pdbx_f_double_prime_refined + "</PDBx:pdbx_f_double_prime_refined>\n");
			if (pdbx_f_prime_refined != null) ow.write(indent + " <PDBx:pdbx_f_prime_refined>" + pdbx_f_prime_refined + "</PDBx:pdbx_f_prime_refined>\n");
			if (set_id != null) ow.write(indent + " <PDBx:set_id>" + set_id + "</PDBx:set_id>\n");
			if (wavelength != null) ow.write(indent + " <PDBx:wavelength>" + wavelength + "</PDBx:wavelength>\n");
			if (wavelength_details != null) ow.write(indent + " <PDBx:wavelength_details>" + wavelength_details + "</PDBx:wavelength_details>\n");
			ow.write(indent + "</PDBx:phasing_MAD_set>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
