package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MIR category record details about
 *  the phasing of the structure where methods involving isomorphous
 *  replacement are involved.
 *  
 *  All isomorphous-replacement-based techniques are covered
 *  by this category, including single isomorphous replacement (SIR),
 *  multiple isomorphous replacement (MIR) and single or multiple
 *  isomorphous replacement plus anomalous scattering (SIRAS, MIRAS).
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738].
 *  <PDBx:phasing_MIRCategory>
 *  <PDBx:phasing_MIR>
 *  <PDBx:method> Standard phase refinement (Blow &amp; Crick, 1959)</PDBx:method>
 *  </PDBx:phasing_MIR>
 *  </PDBx:phasing_MIRCategory>
 * </pre>
 */
public class Phasing_MIR extends org.pdb.beans.Phasing_MIR implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MIR";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MIR()
	{
	}

	/** Full constructor */
	public Phasing_MIR(
		Datablock datablock,
		java.lang.Float FOM,
		java.lang.Float FOM_acentric,
		java.lang.Float FOM_centric,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method,
		java.lang.Integer pdbx_number_derivatives,
		java.lang.Integer reflns,
		java.lang.Integer reflns_acentric,
		java.lang.Integer reflns_centric,
		java.lang.String reflns_criterion)
	{
		this.datablock = datablock;
		this.FOM = FOM;
		this.FOM_acentric = FOM_acentric;
		this.FOM_centric = FOM_centric;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
		this.pdbx_number_derivatives = pdbx_number_derivatives;
		this.reflns = reflns;
		this.reflns_acentric = reflns_acentric;
		this.reflns_centric = reflns_centric;
		this.reflns_criterion = reflns_criterion;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MIR");
		sb.append("\n");
		if (FOM != null)
		{
			sb.append("FOM = ");
			sb.append(FOM);
			sb.append('\n');
		}
		if (FOM_acentric != null)
		{
			sb.append("FOM_acentric = ");
			sb.append(FOM_acentric);
			sb.append('\n');
		}
		if (FOM_centric != null)
		{
			sb.append("FOM_centric = ");
			sb.append(FOM_centric);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (pdbx_number_derivatives != null)
		{
			sb.append("pdbx_number_derivatives = ");
			sb.append(pdbx_number_derivatives);
			sb.append('\n');
		}
		if (reflns != null)
		{
			sb.append("reflns = ");
			sb.append(reflns);
			sb.append('\n');
		}
		if (reflns_acentric != null)
		{
			sb.append("reflns_acentric = ");
			sb.append(reflns_acentric);
			sb.append('\n');
		}
		if (reflns_centric != null)
		{
			sb.append("reflns_centric = ");
			sb.append(reflns_centric);
			sb.append('\n');
		}
		if (reflns_criterion != null)
		{
			sb.append("reflns_criterion = ");
			sb.append(reflns_criterion);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		FOM = null;
		FOM_acentric = null;
		FOM_centric = null;
		d_res_high = null;
		d_res_low = null;
		details = null;
		entry_id = null;
		method = null;
		pdbx_number_derivatives = null;
		reflns = null;
		reflns_acentric = null;
		reflns_centric = null;
		reflns_criterion = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MIR)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MIR>\n");
			if (FOM != null) ow.write(indent + " <PDBx:FOM>" + FOM + "</PDBx:FOM>\n");
			if (FOM_acentric != null) ow.write(indent + " <PDBx:FOM_acentric>" + FOM_acentric + "</PDBx:FOM_acentric>\n");
			if (FOM_centric != null) ow.write(indent + " <PDBx:FOM_centric>" + FOM_centric + "</PDBx:FOM_centric>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (pdbx_number_derivatives != null) ow.write(indent + " <PDBx:pdbx_number_derivatives>" + pdbx_number_derivatives + "</PDBx:pdbx_number_derivatives>\n");
			if (reflns != null) ow.write(indent + " <PDBx:reflns>" + reflns + "</PDBx:reflns>\n");
			if (reflns_acentric != null) ow.write(indent + " <PDBx:reflns_acentric>" + reflns_acentric + "</PDBx:reflns_acentric>\n");
			if (reflns_centric != null) ow.write(indent + " <PDBx:reflns_centric>" + reflns_centric + "</PDBx:reflns_centric>\n");
			if (reflns_criterion != null) ow.write(indent + " <PDBx:reflns_criterion>" + reflns_criterion + "</PDBx:reflns_criterion>\n");
			ow.write(indent + "</PDBx:phasing_MIR>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
