package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MIR_DER_SHELL category record
 *  statistics, broken down into shells of resolution, for an MIR
 *  phasing experiment.
 *  
 *  This list may contain information from a number of different
 *  derivatives;  attribute der_id in category phasing_MIR_der_shell indicates to which
 *  derivative a given record corresponds. (A derivative in this
 *  context does not necessarily equate with a data set; see the
 *  definition of the PHASING_MIR_DER category for a
 *  discussion of the meaning of derivative.)
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738]
 *  with addition of an arbitrary low-resolution limit.
 *  <PDBx:phasing_MIR_der_shellCategory>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:ha_ampl>54.</PDBx:ha_ampl>
 *  <PDBx:loc>26.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:ha_ampl>54.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:ha_ampl>50.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:ha_ampl>44.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:ha_ampl>39.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:ha_ampl>33.</PDBx:ha_ampl>
 *  <PDBx:loc>21.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:ha_ampl>28.</PDBx:ha_ampl>
 *  <PDBx:loc>17.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="KAu(CN)2" d_res_low="15.0" d_res_high="3.0">
 *  <PDBx:ha_ampl>38.</PDBx:ha_ampl>
 *  <PDBx:loc>21.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:ha_ampl>149.</PDBx:ha_ampl>
 *  <PDBx:loc>87.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:ha_ampl>121.</PDBx:ha_ampl>
 *  <PDBx:loc>73.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:ha_ampl>95.</PDBx:ha_ampl>
 *  <PDBx:loc>61.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:ha_ampl>80.</PDBx:ha_ampl>
 *  <PDBx:loc>60.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:ha_ampl>73.</PDBx:ha_ampl>
 *  <PDBx:loc>63.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:ha_ampl>68.</PDBx:ha_ampl>
 *  <PDBx:loc>57.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:ha_ampl>63.</PDBx:ha_ampl>
 *  <PDBx:loc>46.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K2HgI4" d_res_low="15.0" d_res_high="3.0">
 *  <PDBx:ha_ampl>79.</PDBx:ha_ampl>
 *  <PDBx:loc>58.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:ha_ampl>33.</PDBx:ha_ampl>
 *  <PDBx:loc>27.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:ha_ampl>40.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:ha_ampl>31.</PDBx:ha_ampl>
 *  <PDBx:loc>22.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:ha_ampl>27.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:ha_ampl>22.</PDBx:ha_ampl>
 *  <PDBx:loc>23.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:ha_ampl>19.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:ha_ampl>16.</PDBx:ha_ampl>
 *  <PDBx:loc>20.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  <PDBx:phasing_MIR_der_shell der_id="K3IrCl6" d_res_low="15.0" d_res_high="3.0">
 *  <PDBx:ha_ampl>23.</PDBx:ha_ampl>
 *  <PDBx:loc>21.</PDBx:loc>
 *  </PDBx:phasing_MIR_der_shell>
 *  </PDBx:phasing_MIR_der_shellCategory>
 * </pre>
 */
public class Phasing_MIR_der_shell extends org.pdb.beans.Phasing_MIR_der_shell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MIR_der_shell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MIR_der_shell()
	{
	}

	/** Full constructor */
	public Phasing_MIR_der_shell(
		Datablock datablock,
		java.lang.Float R_cullis,
		java.lang.Float R_kraut,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String der_id,
		java.lang.Float fom,
		java.lang.Float ha_ampl,
		java.lang.Float loc,
		java.lang.Float pdbx_R_cullis_acentric,
		java.lang.Float pdbx_R_cullis_centric,
		java.lang.Float pdbx_R_kraut_acentric,
		java.lang.Float pdbx_R_kraut_centric,
		java.lang.Float pdbx_fom_acentric,
		java.lang.Float pdbx_fom_centric,
		java.lang.Float pdbx_loc_acentric,
		java.lang.Float pdbx_loc_centric,
		java.lang.Float pdbx_power_acentric,
		java.lang.Float pdbx_power_centric,
		java.lang.Integer pdbx_reflns_acentric,
		java.lang.Float pdbx_reflns_centric,
		java.lang.Float phase,
		java.lang.Float power,
		java.lang.Integer reflns)
	{
		this.datablock = datablock;
		this.R_cullis = R_cullis;
		this.R_kraut = R_kraut;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.der_id = der_id;
		this.fom = fom;
		this.ha_ampl = ha_ampl;
		this.loc = loc;
		this.pdbx_R_cullis_acentric = pdbx_R_cullis_acentric;
		this.pdbx_R_cullis_centric = pdbx_R_cullis_centric;
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
		this.pdbx_fom_acentric = pdbx_fom_acentric;
		this.pdbx_fom_centric = pdbx_fom_centric;
		this.pdbx_loc_acentric = pdbx_loc_acentric;
		this.pdbx_loc_centric = pdbx_loc_centric;
		this.pdbx_power_acentric = pdbx_power_acentric;
		this.pdbx_power_centric = pdbx_power_centric;
		this.pdbx_reflns_acentric = pdbx_reflns_acentric;
		this.pdbx_reflns_centric = pdbx_reflns_centric;
		this.phase = phase;
		this.power = power;
		this.reflns = reflns;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MIR_der_shell");
		sb.append("\n");
		if (R_cullis != null)
		{
			sb.append("R_cullis = ");
			sb.append(R_cullis);
			sb.append('\n');
		}
		if (R_kraut != null)
		{
			sb.append("R_kraut = ");
			sb.append(R_kraut);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (der_id != null)
		{
			sb.append("der_id = ");
			sb.append(der_id);
			sb.append('\n');
		}
		if (fom != null)
		{
			sb.append("fom = ");
			sb.append(fom);
			sb.append('\n');
		}
		if (ha_ampl != null)
		{
			sb.append("ha_ampl = ");
			sb.append(ha_ampl);
			sb.append('\n');
		}
		if (loc != null)
		{
			sb.append("loc = ");
			sb.append(loc);
			sb.append('\n');
		}
		if (pdbx_R_cullis_acentric != null)
		{
			sb.append("pdbx_R_cullis_acentric = ");
			sb.append(pdbx_R_cullis_acentric);
			sb.append('\n');
		}
		if (pdbx_R_cullis_centric != null)
		{
			sb.append("pdbx_R_cullis_centric = ");
			sb.append(pdbx_R_cullis_centric);
			sb.append('\n');
		}
		if (pdbx_R_kraut_acentric != null)
		{
			sb.append("pdbx_R_kraut_acentric = ");
			sb.append(pdbx_R_kraut_acentric);
			sb.append('\n');
		}
		if (pdbx_R_kraut_centric != null)
		{
			sb.append("pdbx_R_kraut_centric = ");
			sb.append(pdbx_R_kraut_centric);
			sb.append('\n');
		}
		if (pdbx_fom_acentric != null)
		{
			sb.append("pdbx_fom_acentric = ");
			sb.append(pdbx_fom_acentric);
			sb.append('\n');
		}
		if (pdbx_fom_centric != null)
		{
			sb.append("pdbx_fom_centric = ");
			sb.append(pdbx_fom_centric);
			sb.append('\n');
		}
		if (pdbx_loc_acentric != null)
		{
			sb.append("pdbx_loc_acentric = ");
			sb.append(pdbx_loc_acentric);
			sb.append('\n');
		}
		if (pdbx_loc_centric != null)
		{
			sb.append("pdbx_loc_centric = ");
			sb.append(pdbx_loc_centric);
			sb.append('\n');
		}
		if (pdbx_power_acentric != null)
		{
			sb.append("pdbx_power_acentric = ");
			sb.append(pdbx_power_acentric);
			sb.append('\n');
		}
		if (pdbx_power_centric != null)
		{
			sb.append("pdbx_power_centric = ");
			sb.append(pdbx_power_centric);
			sb.append('\n');
		}
		if (pdbx_reflns_acentric != null)
		{
			sb.append("pdbx_reflns_acentric = ");
			sb.append(pdbx_reflns_acentric);
			sb.append('\n');
		}
		if (pdbx_reflns_centric != null)
		{
			sb.append("pdbx_reflns_centric = ");
			sb.append(pdbx_reflns_centric);
			sb.append('\n');
		}
		if (phase != null)
		{
			sb.append("phase = ");
			sb.append(phase);
			sb.append('\n');
		}
		if (power != null)
		{
			sb.append("power = ");
			sb.append(power);
			sb.append('\n');
		}
		if (reflns != null)
		{
			sb.append("reflns = ");
			sb.append(reflns);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_cullis = null;
		R_kraut = null;
		d_res_high = null;
		d_res_low = null;
		der_id = null;
		fom = null;
		ha_ampl = null;
		loc = null;
		pdbx_R_cullis_acentric = null;
		pdbx_R_cullis_centric = null;
		pdbx_R_kraut_acentric = null;
		pdbx_R_kraut_centric = null;
		pdbx_fom_acentric = null;
		pdbx_fom_centric = null;
		pdbx_loc_acentric = null;
		pdbx_loc_centric = null;
		pdbx_power_acentric = null;
		pdbx_power_centric = null;
		pdbx_reflns_acentric = null;
		pdbx_reflns_centric = null;
		phase = null;
		power = null;
		reflns = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MIR_der_shell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MIR_der_shell>\n");
			if (R_cullis != null) ow.write(indent + " <PDBx:R_cullis>" + R_cullis + "</PDBx:R_cullis>\n");
			if (R_kraut != null) ow.write(indent + " <PDBx:R_kraut>" + R_kraut + "</PDBx:R_kraut>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (der_id != null) ow.write(indent + " <PDBx:der_id>" + der_id + "</PDBx:der_id>\n");
			if (fom != null) ow.write(indent + " <PDBx:fom>" + fom + "</PDBx:fom>\n");
			if (ha_ampl != null) ow.write(indent + " <PDBx:ha_ampl>" + ha_ampl + "</PDBx:ha_ampl>\n");
			if (loc != null) ow.write(indent + " <PDBx:loc>" + loc + "</PDBx:loc>\n");
			if (pdbx_R_cullis_acentric != null) ow.write(indent + " <PDBx:pdbx_R_cullis_acentric>" + pdbx_R_cullis_acentric + "</PDBx:pdbx_R_cullis_acentric>\n");
			if (pdbx_R_cullis_centric != null) ow.write(indent + " <PDBx:pdbx_R_cullis_centric>" + pdbx_R_cullis_centric + "</PDBx:pdbx_R_cullis_centric>\n");
			if (pdbx_R_kraut_acentric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_acentric>" + pdbx_R_kraut_acentric + "</PDBx:pdbx_R_kraut_acentric>\n");
			if (pdbx_R_kraut_centric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_centric>" + pdbx_R_kraut_centric + "</PDBx:pdbx_R_kraut_centric>\n");
			if (pdbx_fom_acentric != null) ow.write(indent + " <PDBx:pdbx_fom_acentric>" + pdbx_fom_acentric + "</PDBx:pdbx_fom_acentric>\n");
			if (pdbx_fom_centric != null) ow.write(indent + " <PDBx:pdbx_fom_centric>" + pdbx_fom_centric + "</PDBx:pdbx_fom_centric>\n");
			if (pdbx_loc_acentric != null) ow.write(indent + " <PDBx:pdbx_loc_acentric>" + pdbx_loc_acentric + "</PDBx:pdbx_loc_acentric>\n");
			if (pdbx_loc_centric != null) ow.write(indent + " <PDBx:pdbx_loc_centric>" + pdbx_loc_centric + "</PDBx:pdbx_loc_centric>\n");
			if (pdbx_power_acentric != null) ow.write(indent + " <PDBx:pdbx_power_acentric>" + pdbx_power_acentric + "</PDBx:pdbx_power_acentric>\n");
			if (pdbx_power_centric != null) ow.write(indent + " <PDBx:pdbx_power_centric>" + pdbx_power_centric + "</PDBx:pdbx_power_centric>\n");
			if (pdbx_reflns_acentric != null) ow.write(indent + " <PDBx:pdbx_reflns_acentric>" + pdbx_reflns_acentric + "</PDBx:pdbx_reflns_acentric>\n");
			if (pdbx_reflns_centric != null) ow.write(indent + " <PDBx:pdbx_reflns_centric>" + pdbx_reflns_centric + "</PDBx:pdbx_reflns_centric>\n");
			if (phase != null) ow.write(indent + " <PDBx:phase>" + phase + "</PDBx:phase>\n");
			if (power != null) ow.write(indent + " <PDBx:power>" + power + "</PDBx:power>\n");
			if (reflns != null) ow.write(indent + " <PDBx:reflns>" + reflns + "</PDBx:reflns>\n");
			ow.write(indent + "</PDBx:phasing_MIR_der_shell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
