package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MIR_DER_SITE category record details
 *  about the heavy-atom sites in an MIR phasing experiment.
 *  
 *  This list may contain information from a number of different
 *  derivatives;  attribute der_id in category phasing_MIR_der_site indicates to which
 *  derivative a given record corresponds. (A derivative in this
 *  context does not necessarily equate with a data set; see the
 *  definition of the PHASING_MIR_DER category for a
 *  discussion of the meaning of derivative.)
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738]
 *  with occupancies converted from electrons to fractional.
 *  <PDBx:phasing_MIR_der_siteCategory>
 *  <PDBx:phasing_MIR_der_site der_id="KAu(CN)2" id="1">
 *  <PDBx:atom_type_symbol>Au</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.40</PDBx:occupancy>
 *  <PDBx:fract_x>0.082</PDBx:fract_x>
 *  <PDBx:fract_y>0.266</PDBx:fract_y>
 *  <PDBx:fract_z>0.615</PDBx:fract_z>
 *  <PDBx:B_iso>33.0</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="KAu(CN)2" id="2">
 *  <PDBx:atom_type_symbol>Au</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.03</PDBx:occupancy>
 *  <PDBx:fract_x>0.607</PDBx:fract_x>
 *  <PDBx:fract_y>0.217</PDBx:fract_y>
 *  <PDBx:fract_z>0.816</PDBx:fract_z>
 *  <PDBx:B_iso>25.9</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="KAu(CN)2" id="3">
 *  <PDBx:atom_type_symbol>Au</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.02</PDBx:occupancy>
 *  <PDBx:fract_x>0.263</PDBx:fract_x>
 *  <PDBx:fract_y>0.782</PDBx:fract_y>
 *  <PDBx:fract_z>0.906</PDBx:fract_z>
 *  <PDBx:B_iso>15.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="1">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.63</PDBx:occupancy>
 *  <PDBx:fract_x>0.048</PDBx:fract_x>
 *  <PDBx:fract_y>0.286</PDBx:fract_y>
 *  <PDBx:fract_z>0.636</PDBx:fract_z>
 *  <PDBx:B_iso>33.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="2">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.34</PDBx:occupancy>
 *  <PDBx:fract_x>0.913</PDBx:fract_x>
 *  <PDBx:fract_y>0.768</PDBx:fract_y>
 *  <PDBx:fract_z>0.889</PDBx:fract_z>
 *  <PDBx:B_iso>36.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="3">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.23</PDBx:occupancy>
 *  <PDBx:fract_x>0.974</PDBx:fract_x>
 *  <PDBx:fract_y>0.455</PDBx:fract_y>
 *  <PDBx:fract_z>0.974</PDBx:fract_z>
 *  <PDBx:B_iso>24.2</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="4">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.28</PDBx:occupancy>
 *  <PDBx:fract_x>0.903</PDBx:fract_x>
 *  <PDBx:fract_y>0.836</PDBx:fract_y>
 *  <PDBx:fract_z>0.859</PDBx:fract_z>
 *  <PDBx:B_iso>14.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="5">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.07</PDBx:occupancy>
 *  <PDBx:fract_x>0.489</PDBx:fract_x>
 *  <PDBx:fract_y>0.200</PDBx:fract_y>
 *  <PDBx:fract_z>0.885</PDBx:fract_z>
 *  <PDBx:B_iso>6.4</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="6">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.07</PDBx:occupancy>
 *  <PDBx:fract_x>0.162</PDBx:fract_x>
 *  <PDBx:fract_y>0.799</PDBx:fract_y>
 *  <PDBx:fract_z>0.889</PDBx:fract_z>
 *  <PDBx:B_iso>32.9</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K3IrCl6" id="1">
 *  <PDBx:atom_type_symbol>Ir</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.26</PDBx:occupancy>
 *  <PDBx:fract_x>0.209</PDBx:fract_x>
 *  <PDBx:fract_y>0.739</PDBx:fract_y>
 *  <PDBx:fract_z>0.758</PDBx:fract_z>
 *  <PDBx:B_iso>40.8</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K3IrCl6" id="2">
 *  <PDBx:atom_type_symbol>Ir</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.05</PDBx:occupancy>
 *  <PDBx:fract_x>0.279</PDBx:fract_x>
 *  <PDBx:fract_y>0.613</PDBx:fract_y>
 *  <PDBx:fract_z>0.752</PDBx:fract_z>
 *  <PDBx:B_iso>24.9</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  </PDBx:phasing_MIR_der_siteCategory>
 * </pre>
 */
public class Phasing_MIR_der_site extends org.pdb.beans.Phasing_MIR_der_site implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MIR_der_site";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MIR_der_site()
	{
	}

	/** Full constructor */
	public Phasing_MIR_der_site(
		Datablock datablock,
		java.lang.Float B_iso,
		java.lang.Float B_iso_esd,
		java.lang.Float Cartn_x,
		java.lang.Float Cartn_x_esd,
		java.lang.Float Cartn_y,
		java.lang.Float Cartn_y_esd,
		java.lang.Float Cartn_z,
		java.lang.Float Cartn_z_esd,
		java.lang.String atom_type_symbol,
		java.lang.String der_id,
		java.lang.String details,
		java.lang.Float fract_x,
		java.lang.Float fract_x_esd,
		java.lang.Float fract_y,
		java.lang.Float fract_y_esd,
		java.lang.Float fract_z,
		java.lang.Float fract_z_esd,
		java.lang.String id_,
		java.lang.Float occupancy,
		java.lang.Float occupancy_anom,
		java.lang.Float occupancy_anom_su,
		java.lang.Float occupancy_iso,
		java.lang.Float occupancy_iso_su)
	{
		this.datablock = datablock;
		this.B_iso = B_iso;
		this.B_iso_esd = B_iso_esd;
		this.Cartn_x = Cartn_x;
		this.Cartn_x_esd = Cartn_x_esd;
		this.Cartn_y = Cartn_y;
		this.Cartn_y_esd = Cartn_y_esd;
		this.Cartn_z = Cartn_z;
		this.Cartn_z_esd = Cartn_z_esd;
		this.atom_type_symbol = atom_type_symbol;
		this.der_id = der_id;
		this.details = details;
		this.fract_x = fract_x;
		this.fract_x_esd = fract_x_esd;
		this.fract_y = fract_y;
		this.fract_y_esd = fract_y_esd;
		this.fract_z = fract_z;
		this.fract_z_esd = fract_z_esd;
		this.id_ = id_;
		this.occupancy = occupancy;
		this.occupancy_anom = occupancy_anom;
		this.occupancy_anom_su = occupancy_anom_su;
		this.occupancy_iso = occupancy_iso;
		this.occupancy_iso_su = occupancy_iso_su;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MIR_der_site");
		sb.append("\n");
		if (B_iso != null)
		{
			sb.append("B_iso = ");
			sb.append(B_iso);
			sb.append('\n');
		}
		if (B_iso_esd != null)
		{
			sb.append("B_iso_esd = ");
			sb.append(B_iso_esd);
			sb.append('\n');
		}
		if (Cartn_x != null)
		{
			sb.append("Cartn_x = ");
			sb.append(Cartn_x);
			sb.append('\n');
		}
		if (Cartn_x_esd != null)
		{
			sb.append("Cartn_x_esd = ");
			sb.append(Cartn_x_esd);
			sb.append('\n');
		}
		if (Cartn_y != null)
		{
			sb.append("Cartn_y = ");
			sb.append(Cartn_y);
			sb.append('\n');
		}
		if (Cartn_y_esd != null)
		{
			sb.append("Cartn_y_esd = ");
			sb.append(Cartn_y_esd);
			sb.append('\n');
		}
		if (Cartn_z != null)
		{
			sb.append("Cartn_z = ");
			sb.append(Cartn_z);
			sb.append('\n');
		}
		if (Cartn_z_esd != null)
		{
			sb.append("Cartn_z_esd = ");
			sb.append(Cartn_z_esd);
			sb.append('\n');
		}
		if (atom_type_symbol != null)
		{
			sb.append("atom_type_symbol = ");
			sb.append(atom_type_symbol);
			sb.append('\n');
		}
		if (der_id != null)
		{
			sb.append("der_id = ");
			sb.append(der_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (fract_x != null)
		{
			sb.append("fract_x = ");
			sb.append(fract_x);
			sb.append('\n');
		}
		if (fract_x_esd != null)
		{
			sb.append("fract_x_esd = ");
			sb.append(fract_x_esd);
			sb.append('\n');
		}
		if (fract_y != null)
		{
			sb.append("fract_y = ");
			sb.append(fract_y);
			sb.append('\n');
		}
		if (fract_y_esd != null)
		{
			sb.append("fract_y_esd = ");
			sb.append(fract_y_esd);
			sb.append('\n');
		}
		if (fract_z != null)
		{
			sb.append("fract_z = ");
			sb.append(fract_z);
			sb.append('\n');
		}
		if (fract_z_esd != null)
		{
			sb.append("fract_z_esd = ");
			sb.append(fract_z_esd);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (occupancy != null)
		{
			sb.append("occupancy = ");
			sb.append(occupancy);
			sb.append('\n');
		}
		if (occupancy_anom != null)
		{
			sb.append("occupancy_anom = ");
			sb.append(occupancy_anom);
			sb.append('\n');
		}
		if (occupancy_anom_su != null)
		{
			sb.append("occupancy_anom_su = ");
			sb.append(occupancy_anom_su);
			sb.append('\n');
		}
		if (occupancy_iso != null)
		{
			sb.append("occupancy_iso = ");
			sb.append(occupancy_iso);
			sb.append('\n');
		}
		if (occupancy_iso_su != null)
		{
			sb.append("occupancy_iso_su = ");
			sb.append(occupancy_iso_su);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		B_iso = null;
		B_iso_esd = null;
		Cartn_x = null;
		Cartn_x_esd = null;
		Cartn_y = null;
		Cartn_y_esd = null;
		Cartn_z = null;
		Cartn_z_esd = null;
		atom_type_symbol = null;
		der_id = null;
		details = null;
		fract_x = null;
		fract_x_esd = null;
		fract_y = null;
		fract_y_esd = null;
		fract_z = null;
		fract_z_esd = null;
		id_ = null;
		occupancy = null;
		occupancy_anom = null;
		occupancy_anom_su = null;
		occupancy_iso = null;
		occupancy_iso_su = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MIR_der_site)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MIR_der_site>\n");
			if (B_iso != null) ow.write(indent + " <PDBx:B_iso>" + B_iso + "</PDBx:B_iso>\n");
			if (B_iso_esd != null) ow.write(indent + " <PDBx:B_iso_esd>" + B_iso_esd + "</PDBx:B_iso_esd>\n");
			if (Cartn_x != null) ow.write(indent + " <PDBx:Cartn_x>" + Cartn_x + "</PDBx:Cartn_x>\n");
			if (Cartn_x_esd != null) ow.write(indent + " <PDBx:Cartn_x_esd>" + Cartn_x_esd + "</PDBx:Cartn_x_esd>\n");
			if (Cartn_y != null) ow.write(indent + " <PDBx:Cartn_y>" + Cartn_y + "</PDBx:Cartn_y>\n");
			if (Cartn_y_esd != null) ow.write(indent + " <PDBx:Cartn_y_esd>" + Cartn_y_esd + "</PDBx:Cartn_y_esd>\n");
			if (Cartn_z != null) ow.write(indent + " <PDBx:Cartn_z>" + Cartn_z + "</PDBx:Cartn_z>\n");
			if (Cartn_z_esd != null) ow.write(indent + " <PDBx:Cartn_z_esd>" + Cartn_z_esd + "</PDBx:Cartn_z_esd>\n");
			if (atom_type_symbol != null) ow.write(indent + " <PDBx:atom_type_symbol>" + atom_type_symbol + "</PDBx:atom_type_symbol>\n");
			if (der_id != null) ow.write(indent + " <PDBx:der_id>" + der_id + "</PDBx:der_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (fract_x != null) ow.write(indent + " <PDBx:fract_x>" + fract_x + "</PDBx:fract_x>\n");
			if (fract_x_esd != null) ow.write(indent + " <PDBx:fract_x_esd>" + fract_x_esd + "</PDBx:fract_x_esd>\n");
			if (fract_y != null) ow.write(indent + " <PDBx:fract_y>" + fract_y + "</PDBx:fract_y>\n");
			if (fract_y_esd != null) ow.write(indent + " <PDBx:fract_y_esd>" + fract_y_esd + "</PDBx:fract_y_esd>\n");
			if (fract_z != null) ow.write(indent + " <PDBx:fract_z>" + fract_z + "</PDBx:fract_z>\n");
			if (fract_z_esd != null) ow.write(indent + " <PDBx:fract_z_esd>" + fract_z_esd + "</PDBx:fract_z_esd>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (occupancy != null) ow.write(indent + " <PDBx:occupancy>" + occupancy + "</PDBx:occupancy>\n");
			if (occupancy_anom != null) ow.write(indent + " <PDBx:occupancy_anom>" + occupancy_anom + "</PDBx:occupancy_anom>\n");
			if (occupancy_anom_su != null) ow.write(indent + " <PDBx:occupancy_anom_su>" + occupancy_anom_su + "</PDBx:occupancy_anom_su>\n");
			if (occupancy_iso != null) ow.write(indent + " <PDBx:occupancy_iso>" + occupancy_iso + "</PDBx:occupancy_iso>\n");
			if (occupancy_iso_su != null) ow.write(indent + " <PDBx:occupancy_iso_su>" + occupancy_iso_su + "</PDBx:occupancy_iso_su>\n");
			ow.write(indent + "</PDBx:phasing_MIR_der_site>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
