package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_ISOMORPHOUS category record details
 *  about the phasing of the structure where a model isomorphous
 *  to the structure being phased was used to generate the initial
 *  phases.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 4PHV and laboratory records for the
 *  structure corresponding to PDB entry 4PHV.
 *  <PDBx:phasing_isomorphousCategory>
 *  <PDBx:phasing_isomorphous>
 *  <PDBx:parent>PDB entry 5HVP</PDBx:parent>
 *  <PDBx:details> The inhibitor and all solvent atoms were removed from the
 *  parent structure before beginning refinement. All static
 *  disorder present in the parent structure was also removed.</PDBx:details>
 *  </PDBx:phasing_isomorphous>
 *  </PDBx:phasing_isomorphousCategory>
 * </pre>
 */
public class Phasing_isomorphous extends org.pdb.beans.Phasing_isomorphous implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_isomorphous";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_isomorphous()
	{
	}

	/** Full constructor */
	public Phasing_isomorphous(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method,
		java.lang.String parent)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
		this.parent = parent;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_isomorphous");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (parent != null)
		{
			sb.append("parent = ");
			sb.append(parent);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		method = null;
		parent = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_isomorphous)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_isomorphous>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (parent != null) ow.write(indent + " <PDBx:parent>" + parent + "</PDBx:parent>\n");
			ow.write(indent + "</PDBx:phasing_isomorphous>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
