package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_SET category record details about
 *  the data sets used in a phasing experiment. A given data set
 *  may be used in a number of different ways; for instance, a
 *  single data set could be used both as an isomorphous derivative
 *  and as a component of a multiple-wavelength calculation. This
 *  category establishes identifiers for each data set and permits
 *  the archiving of a subset of experimental information for each
 *  data set (cell constants, wavelength, temperature etc.).
 *  
 *  This and related categories of data items are provided so that
 *  derivative intensity and phase information can be stored in
 *  the same data block as the information for the refined
 *  structure.
 *  
 *  If all the possible experimental information for each data
 *  set (raw data sets, crystal growth conditions etc.) is to be
 *  archived, these data items should be recorded in a separate
 *  data block.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for an Hg/Pt derivative of
 *  protein NS1.
 *  <PDBx:phasing_setCategory>
 *  <PDBx:phasing_set id="NS1-96">
 *  <PDBx:cell_angle_alpha>90.0</PDBx:cell_angle_alpha>
 *  <PDBx:cell_angle_beta>90.0</PDBx:cell_angle_beta>
 *  <PDBx:cell_angle_gamma>90.0</PDBx:cell_angle_gamma>
 *  <PDBx:cell_length_a>38.63</PDBx:cell_length_a>
 *  <PDBx:cell_length_b>38.63</PDBx:cell_length_b>
 *  <PDBx:cell_length_c>82.88</PDBx:cell_length_c>
 *  <PDBx:radiation_wavelength>1.5145</PDBx:radiation_wavelength>
 *  <PDBx:detector_type>image plate</PDBx:detector_type>
 *  <PDBx:detector_specific>RXII</PDBx:detector_specific>
 *  </PDBx:phasing_set>
 *  </PDBx:phasing_setCategory>
 * </pre>
 */
public class Phasing_set extends org.pdb.beans.Phasing_set implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_set";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_set()
	{
	}

	/** Full constructor */
	public Phasing_set(
		Datablock datablock,
		java.lang.Float cell_angle_alpha,
		java.lang.Float cell_angle_beta,
		java.lang.Float cell_angle_gamma,
		java.lang.Float cell_length_a,
		java.lang.Float cell_length_b,
		java.lang.Float cell_length_c,
		java.lang.String detector_specific,
		java.lang.String detector_type,
		java.lang.String id_,
		java.lang.Float pdbx_d_res_high,
		java.lang.Float pdbx_d_res_low,
		java.lang.String pdbx_temp_details,
		java.lang.String radiation_source_specific,
		java.lang.Float radiation_wavelength,
		java.lang.Float temp)
	{
		this.datablock = datablock;
		this.cell_angle_alpha = cell_angle_alpha;
		this.cell_angle_beta = cell_angle_beta;
		this.cell_angle_gamma = cell_angle_gamma;
		this.cell_length_a = cell_length_a;
		this.cell_length_b = cell_length_b;
		this.cell_length_c = cell_length_c;
		this.detector_specific = detector_specific;
		this.detector_type = detector_type;
		this.id_ = id_;
		this.pdbx_d_res_high = pdbx_d_res_high;
		this.pdbx_d_res_low = pdbx_d_res_low;
		this.pdbx_temp_details = pdbx_temp_details;
		this.radiation_source_specific = radiation_source_specific;
		this.radiation_wavelength = radiation_wavelength;
		this.temp = temp;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_set");
		sb.append("\n");
		if (cell_angle_alpha != null)
		{
			sb.append("cell_angle_alpha = ");
			sb.append(cell_angle_alpha);
			sb.append('\n');
		}
		if (cell_angle_beta != null)
		{
			sb.append("cell_angle_beta = ");
			sb.append(cell_angle_beta);
			sb.append('\n');
		}
		if (cell_angle_gamma != null)
		{
			sb.append("cell_angle_gamma = ");
			sb.append(cell_angle_gamma);
			sb.append('\n');
		}
		if (cell_length_a != null)
		{
			sb.append("cell_length_a = ");
			sb.append(cell_length_a);
			sb.append('\n');
		}
		if (cell_length_b != null)
		{
			sb.append("cell_length_b = ");
			sb.append(cell_length_b);
			sb.append('\n');
		}
		if (cell_length_c != null)
		{
			sb.append("cell_length_c = ");
			sb.append(cell_length_c);
			sb.append('\n');
		}
		if (detector_specific != null)
		{
			sb.append("detector_specific = ");
			sb.append(detector_specific);
			sb.append('\n');
		}
		if (detector_type != null)
		{
			sb.append("detector_type = ");
			sb.append(detector_type);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_d_res_high != null)
		{
			sb.append("pdbx_d_res_high = ");
			sb.append(pdbx_d_res_high);
			sb.append('\n');
		}
		if (pdbx_d_res_low != null)
		{
			sb.append("pdbx_d_res_low = ");
			sb.append(pdbx_d_res_low);
			sb.append('\n');
		}
		if (pdbx_temp_details != null)
		{
			sb.append("pdbx_temp_details = ");
			sb.append(pdbx_temp_details);
			sb.append('\n');
		}
		if (radiation_source_specific != null)
		{
			sb.append("radiation_source_specific = ");
			sb.append(radiation_source_specific);
			sb.append('\n');
		}
		if (radiation_wavelength != null)
		{
			sb.append("radiation_wavelength = ");
			sb.append(radiation_wavelength);
			sb.append('\n');
		}
		if (temp != null)
		{
			sb.append("temp = ");
			sb.append(temp);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		cell_angle_alpha = null;
		cell_angle_beta = null;
		cell_angle_gamma = null;
		cell_length_a = null;
		cell_length_b = null;
		cell_length_c = null;
		detector_specific = null;
		detector_type = null;
		id_ = null;
		pdbx_d_res_high = null;
		pdbx_d_res_low = null;
		pdbx_temp_details = null;
		radiation_source_specific = null;
		radiation_wavelength = null;
		temp = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_set)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_set>\n");
			if (cell_angle_alpha != null) ow.write(indent + " <PDBx:cell_angle_alpha>" + cell_angle_alpha + "</PDBx:cell_angle_alpha>\n");
			if (cell_angle_beta != null) ow.write(indent + " <PDBx:cell_angle_beta>" + cell_angle_beta + "</PDBx:cell_angle_beta>\n");
			if (cell_angle_gamma != null) ow.write(indent + " <PDBx:cell_angle_gamma>" + cell_angle_gamma + "</PDBx:cell_angle_gamma>\n");
			if (cell_length_a != null) ow.write(indent + " <PDBx:cell_length_a>" + cell_length_a + "</PDBx:cell_length_a>\n");
			if (cell_length_b != null) ow.write(indent + " <PDBx:cell_length_b>" + cell_length_b + "</PDBx:cell_length_b>\n");
			if (cell_length_c != null) ow.write(indent + " <PDBx:cell_length_c>" + cell_length_c + "</PDBx:cell_length_c>\n");
			if (detector_specific != null) ow.write(indent + " <PDBx:detector_specific>" + detector_specific + "</PDBx:detector_specific>\n");
			if (detector_type != null) ow.write(indent + " <PDBx:detector_type>" + detector_type + "</PDBx:detector_type>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_d_res_high != null) ow.write(indent + " <PDBx:pdbx_d_res_high>" + pdbx_d_res_high + "</PDBx:pdbx_d_res_high>\n");
			if (pdbx_d_res_low != null) ow.write(indent + " <PDBx:pdbx_d_res_low>" + pdbx_d_res_low + "</PDBx:pdbx_d_res_low>\n");
			if (pdbx_temp_details != null) ow.write(indent + " <PDBx:pdbx_temp_details>" + pdbx_temp_details + "</PDBx:pdbx_temp_details>\n");
			if (radiation_source_specific != null) ow.write(indent + " <PDBx:radiation_source_specific>" + radiation_source_specific + "</PDBx:radiation_source_specific>\n");
			if (radiation_wavelength != null) ow.write(indent + " <PDBx:radiation_wavelength>" + radiation_wavelength + "</PDBx:radiation_wavelength>\n");
			if (temp != null) ow.write(indent + " <PDBx:temp>" + temp + "</PDBx:temp>\n");
			ow.write(indent + "</PDBx:phasing_set>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
