package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PUBL category are used when submitting a
 *  manuscript for publication.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:publCategory>
 *  <PDBx:publ>
 *  <PDBx:section_title>  trans-3-Benzoyl-2-(tert-butyl)-4-(iso-butyl)-
 *  1,3-oxazolidin-5-one</PDBx:section_title>
 *  <PDBx:section_abstract>  The oxazolidinone ring is a shallow envelope
 *  conformation with the tert-butyl and iso-butyl groups
 *  occupying trans-positions with respect to the ring.  The
 *  angles at the N atom sum to 356.2\&#37;, indicating a very
 *  small degree of pyramidalization at this atom.  This is
 *  consistent with electron delocalization between the N
 *  atom and the carbonyl centre [N-C=O = 1.374(3)\&#37;A].</PDBx:section_abstract>
 *  </PDBx:publ>
 *  </PDBx:publCategory>
 *  
 *  
 *  Example 2 - based on C~31~H~48~N~4~O~4~, reported by Coleman, Patrick,
 *  Andersen & Rettig [Acta Cryst. (1996), C52, 1525-1527].
 *  <PDBx:publCategory>
 *  <PDBx:publ>
 *  <PDBx:section_title>  Hemiasterlin methyl ester</PDBx:section_title>
 *  <PDBx:section_title_footnote>  IUPAC name: methyl 2,5-dimethyl-4-{2-[3-methyl-
 *  2-methylamino-3-(N-methylbenzo[b]pyrrol-
 *  3-yl)butanamido]-3,3-dimethyl-N-methyl-
 *  butanamido}-2-hexenoate.</PDBx:section_title_footnote>
 *  </PDBx:publ>
 *  </PDBx:publCategory>
 * </pre>
 */
public class Publ extends org.pdb.beans.Publ implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "publ";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Publ()
	{
	}

	/** Full constructor */
	public Publ(
		Datablock datablock,
		java.lang.String contact_author,
		java.lang.String contact_author_address,
		java.lang.String contact_author_email,
		java.lang.String contact_author_fax,
		java.lang.String contact_author_name,
		java.lang.String contact_author_phone,
		java.lang.String contact_letter,
		java.lang.String entry_id,
		java.lang.String manuscript_creation,
		java.lang.String manuscript_processed,
		java.lang.String manuscript_text,
		java.lang.String requested_category,
		java.lang.String requested_coeditor_name,
		java.lang.String requested_journal,
		java.lang.String section_abstract,
		java.lang.String section_acknowledgements,
		java.lang.String section_comment,
		java.lang.String section_discussion,
		java.lang.String section_experimental,
		java.lang.String section_exptl_prep,
		java.lang.String section_exptl_refinement,
		java.lang.String section_exptl_solution,
		java.lang.String section_figure_captions,
		java.lang.String section_introduction,
		java.lang.String section_references,
		java.lang.String section_synopsis,
		java.lang.String section_table_legends,
		java.lang.String section_title,
		java.lang.String section_title_footnote)
	{
		this.datablock = datablock;
		this.contact_author = contact_author;
		this.contact_author_address = contact_author_address;
		this.contact_author_email = contact_author_email;
		this.contact_author_fax = contact_author_fax;
		this.contact_author_name = contact_author_name;
		this.contact_author_phone = contact_author_phone;
		this.contact_letter = contact_letter;
		this.entry_id = entry_id;
		this.manuscript_creation = manuscript_creation;
		this.manuscript_processed = manuscript_processed;
		this.manuscript_text = manuscript_text;
		this.requested_category = requested_category;
		this.requested_coeditor_name = requested_coeditor_name;
		this.requested_journal = requested_journal;
		this.section_abstract = section_abstract;
		this.section_acknowledgements = section_acknowledgements;
		this.section_comment = section_comment;
		this.section_discussion = section_discussion;
		this.section_experimental = section_experimental;
		this.section_exptl_prep = section_exptl_prep;
		this.section_exptl_refinement = section_exptl_refinement;
		this.section_exptl_solution = section_exptl_solution;
		this.section_figure_captions = section_figure_captions;
		this.section_introduction = section_introduction;
		this.section_references = section_references;
		this.section_synopsis = section_synopsis;
		this.section_table_legends = section_table_legends;
		this.section_title = section_title;
		this.section_title_footnote = section_title_footnote;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Publ");
		sb.append("\n");
		if (contact_author != null)
		{
			sb.append("contact_author = ");
			sb.append(contact_author);
			sb.append('\n');
		}
		if (contact_author_address != null)
		{
			sb.append("contact_author_address = ");
			sb.append(contact_author_address);
			sb.append('\n');
		}
		if (contact_author_email != null)
		{
			sb.append("contact_author_email = ");
			sb.append(contact_author_email);
			sb.append('\n');
		}
		if (contact_author_fax != null)
		{
			sb.append("contact_author_fax = ");
			sb.append(contact_author_fax);
			sb.append('\n');
		}
		if (contact_author_name != null)
		{
			sb.append("contact_author_name = ");
			sb.append(contact_author_name);
			sb.append('\n');
		}
		if (contact_author_phone != null)
		{
			sb.append("contact_author_phone = ");
			sb.append(contact_author_phone);
			sb.append('\n');
		}
		if (contact_letter != null)
		{
			sb.append("contact_letter = ");
			sb.append(contact_letter);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (manuscript_creation != null)
		{
			sb.append("manuscript_creation = ");
			sb.append(manuscript_creation);
			sb.append('\n');
		}
		if (manuscript_processed != null)
		{
			sb.append("manuscript_processed = ");
			sb.append(manuscript_processed);
			sb.append('\n');
		}
		if (manuscript_text != null)
		{
			sb.append("manuscript_text = ");
			sb.append(manuscript_text);
			sb.append('\n');
		}
		if (requested_category != null)
		{
			sb.append("requested_category = ");
			sb.append(requested_category);
			sb.append('\n');
		}
		if (requested_coeditor_name != null)
		{
			sb.append("requested_coeditor_name = ");
			sb.append(requested_coeditor_name);
			sb.append('\n');
		}
		if (requested_journal != null)
		{
			sb.append("requested_journal = ");
			sb.append(requested_journal);
			sb.append('\n');
		}
		if (section_abstract != null)
		{
			sb.append("section_abstract = ");
			sb.append(section_abstract);
			sb.append('\n');
		}
		if (section_acknowledgements != null)
		{
			sb.append("section_acknowledgements = ");
			sb.append(section_acknowledgements);
			sb.append('\n');
		}
		if (section_comment != null)
		{
			sb.append("section_comment = ");
			sb.append(section_comment);
			sb.append('\n');
		}
		if (section_discussion != null)
		{
			sb.append("section_discussion = ");
			sb.append(section_discussion);
			sb.append('\n');
		}
		if (section_experimental != null)
		{
			sb.append("section_experimental = ");
			sb.append(section_experimental);
			sb.append('\n');
		}
		if (section_exptl_prep != null)
		{
			sb.append("section_exptl_prep = ");
			sb.append(section_exptl_prep);
			sb.append('\n');
		}
		if (section_exptl_refinement != null)
		{
			sb.append("section_exptl_refinement = ");
			sb.append(section_exptl_refinement);
			sb.append('\n');
		}
		if (section_exptl_solution != null)
		{
			sb.append("section_exptl_solution = ");
			sb.append(section_exptl_solution);
			sb.append('\n');
		}
		if (section_figure_captions != null)
		{
			sb.append("section_figure_captions = ");
			sb.append(section_figure_captions);
			sb.append('\n');
		}
		if (section_introduction != null)
		{
			sb.append("section_introduction = ");
			sb.append(section_introduction);
			sb.append('\n');
		}
		if (section_references != null)
		{
			sb.append("section_references = ");
			sb.append(section_references);
			sb.append('\n');
		}
		if (section_synopsis != null)
		{
			sb.append("section_synopsis = ");
			sb.append(section_synopsis);
			sb.append('\n');
		}
		if (section_table_legends != null)
		{
			sb.append("section_table_legends = ");
			sb.append(section_table_legends);
			sb.append('\n');
		}
		if (section_title != null)
		{
			sb.append("section_title = ");
			sb.append(section_title);
			sb.append('\n');
		}
		if (section_title_footnote != null)
		{
			sb.append("section_title_footnote = ");
			sb.append(section_title_footnote);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		contact_author = null;
		contact_author_address = null;
		contact_author_email = null;
		contact_author_fax = null;
		contact_author_name = null;
		contact_author_phone = null;
		contact_letter = null;
		entry_id = null;
		manuscript_creation = null;
		manuscript_processed = null;
		manuscript_text = null;
		requested_category = null;
		requested_coeditor_name = null;
		requested_journal = null;
		section_abstract = null;
		section_acknowledgements = null;
		section_comment = null;
		section_discussion = null;
		section_experimental = null;
		section_exptl_prep = null;
		section_exptl_refinement = null;
		section_exptl_solution = null;
		section_figure_captions = null;
		section_introduction = null;
		section_references = null;
		section_synopsis = null;
		section_table_legends = null;
		section_title = null;
		section_title_footnote = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Publ)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:publ>\n");
			if (contact_author != null) ow.write(indent + " <PDBx:contact_author>" + contact_author + "</PDBx:contact_author>\n");
			if (contact_author_address != null) ow.write(indent + " <PDBx:contact_author_address>" + contact_author_address + "</PDBx:contact_author_address>\n");
			if (contact_author_email != null) ow.write(indent + " <PDBx:contact_author_email>" + contact_author_email + "</PDBx:contact_author_email>\n");
			if (contact_author_fax != null) ow.write(indent + " <PDBx:contact_author_fax>" + contact_author_fax + "</PDBx:contact_author_fax>\n");
			if (contact_author_name != null) ow.write(indent + " <PDBx:contact_author_name>" + contact_author_name + "</PDBx:contact_author_name>\n");
			if (contact_author_phone != null) ow.write(indent + " <PDBx:contact_author_phone>" + contact_author_phone + "</PDBx:contact_author_phone>\n");
			if (contact_letter != null) ow.write(indent + " <PDBx:contact_letter>" + contact_letter + "</PDBx:contact_letter>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (manuscript_creation != null) ow.write(indent + " <PDBx:manuscript_creation>" + manuscript_creation + "</PDBx:manuscript_creation>\n");
			if (manuscript_processed != null) ow.write(indent + " <PDBx:manuscript_processed>" + manuscript_processed + "</PDBx:manuscript_processed>\n");
			if (manuscript_text != null) ow.write(indent + " <PDBx:manuscript_text>" + manuscript_text + "</PDBx:manuscript_text>\n");
			if (requested_category != null) ow.write(indent + " <PDBx:requested_category>" + requested_category + "</PDBx:requested_category>\n");
			if (requested_coeditor_name != null) ow.write(indent + " <PDBx:requested_coeditor_name>" + requested_coeditor_name + "</PDBx:requested_coeditor_name>\n");
			if (requested_journal != null) ow.write(indent + " <PDBx:requested_journal>" + requested_journal + "</PDBx:requested_journal>\n");
			if (section_abstract != null) ow.write(indent + " <PDBx:section_abstract>" + section_abstract + "</PDBx:section_abstract>\n");
			if (section_acknowledgements != null) ow.write(indent + " <PDBx:section_acknowledgements>" + section_acknowledgements + "</PDBx:section_acknowledgements>\n");
			if (section_comment != null) ow.write(indent + " <PDBx:section_comment>" + section_comment + "</PDBx:section_comment>\n");
			if (section_discussion != null) ow.write(indent + " <PDBx:section_discussion>" + section_discussion + "</PDBx:section_discussion>\n");
			if (section_experimental != null) ow.write(indent + " <PDBx:section_experimental>" + section_experimental + "</PDBx:section_experimental>\n");
			if (section_exptl_prep != null) ow.write(indent + " <PDBx:section_exptl_prep>" + section_exptl_prep + "</PDBx:section_exptl_prep>\n");
			if (section_exptl_refinement != null) ow.write(indent + " <PDBx:section_exptl_refinement>" + section_exptl_refinement + "</PDBx:section_exptl_refinement>\n");
			if (section_exptl_solution != null) ow.write(indent + " <PDBx:section_exptl_solution>" + section_exptl_solution + "</PDBx:section_exptl_solution>\n");
			if (section_figure_captions != null) ow.write(indent + " <PDBx:section_figure_captions>" + section_figure_captions + "</PDBx:section_figure_captions>\n");
			if (section_introduction != null) ow.write(indent + " <PDBx:section_introduction>" + section_introduction + "</PDBx:section_introduction>\n");
			if (section_references != null) ow.write(indent + " <PDBx:section_references>" + section_references + "</PDBx:section_references>\n");
			if (section_synopsis != null) ow.write(indent + " <PDBx:section_synopsis>" + section_synopsis + "</PDBx:section_synopsis>\n");
			if (section_table_legends != null) ow.write(indent + " <PDBx:section_table_legends>" + section_table_legends + "</PDBx:section_table_legends>\n");
			if (section_title != null) ow.write(indent + " <PDBx:section_title>" + section_title + "</PDBx:section_title>\n");
			if (section_title_footnote != null) ow.write(indent + " <PDBx:section_title_footnote>" + section_title_footnote + "</PDBx:section_title_footnote>\n");
			ow.write(indent + "</PDBx:publ>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
