package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PUBL_AUTHOR category record details of
 *  the authors of a manuscript submitted for publication.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:publ_authorCategory>
 *  <PDBx:publ_author name="Willis, Anthony C.">
 *  <PDBx:address>     Research School of Chemistry
 *  Australian National University
 *  GPO Box 4
 *  Canberra, A.C.T.
 *  Australia    2601</PDBx:address>
 *  </PDBx:publ_author>
 *  </PDBx:publ_authorCategory>
 * </pre>
 */
public class Publ_author extends org.pdb.beans.Publ_author implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "publ_author";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Publ_author()
	{
	}

	/** Full constructor */
	public Publ_author(
		Datablock datablock,
		java.lang.String address,
		java.lang.String email,
		java.lang.String footnote,
		java.lang.String id_iucr,
		java.lang.String name)
	{
		this.datablock = datablock;
		this.address = address;
		this.email = email;
		this.footnote = footnote;
		this.id_iucr = id_iucr;
		this.name = name;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Publ_author");
		sb.append("\n");
		if (address != null)
		{
			sb.append("address = ");
			sb.append(address);
			sb.append('\n');
		}
		if (email != null)
		{
			sb.append("email = ");
			sb.append(email);
			sb.append('\n');
		}
		if (footnote != null)
		{
			sb.append("footnote = ");
			sb.append(footnote);
			sb.append('\n');
		}
		if (id_iucr != null)
		{
			sb.append("id_iucr = ");
			sb.append(id_iucr);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		address = null;
		email = null;
		footnote = null;
		id_iucr = null;
		name = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Publ_author)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:publ_author>\n");
			if (address != null) ow.write(indent + " <PDBx:address>" + address + "</PDBx:address>\n");
			if (email != null) ow.write(indent + " <PDBx:email>" + email + "</PDBx:email>\n");
			if (footnote != null) ow.write(indent + " <PDBx:footnote>" + footnote + "</PDBx:footnote>\n");
			if (id_iucr != null) ow.write(indent + " <PDBx:id_iucr>" + id_iucr + "</PDBx:id_iucr>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			ow.write(indent + "</PDBx:publ_author>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
