package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PUBL_MANUSCRIPT_INCL category allow
 *  the authors of a manuscript submitted for publication to list
 *  data names that should be added to the standard request list
 *  used by the journal printing software.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:publ_manuscript_inclCategory>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_atom_site.symmetry_multiplicity</PDBx:extra_item>
 *  <PDBx:extra_info>to emphasise special sites</PDBx:extra_info>
 *  <PDBx:extra_defn>yes</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_chemical.compound_source</PDBx:extra_item>
 *  <PDBx:extra_info>rare material, unusual source</PDBx:extra_info>
 *  <PDBx:extra_defn>yes</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_reflns.d_resolution_high</PDBx:extra_item>
 *  <PDBx:extra_info>limited data is a problem here</PDBx:extra_info>
 *  <PDBx:extra_defn>yes</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_crystal.magnetic_permeability</PDBx:extra_item>
 *  <PDBx:extra_info>unusual value for this material</PDBx:extra_info>
 *  <PDBx:extra_defn>no</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  </PDBx:publ_manuscript_inclCategory>
 * </pre>
 */
public class Publ_manuscript_incl extends org.pdb.beans.Publ_manuscript_incl implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "publ_manuscript_incl";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Publ_manuscript_incl()
	{
	}

	/** Full constructor */
	public Publ_manuscript_incl(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.String extra_defn,
		java.lang.String extra_info,
		java.lang.String extra_item)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.extra_defn = extra_defn;
		this.extra_info = extra_info;
		this.extra_item = extra_item;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Publ_manuscript_incl");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (extra_defn != null)
		{
			sb.append("extra_defn = ");
			sb.append(extra_defn);
			sb.append('\n');
		}
		if (extra_info != null)
		{
			sb.append("extra_info = ");
			sb.append(extra_info);
			sb.append('\n');
		}
		if (extra_item != null)
		{
			sb.append("extra_item = ");
			sb.append(extra_item);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		extra_defn = null;
		extra_info = null;
		extra_item = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Publ_manuscript_incl)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:publ_manuscript_incl>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (extra_defn != null) ow.write(indent + " <PDBx:extra_defn>" + extra_defn + "</PDBx:extra_defn>\n");
			if (extra_info != null) ow.write(indent + " <PDBx:extra_info>" + extra_info + "</PDBx:extra_info>\n");
			if (extra_item != null) ow.write(indent + " <PDBx:extra_item>" + extra_item + "</PDBx:extra_item>\n");
			ow.write(indent + "</PDBx:publ_manuscript_incl>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
