package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE category record details about the
 *  structure-refinement parameters.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refineCategory>
 *  <PDBx:refine entry_id="5HVP">
 *  <PDBx:ls_number_reflns_obs>12901</PDBx:ls_number_reflns_obs>
 *  <PDBx:ls_number_restraints>6609</PDBx:ls_number_restraints>
 *  <PDBx:ls_number_parameters>7032</PDBx:ls_number_parameters>
 *  <PDBx:ls_weighting_scheme>calc</PDBx:ls_weighting_scheme>
 *  <PDBx:ls_weighting_details> Sigdel model of Konnert-Hendrickson:
 *  Sigdel: Afsig +  Bfsig*(sin(theta)/lambda-1/6)
 *  Afsig = 22.0, Bfsig = -150.0 at beginning of refinement
 *  Afsig = 15.5, Bfsig =  -50.0 at end of refinement</PDBx:ls_weighting_details>
 *  </PDBx:refine>
 *  </PDBx:refineCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:refineCategory>
 *  <PDBx:refine>
 *  <PDBx:details>sfls:_F_calc_weight_full_matrix</PDBx:details>
 *  <PDBx:ls_structure_factor_coef>F</PDBx:ls_structure_factor_coef>
 *  <PDBx:ls_matrix_type>full</PDBx:ls_matrix_type>
 *  <PDBx:ls_weighting_scheme>calc</PDBx:ls_weighting_scheme>
 *  <PDBx:ls_weighting_details>w=1/(\s^2^(F)+0.0004F^2^)</PDBx:ls_weighting_details>
 *  <PDBx:ls_hydrogen_treatment>refxyz except H332B noref</PDBx:ls_hydrogen_treatment>
 *  <PDBx:ls_extinction_method>Zachariasen</PDBx:ls_extinction_method>
 *  <PDBx:ls_extinction_coef>3514.</PDBx:ls_extinction_coef>
 *  <PDBx:ls_extinction_expression> Larson, A. C. (1970). &quot;Crystallographic Computing&quot;, edited
 *  by F. R. Ahmed. Eq. (22) p. 292. Copenhagen: Munksgaard.</PDBx:ls_extinction_expression>
 *  <PDBx:ls_abs_structure_details> The absolute configuration was assigned to agree with the
 *  known chirality at C3 arising from its precursor l-leucine.</PDBx:ls_abs_structure_details>
 *  <PDBx:ls_abs_structure_Flack>0.</PDBx:ls_abs_structure_Flack>
 *  <PDBx:ls_number_reflns_obs>1408</PDBx:ls_number_reflns_obs>
 *  <PDBx:ls_number_parameters>272</PDBx:ls_number_parameters>
 *  <PDBx:ls_number_restraints>0</PDBx:ls_number_restraints>
 *  <PDBx:ls_number_constraints>0</PDBx:ls_number_constraints>
 *  <PDBx:ls_R_factor_all>.038</PDBx:ls_R_factor_all>
 *  <PDBx:ls_R_factor_obs>.034</PDBx:ls_R_factor_obs>
 *  <PDBx:ls_wR_factor_all>.044</PDBx:ls_wR_factor_all>
 *  <PDBx:ls_wR_factor_obs>.042</PDBx:ls_wR_factor_obs>
 *  <PDBx:ls_goodness_of_fit_all>1.462</PDBx:ls_goodness_of_fit_all>
 *  <PDBx:ls_goodness_of_fit_obs>1.515</PDBx:ls_goodness_of_fit_obs>
 *  <PDBx:ls_shift_over_esd_max>.535</PDBx:ls_shift_over_esd_max>
 *  <PDBx:ls_shift_over_esd_mean>.044</PDBx:ls_shift_over_esd_mean>
 *  <PDBx:diff_density_min>-.108</PDBx:diff_density_min>
 *  <PDBx:diff_density_max>.131</PDBx:diff_density_max>
 *  </PDBx:refine>
 *  </PDBx:refineCategory>
 * </pre>
 */
public class Refine extends org.pdb.beans.Refine implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine()
	{
	}

	/** Full constructor */
	public Refine(
		Datablock datablock,
		java.lang.Float B_iso_max,
		java.lang.Float B_iso_mean,
		java.lang.Float B_iso_min,
		java.lang.Float aniso_B11,
		java.lang.Float aniso_B12,
		java.lang.Float aniso_B13,
		java.lang.Float aniso_B22,
		java.lang.Float aniso_B23,
		java.lang.Float aniso_B33,
		java.lang.Float correlation_coeff_Fo_to_Fc,
		java.lang.Float correlation_coeff_Fo_to_Fc_free,
		java.lang.String details,
		java.lang.Float diff_density_max,
		java.lang.Float diff_density_max_esd,
		java.lang.Float diff_density_min,
		java.lang.Float diff_density_min_esd,
		java.lang.Float diff_density_rms,
		java.lang.Float diff_density_rms_esd,
		java.lang.String entry_id,
		java.lang.Float ls_R_Fsqd_factor_obs,
		java.lang.Float ls_R_I_factor_obs,
		java.lang.Float ls_R_factor_R_free,
		java.lang.Float ls_R_factor_R_free_error,
		java.lang.String ls_R_factor_R_free_error_details,
		java.lang.Float ls_R_factor_R_work,
		java.lang.Float ls_R_factor_all,
		java.lang.Float ls_R_factor_gt,
		java.lang.Float ls_R_factor_obs,
		java.lang.Float ls_abs_structure_Flack,
		java.lang.Float ls_abs_structure_Flack_esd,
		java.lang.Float ls_abs_structure_Rogers,
		java.lang.Float ls_abs_structure_Rogers_esd,
		java.lang.String ls_abs_structure_details,
		java.lang.Float ls_d_res_high,
		java.lang.Float ls_d_res_low,
		java.lang.Float ls_extinction_coef,
		java.lang.Float ls_extinction_coef_esd,
		java.lang.String ls_extinction_expression,
		java.lang.String ls_extinction_method,
		java.lang.Float ls_goodness_of_fit_all,
		java.lang.Float ls_goodness_of_fit_all_esd,
		java.lang.Float ls_goodness_of_fit_gt,
		java.lang.Float ls_goodness_of_fit_obs,
		java.lang.Float ls_goodness_of_fit_obs_esd,
		java.lang.Float ls_goodness_of_fit_ref,
		java.lang.String ls_hydrogen_treatment,
		java.lang.String ls_matrix_type,
		java.lang.Integer ls_number_constraints,
		java.lang.Integer ls_number_parameters,
		java.lang.Integer ls_number_reflns_R_free,
		java.lang.Integer ls_number_reflns_R_work,
		java.lang.Integer ls_number_reflns_all,
		java.lang.Integer ls_number_reflns_obs,
		java.lang.Integer ls_number_restraints,
		java.lang.Float ls_percent_reflns_R_free,
		java.lang.Float ls_percent_reflns_obs,
		java.lang.Float ls_redundancy_reflns_all,
		java.lang.Float ls_redundancy_reflns_obs,
		java.lang.Float ls_restrained_S_all,
		java.lang.Float ls_restrained_S_obs,
		java.lang.Float ls_shift_over_esd_max,
		java.lang.Float ls_shift_over_esd_mean,
		java.lang.Float ls_shift_over_su_max,
		java.lang.Float ls_shift_over_su_max_lt,
		java.lang.Float ls_shift_over_su_mean,
		java.lang.Float ls_shift_over_su_mean_lt,
		java.lang.String ls_structure_factor_coef,
		java.lang.Float ls_wR_factor_R_free,
		java.lang.Float ls_wR_factor_R_work,
		java.lang.Float ls_wR_factor_all,
		java.lang.Float ls_wR_factor_obs,
		java.lang.String ls_weighting_details,
		java.lang.String ls_weighting_scheme,
		java.lang.Float occupancy_max,
		java.lang.Float occupancy_min,
		java.lang.Float overall_FOM_free_R_set,
		java.lang.Float overall_FOM_work_R_set,
		java.lang.Float overall_SU_B,
		java.lang.Float overall_SU_ML,
		java.lang.Float overall_SU_R_Cruickshank_DPI,
		java.lang.Float overall_SU_R_free,
		java.lang.String pdbx_R_Free_selection_details,
		java.lang.Float pdbx_data_cutoff_high_absF,
		java.lang.Float pdbx_data_cutoff_high_rms_absF,
		java.lang.Float pdbx_data_cutoff_low_absF,
		java.lang.Float pdbx_density_correlation,
		java.lang.String pdbx_isotropic_thermal_model,
		java.lang.String pdbx_ls_cross_valid_method,
		java.lang.Float pdbx_ls_sigma_F,
		java.lang.Float pdbx_ls_sigma_Fsqd,
		java.lang.Float pdbx_ls_sigma_I,
		java.lang.String pdbx_method_to_determine_struct,
		java.lang.Float pdbx_overall_ESU_R,
		java.lang.Float pdbx_overall_ESU_R_Free,
		java.lang.Float pdbx_pd_Fsqrd_R_factor,
		java.lang.Float pdbx_pd_Marquardt_correlation_coeff,
		java.lang.Integer pdbx_pd_ls_matrix_band_width,
		java.lang.Integer pdbx_pd_meas_number_of_points,
		java.lang.Integer pdbx_pd_number_of_points,
		java.lang.Integer pdbx_pd_number_of_powder_patterns,
		java.lang.Float pdbx_pd_proc_ls_prof_R_factor,
		java.lang.Float pdbx_pd_proc_ls_prof_wR_factor,
		java.lang.Float pdbx_real_space_R,
		java.lang.Float pdbx_solvent_ion_probe_radii,
		java.lang.Float pdbx_solvent_shrinkage_radii,
		java.lang.Float pdbx_solvent_vdw_probe_radii,
		java.lang.String pdbx_starting_model,
		java.lang.String pdbx_stereochem_target_val_spec_case,
		java.lang.String pdbx_stereochemistry_target_values,
		java.lang.String solvent_model_details,
		java.lang.Float solvent_model_param_bsol,
		java.lang.Float solvent_model_param_ksol)
	{
		this.datablock = datablock;
		this.B_iso_max = B_iso_max;
		this.B_iso_mean = B_iso_mean;
		this.B_iso_min = B_iso_min;
		this.aniso_B11 = aniso_B11;
		this.aniso_B12 = aniso_B12;
		this.aniso_B13 = aniso_B13;
		this.aniso_B22 = aniso_B22;
		this.aniso_B23 = aniso_B23;
		this.aniso_B33 = aniso_B33;
		this.correlation_coeff_Fo_to_Fc = correlation_coeff_Fo_to_Fc;
		this.correlation_coeff_Fo_to_Fc_free = correlation_coeff_Fo_to_Fc_free;
		this.details = details;
		this.diff_density_max = diff_density_max;
		this.diff_density_max_esd = diff_density_max_esd;
		this.diff_density_min = diff_density_min;
		this.diff_density_min_esd = diff_density_min_esd;
		this.diff_density_rms = diff_density_rms;
		this.diff_density_rms_esd = diff_density_rms_esd;
		this.entry_id = entry_id;
		this.ls_R_Fsqd_factor_obs = ls_R_Fsqd_factor_obs;
		this.ls_R_I_factor_obs = ls_R_I_factor_obs;
		this.ls_R_factor_R_free = ls_R_factor_R_free;
		this.ls_R_factor_R_free_error = ls_R_factor_R_free_error;
		this.ls_R_factor_R_free_error_details = ls_R_factor_R_free_error_details;
		this.ls_R_factor_R_work = ls_R_factor_R_work;
		this.ls_R_factor_all = ls_R_factor_all;
		this.ls_R_factor_gt = ls_R_factor_gt;
		this.ls_R_factor_obs = ls_R_factor_obs;
		this.ls_abs_structure_Flack = ls_abs_structure_Flack;
		this.ls_abs_structure_Flack_esd = ls_abs_structure_Flack_esd;
		this.ls_abs_structure_Rogers = ls_abs_structure_Rogers;
		this.ls_abs_structure_Rogers_esd = ls_abs_structure_Rogers_esd;
		this.ls_abs_structure_details = ls_abs_structure_details;
		this.ls_d_res_high = ls_d_res_high;
		this.ls_d_res_low = ls_d_res_low;
		this.ls_extinction_coef = ls_extinction_coef;
		this.ls_extinction_coef_esd = ls_extinction_coef_esd;
		this.ls_extinction_expression = ls_extinction_expression;
		this.ls_extinction_method = ls_extinction_method;
		this.ls_goodness_of_fit_all = ls_goodness_of_fit_all;
		this.ls_goodness_of_fit_all_esd = ls_goodness_of_fit_all_esd;
		this.ls_goodness_of_fit_gt = ls_goodness_of_fit_gt;
		this.ls_goodness_of_fit_obs = ls_goodness_of_fit_obs;
		this.ls_goodness_of_fit_obs_esd = ls_goodness_of_fit_obs_esd;
		this.ls_goodness_of_fit_ref = ls_goodness_of_fit_ref;
		this.ls_hydrogen_treatment = ls_hydrogen_treatment;
		this.ls_matrix_type = ls_matrix_type;
		this.ls_number_constraints = ls_number_constraints;
		this.ls_number_parameters = ls_number_parameters;
		this.ls_number_reflns_R_free = ls_number_reflns_R_free;
		this.ls_number_reflns_R_work = ls_number_reflns_R_work;
		this.ls_number_reflns_all = ls_number_reflns_all;
		this.ls_number_reflns_obs = ls_number_reflns_obs;
		this.ls_number_restraints = ls_number_restraints;
		this.ls_percent_reflns_R_free = ls_percent_reflns_R_free;
		this.ls_percent_reflns_obs = ls_percent_reflns_obs;
		this.ls_redundancy_reflns_all = ls_redundancy_reflns_all;
		this.ls_redundancy_reflns_obs = ls_redundancy_reflns_obs;
		this.ls_restrained_S_all = ls_restrained_S_all;
		this.ls_restrained_S_obs = ls_restrained_S_obs;
		this.ls_shift_over_esd_max = ls_shift_over_esd_max;
		this.ls_shift_over_esd_mean = ls_shift_over_esd_mean;
		this.ls_shift_over_su_max = ls_shift_over_su_max;
		this.ls_shift_over_su_max_lt = ls_shift_over_su_max_lt;
		this.ls_shift_over_su_mean = ls_shift_over_su_mean;
		this.ls_shift_over_su_mean_lt = ls_shift_over_su_mean_lt;
		this.ls_structure_factor_coef = ls_structure_factor_coef;
		this.ls_wR_factor_R_free = ls_wR_factor_R_free;
		this.ls_wR_factor_R_work = ls_wR_factor_R_work;
		this.ls_wR_factor_all = ls_wR_factor_all;
		this.ls_wR_factor_obs = ls_wR_factor_obs;
		this.ls_weighting_details = ls_weighting_details;
		this.ls_weighting_scheme = ls_weighting_scheme;
		this.occupancy_max = occupancy_max;
		this.occupancy_min = occupancy_min;
		this.overall_FOM_free_R_set = overall_FOM_free_R_set;
		this.overall_FOM_work_R_set = overall_FOM_work_R_set;
		this.overall_SU_B = overall_SU_B;
		this.overall_SU_ML = overall_SU_ML;
		this.overall_SU_R_Cruickshank_DPI = overall_SU_R_Cruickshank_DPI;
		this.overall_SU_R_free = overall_SU_R_free;
		this.pdbx_R_Free_selection_details = pdbx_R_Free_selection_details;
		this.pdbx_data_cutoff_high_absF = pdbx_data_cutoff_high_absF;
		this.pdbx_data_cutoff_high_rms_absF = pdbx_data_cutoff_high_rms_absF;
		this.pdbx_data_cutoff_low_absF = pdbx_data_cutoff_low_absF;
		this.pdbx_density_correlation = pdbx_density_correlation;
		this.pdbx_isotropic_thermal_model = pdbx_isotropic_thermal_model;
		this.pdbx_ls_cross_valid_method = pdbx_ls_cross_valid_method;
		this.pdbx_ls_sigma_F = pdbx_ls_sigma_F;
		this.pdbx_ls_sigma_Fsqd = pdbx_ls_sigma_Fsqd;
		this.pdbx_ls_sigma_I = pdbx_ls_sigma_I;
		this.pdbx_method_to_determine_struct = pdbx_method_to_determine_struct;
		this.pdbx_overall_ESU_R = pdbx_overall_ESU_R;
		this.pdbx_overall_ESU_R_Free = pdbx_overall_ESU_R_Free;
		this.pdbx_pd_Fsqrd_R_factor = pdbx_pd_Fsqrd_R_factor;
		this.pdbx_pd_Marquardt_correlation_coeff = pdbx_pd_Marquardt_correlation_coeff;
		this.pdbx_pd_ls_matrix_band_width = pdbx_pd_ls_matrix_band_width;
		this.pdbx_pd_meas_number_of_points = pdbx_pd_meas_number_of_points;
		this.pdbx_pd_number_of_points = pdbx_pd_number_of_points;
		this.pdbx_pd_number_of_powder_patterns = pdbx_pd_number_of_powder_patterns;
		this.pdbx_pd_proc_ls_prof_R_factor = pdbx_pd_proc_ls_prof_R_factor;
		this.pdbx_pd_proc_ls_prof_wR_factor = pdbx_pd_proc_ls_prof_wR_factor;
		this.pdbx_real_space_R = pdbx_real_space_R;
		this.pdbx_solvent_ion_probe_radii = pdbx_solvent_ion_probe_radii;
		this.pdbx_solvent_shrinkage_radii = pdbx_solvent_shrinkage_radii;
		this.pdbx_solvent_vdw_probe_radii = pdbx_solvent_vdw_probe_radii;
		this.pdbx_starting_model = pdbx_starting_model;
		this.pdbx_stereochem_target_val_spec_case = pdbx_stereochem_target_val_spec_case;
		this.pdbx_stereochemistry_target_values = pdbx_stereochemistry_target_values;
		this.solvent_model_details = solvent_model_details;
		this.solvent_model_param_bsol = solvent_model_param_bsol;
		this.solvent_model_param_ksol = solvent_model_param_ksol;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine");
		sb.append("\n");
		if (B_iso_max != null)
		{
			sb.append("B_iso_max = ");
			sb.append(B_iso_max);
			sb.append('\n');
		}
		if (B_iso_mean != null)
		{
			sb.append("B_iso_mean = ");
			sb.append(B_iso_mean);
			sb.append('\n');
		}
		if (B_iso_min != null)
		{
			sb.append("B_iso_min = ");
			sb.append(B_iso_min);
			sb.append('\n');
		}
		if (aniso_B11 != null)
		{
			sb.append("aniso_B11 = ");
			sb.append(aniso_B11);
			sb.append('\n');
		}
		if (aniso_B12 != null)
		{
			sb.append("aniso_B12 = ");
			sb.append(aniso_B12);
			sb.append('\n');
		}
		if (aniso_B13 != null)
		{
			sb.append("aniso_B13 = ");
			sb.append(aniso_B13);
			sb.append('\n');
		}
		if (aniso_B22 != null)
		{
			sb.append("aniso_B22 = ");
			sb.append(aniso_B22);
			sb.append('\n');
		}
		if (aniso_B23 != null)
		{
			sb.append("aniso_B23 = ");
			sb.append(aniso_B23);
			sb.append('\n');
		}
		if (aniso_B33 != null)
		{
			sb.append("aniso_B33 = ");
			sb.append(aniso_B33);
			sb.append('\n');
		}
		if (correlation_coeff_Fo_to_Fc != null)
		{
			sb.append("correlation_coeff_Fo_to_Fc = ");
			sb.append(correlation_coeff_Fo_to_Fc);
			sb.append('\n');
		}
		if (correlation_coeff_Fo_to_Fc_free != null)
		{
			sb.append("correlation_coeff_Fo_to_Fc_free = ");
			sb.append(correlation_coeff_Fo_to_Fc_free);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (diff_density_max != null)
		{
			sb.append("diff_density_max = ");
			sb.append(diff_density_max);
			sb.append('\n');
		}
		if (diff_density_max_esd != null)
		{
			sb.append("diff_density_max_esd = ");
			sb.append(diff_density_max_esd);
			sb.append('\n');
		}
		if (diff_density_min != null)
		{
			sb.append("diff_density_min = ");
			sb.append(diff_density_min);
			sb.append('\n');
		}
		if (diff_density_min_esd != null)
		{
			sb.append("diff_density_min_esd = ");
			sb.append(diff_density_min_esd);
			sb.append('\n');
		}
		if (diff_density_rms != null)
		{
			sb.append("diff_density_rms = ");
			sb.append(diff_density_rms);
			sb.append('\n');
		}
		if (diff_density_rms_esd != null)
		{
			sb.append("diff_density_rms_esd = ");
			sb.append(diff_density_rms_esd);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (ls_R_Fsqd_factor_obs != null)
		{
			sb.append("ls_R_Fsqd_factor_obs = ");
			sb.append(ls_R_Fsqd_factor_obs);
			sb.append('\n');
		}
		if (ls_R_I_factor_obs != null)
		{
			sb.append("ls_R_I_factor_obs = ");
			sb.append(ls_R_I_factor_obs);
			sb.append('\n');
		}
		if (ls_R_factor_R_free != null)
		{
			sb.append("ls_R_factor_R_free = ");
			sb.append(ls_R_factor_R_free);
			sb.append('\n');
		}
		if (ls_R_factor_R_free_error != null)
		{
			sb.append("ls_R_factor_R_free_error = ");
			sb.append(ls_R_factor_R_free_error);
			sb.append('\n');
		}
		if (ls_R_factor_R_free_error_details != null)
		{
			sb.append("ls_R_factor_R_free_error_details = ");
			sb.append(ls_R_factor_R_free_error_details);
			sb.append('\n');
		}
		if (ls_R_factor_R_work != null)
		{
			sb.append("ls_R_factor_R_work = ");
			sb.append(ls_R_factor_R_work);
			sb.append('\n');
		}
		if (ls_R_factor_all != null)
		{
			sb.append("ls_R_factor_all = ");
			sb.append(ls_R_factor_all);
			sb.append('\n');
		}
		if (ls_R_factor_gt != null)
		{
			sb.append("ls_R_factor_gt = ");
			sb.append(ls_R_factor_gt);
			sb.append('\n');
		}
		if (ls_R_factor_obs != null)
		{
			sb.append("ls_R_factor_obs = ");
			sb.append(ls_R_factor_obs);
			sb.append('\n');
		}
		if (ls_abs_structure_Flack != null)
		{
			sb.append("ls_abs_structure_Flack = ");
			sb.append(ls_abs_structure_Flack);
			sb.append('\n');
		}
		if (ls_abs_structure_Flack_esd != null)
		{
			sb.append("ls_abs_structure_Flack_esd = ");
			sb.append(ls_abs_structure_Flack_esd);
			sb.append('\n');
		}
		if (ls_abs_structure_Rogers != null)
		{
			sb.append("ls_abs_structure_Rogers = ");
			sb.append(ls_abs_structure_Rogers);
			sb.append('\n');
		}
		if (ls_abs_structure_Rogers_esd != null)
		{
			sb.append("ls_abs_structure_Rogers_esd = ");
			sb.append(ls_abs_structure_Rogers_esd);
			sb.append('\n');
		}
		if (ls_abs_structure_details != null)
		{
			sb.append("ls_abs_structure_details = ");
			sb.append(ls_abs_structure_details);
			sb.append('\n');
		}
		if (ls_d_res_high != null)
		{
			sb.append("ls_d_res_high = ");
			sb.append(ls_d_res_high);
			sb.append('\n');
		}
		if (ls_d_res_low != null)
		{
			sb.append("ls_d_res_low = ");
			sb.append(ls_d_res_low);
			sb.append('\n');
		}
		if (ls_extinction_coef != null)
		{
			sb.append("ls_extinction_coef = ");
			sb.append(ls_extinction_coef);
			sb.append('\n');
		}
		if (ls_extinction_coef_esd != null)
		{
			sb.append("ls_extinction_coef_esd = ");
			sb.append(ls_extinction_coef_esd);
			sb.append('\n');
		}
		if (ls_extinction_expression != null)
		{
			sb.append("ls_extinction_expression = ");
			sb.append(ls_extinction_expression);
			sb.append('\n');
		}
		if (ls_extinction_method != null)
		{
			sb.append("ls_extinction_method = ");
			sb.append(ls_extinction_method);
			sb.append('\n');
		}
		if (ls_goodness_of_fit_all != null)
		{
			sb.append("ls_goodness_of_fit_all = ");
			sb.append(ls_goodness_of_fit_all);
			sb.append('\n');
		}
		if (ls_goodness_of_fit_all_esd != null)
		{
			sb.append("ls_goodness_of_fit_all_esd = ");
			sb.append(ls_goodness_of_fit_all_esd);
			sb.append('\n');
		}
		if (ls_goodness_of_fit_gt != null)
		{
			sb.append("ls_goodness_of_fit_gt = ");
			sb.append(ls_goodness_of_fit_gt);
			sb.append('\n');
		}
		if (ls_goodness_of_fit_obs != null)
		{
			sb.append("ls_goodness_of_fit_obs = ");
			sb.append(ls_goodness_of_fit_obs);
			sb.append('\n');
		}
		if (ls_goodness_of_fit_obs_esd != null)
		{
			sb.append("ls_goodness_of_fit_obs_esd = ");
			sb.append(ls_goodness_of_fit_obs_esd);
			sb.append('\n');
		}
		if (ls_goodness_of_fit_ref != null)
		{
			sb.append("ls_goodness_of_fit_ref = ");
			sb.append(ls_goodness_of_fit_ref);
			sb.append('\n');
		}
		if (ls_hydrogen_treatment != null)
		{
			sb.append("ls_hydrogen_treatment = ");
			sb.append(ls_hydrogen_treatment);
			sb.append('\n');
		}
		if (ls_matrix_type != null)
		{
			sb.append("ls_matrix_type = ");
			sb.append(ls_matrix_type);
			sb.append('\n');
		}
		if (ls_number_constraints != null)
		{
			sb.append("ls_number_constraints = ");
			sb.append(ls_number_constraints);
			sb.append('\n');
		}
		if (ls_number_parameters != null)
		{
			sb.append("ls_number_parameters = ");
			sb.append(ls_number_parameters);
			sb.append('\n');
		}
		if (ls_number_reflns_R_free != null)
		{
			sb.append("ls_number_reflns_R_free = ");
			sb.append(ls_number_reflns_R_free);
			sb.append('\n');
		}
		if (ls_number_reflns_R_work != null)
		{
			sb.append("ls_number_reflns_R_work = ");
			sb.append(ls_number_reflns_R_work);
			sb.append('\n');
		}
		if (ls_number_reflns_all != null)
		{
			sb.append("ls_number_reflns_all = ");
			sb.append(ls_number_reflns_all);
			sb.append('\n');
		}
		if (ls_number_reflns_obs != null)
		{
			sb.append("ls_number_reflns_obs = ");
			sb.append(ls_number_reflns_obs);
			sb.append('\n');
		}
		if (ls_number_restraints != null)
		{
			sb.append("ls_number_restraints = ");
			sb.append(ls_number_restraints);
			sb.append('\n');
		}
		if (ls_percent_reflns_R_free != null)
		{
			sb.append("ls_percent_reflns_R_free = ");
			sb.append(ls_percent_reflns_R_free);
			sb.append('\n');
		}
		if (ls_percent_reflns_obs != null)
		{
			sb.append("ls_percent_reflns_obs = ");
			sb.append(ls_percent_reflns_obs);
			sb.append('\n');
		}
		if (ls_redundancy_reflns_all != null)
		{
			sb.append("ls_redundancy_reflns_all = ");
			sb.append(ls_redundancy_reflns_all);
			sb.append('\n');
		}
		if (ls_redundancy_reflns_obs != null)
		{
			sb.append("ls_redundancy_reflns_obs = ");
			sb.append(ls_redundancy_reflns_obs);
			sb.append('\n');
		}
		if (ls_restrained_S_all != null)
		{
			sb.append("ls_restrained_S_all = ");
			sb.append(ls_restrained_S_all);
			sb.append('\n');
		}
		if (ls_restrained_S_obs != null)
		{
			sb.append("ls_restrained_S_obs = ");
			sb.append(ls_restrained_S_obs);
			sb.append('\n');
		}
		if (ls_shift_over_esd_max != null)
		{
			sb.append("ls_shift_over_esd_max = ");
			sb.append(ls_shift_over_esd_max);
			sb.append('\n');
		}
		if (ls_shift_over_esd_mean != null)
		{
			sb.append("ls_shift_over_esd_mean = ");
			sb.append(ls_shift_over_esd_mean);
			sb.append('\n');
		}
		if (ls_shift_over_su_max != null)
		{
			sb.append("ls_shift_over_su_max = ");
			sb.append(ls_shift_over_su_max);
			sb.append('\n');
		}
		if (ls_shift_over_su_max_lt != null)
		{
			sb.append("ls_shift_over_su_max_lt = ");
			sb.append(ls_shift_over_su_max_lt);
			sb.append('\n');
		}
		if (ls_shift_over_su_mean != null)
		{
			sb.append("ls_shift_over_su_mean = ");
			sb.append(ls_shift_over_su_mean);
			sb.append('\n');
		}
		if (ls_shift_over_su_mean_lt != null)
		{
			sb.append("ls_shift_over_su_mean_lt = ");
			sb.append(ls_shift_over_su_mean_lt);
			sb.append('\n');
		}
		if (ls_structure_factor_coef != null)
		{
			sb.append("ls_structure_factor_coef = ");
			sb.append(ls_structure_factor_coef);
			sb.append('\n');
		}
		if (ls_wR_factor_R_free != null)
		{
			sb.append("ls_wR_factor_R_free = ");
			sb.append(ls_wR_factor_R_free);
			sb.append('\n');
		}
		if (ls_wR_factor_R_work != null)
		{
			sb.append("ls_wR_factor_R_work = ");
			sb.append(ls_wR_factor_R_work);
			sb.append('\n');
		}
		if (ls_wR_factor_all != null)
		{
			sb.append("ls_wR_factor_all = ");
			sb.append(ls_wR_factor_all);
			sb.append('\n');
		}
		if (ls_wR_factor_obs != null)
		{
			sb.append("ls_wR_factor_obs = ");
			sb.append(ls_wR_factor_obs);
			sb.append('\n');
		}
		if (ls_weighting_details != null)
		{
			sb.append("ls_weighting_details = ");
			sb.append(ls_weighting_details);
			sb.append('\n');
		}
		if (ls_weighting_scheme != null)
		{
			sb.append("ls_weighting_scheme = ");
			sb.append(ls_weighting_scheme);
			sb.append('\n');
		}
		if (occupancy_max != null)
		{
			sb.append("occupancy_max = ");
			sb.append(occupancy_max);
			sb.append('\n');
		}
		if (occupancy_min != null)
		{
			sb.append("occupancy_min = ");
			sb.append(occupancy_min);
			sb.append('\n');
		}
		if (overall_FOM_free_R_set != null)
		{
			sb.append("overall_FOM_free_R_set = ");
			sb.append(overall_FOM_free_R_set);
			sb.append('\n');
		}
		if (overall_FOM_work_R_set != null)
		{
			sb.append("overall_FOM_work_R_set = ");
			sb.append(overall_FOM_work_R_set);
			sb.append('\n');
		}
		if (overall_SU_B != null)
		{
			sb.append("overall_SU_B = ");
			sb.append(overall_SU_B);
			sb.append('\n');
		}
		if (overall_SU_ML != null)
		{
			sb.append("overall_SU_ML = ");
			sb.append(overall_SU_ML);
			sb.append('\n');
		}
		if (overall_SU_R_Cruickshank_DPI != null)
		{
			sb.append("overall_SU_R_Cruickshank_DPI = ");
			sb.append(overall_SU_R_Cruickshank_DPI);
			sb.append('\n');
		}
		if (overall_SU_R_free != null)
		{
			sb.append("overall_SU_R_free = ");
			sb.append(overall_SU_R_free);
			sb.append('\n');
		}
		if (pdbx_R_Free_selection_details != null)
		{
			sb.append("pdbx_R_Free_selection_details = ");
			sb.append(pdbx_R_Free_selection_details);
			sb.append('\n');
		}
		if (pdbx_data_cutoff_high_absF != null)
		{
			sb.append("pdbx_data_cutoff_high_absF = ");
			sb.append(pdbx_data_cutoff_high_absF);
			sb.append('\n');
		}
		if (pdbx_data_cutoff_high_rms_absF != null)
		{
			sb.append("pdbx_data_cutoff_high_rms_absF = ");
			sb.append(pdbx_data_cutoff_high_rms_absF);
			sb.append('\n');
		}
		if (pdbx_data_cutoff_low_absF != null)
		{
			sb.append("pdbx_data_cutoff_low_absF = ");
			sb.append(pdbx_data_cutoff_low_absF);
			sb.append('\n');
		}
		if (pdbx_density_correlation != null)
		{
			sb.append("pdbx_density_correlation = ");
			sb.append(pdbx_density_correlation);
			sb.append('\n');
		}
		if (pdbx_isotropic_thermal_model != null)
		{
			sb.append("pdbx_isotropic_thermal_model = ");
			sb.append(pdbx_isotropic_thermal_model);
			sb.append('\n');
		}
		if (pdbx_ls_cross_valid_method != null)
		{
			sb.append("pdbx_ls_cross_valid_method = ");
			sb.append(pdbx_ls_cross_valid_method);
			sb.append('\n');
		}
		if (pdbx_ls_sigma_F != null)
		{
			sb.append("pdbx_ls_sigma_F = ");
			sb.append(pdbx_ls_sigma_F);
			sb.append('\n');
		}
		if (pdbx_ls_sigma_Fsqd != null)
		{
			sb.append("pdbx_ls_sigma_Fsqd = ");
			sb.append(pdbx_ls_sigma_Fsqd);
			sb.append('\n');
		}
		if (pdbx_ls_sigma_I != null)
		{
			sb.append("pdbx_ls_sigma_I = ");
			sb.append(pdbx_ls_sigma_I);
			sb.append('\n');
		}
		if (pdbx_method_to_determine_struct != null)
		{
			sb.append("pdbx_method_to_determine_struct = ");
			sb.append(pdbx_method_to_determine_struct);
			sb.append('\n');
		}
		if (pdbx_overall_ESU_R != null)
		{
			sb.append("pdbx_overall_ESU_R = ");
			sb.append(pdbx_overall_ESU_R);
			sb.append('\n');
		}
		if (pdbx_overall_ESU_R_Free != null)
		{
			sb.append("pdbx_overall_ESU_R_Free = ");
			sb.append(pdbx_overall_ESU_R_Free);
			sb.append('\n');
		}
		if (pdbx_pd_Fsqrd_R_factor != null)
		{
			sb.append("pdbx_pd_Fsqrd_R_factor = ");
			sb.append(pdbx_pd_Fsqrd_R_factor);
			sb.append('\n');
		}
		if (pdbx_pd_Marquardt_correlation_coeff != null)
		{
			sb.append("pdbx_pd_Marquardt_correlation_coeff = ");
			sb.append(pdbx_pd_Marquardt_correlation_coeff);
			sb.append('\n');
		}
		if (pdbx_pd_ls_matrix_band_width != null)
		{
			sb.append("pdbx_pd_ls_matrix_band_width = ");
			sb.append(pdbx_pd_ls_matrix_band_width);
			sb.append('\n');
		}
		if (pdbx_pd_meas_number_of_points != null)
		{
			sb.append("pdbx_pd_meas_number_of_points = ");
			sb.append(pdbx_pd_meas_number_of_points);
			sb.append('\n');
		}
		if (pdbx_pd_number_of_points != null)
		{
			sb.append("pdbx_pd_number_of_points = ");
			sb.append(pdbx_pd_number_of_points);
			sb.append('\n');
		}
		if (pdbx_pd_number_of_powder_patterns != null)
		{
			sb.append("pdbx_pd_number_of_powder_patterns = ");
			sb.append(pdbx_pd_number_of_powder_patterns);
			sb.append('\n');
		}
		if (pdbx_pd_proc_ls_prof_R_factor != null)
		{
			sb.append("pdbx_pd_proc_ls_prof_R_factor = ");
			sb.append(pdbx_pd_proc_ls_prof_R_factor);
			sb.append('\n');
		}
		if (pdbx_pd_proc_ls_prof_wR_factor != null)
		{
			sb.append("pdbx_pd_proc_ls_prof_wR_factor = ");
			sb.append(pdbx_pd_proc_ls_prof_wR_factor);
			sb.append('\n');
		}
		if (pdbx_real_space_R != null)
		{
			sb.append("pdbx_real_space_R = ");
			sb.append(pdbx_real_space_R);
			sb.append('\n');
		}
		if (pdbx_solvent_ion_probe_radii != null)
		{
			sb.append("pdbx_solvent_ion_probe_radii = ");
			sb.append(pdbx_solvent_ion_probe_radii);
			sb.append('\n');
		}
		if (pdbx_solvent_shrinkage_radii != null)
		{
			sb.append("pdbx_solvent_shrinkage_radii = ");
			sb.append(pdbx_solvent_shrinkage_radii);
			sb.append('\n');
		}
		if (pdbx_solvent_vdw_probe_radii != null)
		{
			sb.append("pdbx_solvent_vdw_probe_radii = ");
			sb.append(pdbx_solvent_vdw_probe_radii);
			sb.append('\n');
		}
		if (pdbx_starting_model != null)
		{
			sb.append("pdbx_starting_model = ");
			sb.append(pdbx_starting_model);
			sb.append('\n');
		}
		if (pdbx_stereochem_target_val_spec_case != null)
		{
			sb.append("pdbx_stereochem_target_val_spec_case = ");
			sb.append(pdbx_stereochem_target_val_spec_case);
			sb.append('\n');
		}
		if (pdbx_stereochemistry_target_values != null)
		{
			sb.append("pdbx_stereochemistry_target_values = ");
			sb.append(pdbx_stereochemistry_target_values);
			sb.append('\n');
		}
		if (solvent_model_details != null)
		{
			sb.append("solvent_model_details = ");
			sb.append(solvent_model_details);
			sb.append('\n');
		}
		if (solvent_model_param_bsol != null)
		{
			sb.append("solvent_model_param_bsol = ");
			sb.append(solvent_model_param_bsol);
			sb.append('\n');
		}
		if (solvent_model_param_ksol != null)
		{
			sb.append("solvent_model_param_ksol = ");
			sb.append(solvent_model_param_ksol);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		B_iso_max = null;
		B_iso_mean = null;
		B_iso_min = null;
		aniso_B11 = null;
		aniso_B12 = null;
		aniso_B13 = null;
		aniso_B22 = null;
		aniso_B23 = null;
		aniso_B33 = null;
		correlation_coeff_Fo_to_Fc = null;
		correlation_coeff_Fo_to_Fc_free = null;
		details = null;
		diff_density_max = null;
		diff_density_max_esd = null;
		diff_density_min = null;
		diff_density_min_esd = null;
		diff_density_rms = null;
		diff_density_rms_esd = null;
		entry_id = null;
		ls_R_Fsqd_factor_obs = null;
		ls_R_I_factor_obs = null;
		ls_R_factor_R_free = null;
		ls_R_factor_R_free_error = null;
		ls_R_factor_R_free_error_details = null;
		ls_R_factor_R_work = null;
		ls_R_factor_all = null;
		ls_R_factor_gt = null;
		ls_R_factor_obs = null;
		ls_abs_structure_Flack = null;
		ls_abs_structure_Flack_esd = null;
		ls_abs_structure_Rogers = null;
		ls_abs_structure_Rogers_esd = null;
		ls_abs_structure_details = null;
		ls_d_res_high = null;
		ls_d_res_low = null;
		ls_extinction_coef = null;
		ls_extinction_coef_esd = null;
		ls_extinction_expression = null;
		ls_extinction_method = null;
		ls_goodness_of_fit_all = null;
		ls_goodness_of_fit_all_esd = null;
		ls_goodness_of_fit_gt = null;
		ls_goodness_of_fit_obs = null;
		ls_goodness_of_fit_obs_esd = null;
		ls_goodness_of_fit_ref = null;
		ls_hydrogen_treatment = null;
		ls_matrix_type = null;
		ls_number_constraints = null;
		ls_number_parameters = null;
		ls_number_reflns_R_free = null;
		ls_number_reflns_R_work = null;
		ls_number_reflns_all = null;
		ls_number_reflns_obs = null;
		ls_number_restraints = null;
		ls_percent_reflns_R_free = null;
		ls_percent_reflns_obs = null;
		ls_redundancy_reflns_all = null;
		ls_redundancy_reflns_obs = null;
		ls_restrained_S_all = null;
		ls_restrained_S_obs = null;
		ls_shift_over_esd_max = null;
		ls_shift_over_esd_mean = null;
		ls_shift_over_su_max = null;
		ls_shift_over_su_max_lt = null;
		ls_shift_over_su_mean = null;
		ls_shift_over_su_mean_lt = null;
		ls_structure_factor_coef = null;
		ls_wR_factor_R_free = null;
		ls_wR_factor_R_work = null;
		ls_wR_factor_all = null;
		ls_wR_factor_obs = null;
		ls_weighting_details = null;
		ls_weighting_scheme = null;
		occupancy_max = null;
		occupancy_min = null;
		overall_FOM_free_R_set = null;
		overall_FOM_work_R_set = null;
		overall_SU_B = null;
		overall_SU_ML = null;
		overall_SU_R_Cruickshank_DPI = null;
		overall_SU_R_free = null;
		pdbx_R_Free_selection_details = null;
		pdbx_data_cutoff_high_absF = null;
		pdbx_data_cutoff_high_rms_absF = null;
		pdbx_data_cutoff_low_absF = null;
		pdbx_density_correlation = null;
		pdbx_isotropic_thermal_model = null;
		pdbx_ls_cross_valid_method = null;
		pdbx_ls_sigma_F = null;
		pdbx_ls_sigma_Fsqd = null;
		pdbx_ls_sigma_I = null;
		pdbx_method_to_determine_struct = null;
		pdbx_overall_ESU_R = null;
		pdbx_overall_ESU_R_Free = null;
		pdbx_pd_Fsqrd_R_factor = null;
		pdbx_pd_Marquardt_correlation_coeff = null;
		pdbx_pd_ls_matrix_band_width = null;
		pdbx_pd_meas_number_of_points = null;
		pdbx_pd_number_of_points = null;
		pdbx_pd_number_of_powder_patterns = null;
		pdbx_pd_proc_ls_prof_R_factor = null;
		pdbx_pd_proc_ls_prof_wR_factor = null;
		pdbx_real_space_R = null;
		pdbx_solvent_ion_probe_radii = null;
		pdbx_solvent_shrinkage_radii = null;
		pdbx_solvent_vdw_probe_radii = null;
		pdbx_starting_model = null;
		pdbx_stereochem_target_val_spec_case = null;
		pdbx_stereochemistry_target_values = null;
		solvent_model_details = null;
		solvent_model_param_bsol = null;
		solvent_model_param_ksol = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine>\n");
			if (B_iso_max != null) ow.write(indent + " <PDBx:B_iso_max>" + B_iso_max + "</PDBx:B_iso_max>\n");
			if (B_iso_mean != null) ow.write(indent + " <PDBx:B_iso_mean>" + B_iso_mean + "</PDBx:B_iso_mean>\n");
			if (B_iso_min != null) ow.write(indent + " <PDBx:B_iso_min>" + B_iso_min + "</PDBx:B_iso_min>\n");
			if (aniso_B11 != null) ow.write(indent + " <PDBx:aniso_B11>" + aniso_B11 + "</PDBx:aniso_B11>\n");
			if (aniso_B12 != null) ow.write(indent + " <PDBx:aniso_B12>" + aniso_B12 + "</PDBx:aniso_B12>\n");
			if (aniso_B13 != null) ow.write(indent + " <PDBx:aniso_B13>" + aniso_B13 + "</PDBx:aniso_B13>\n");
			if (aniso_B22 != null) ow.write(indent + " <PDBx:aniso_B22>" + aniso_B22 + "</PDBx:aniso_B22>\n");
			if (aniso_B23 != null) ow.write(indent + " <PDBx:aniso_B23>" + aniso_B23 + "</PDBx:aniso_B23>\n");
			if (aniso_B33 != null) ow.write(indent + " <PDBx:aniso_B33>" + aniso_B33 + "</PDBx:aniso_B33>\n");
			if (correlation_coeff_Fo_to_Fc != null) ow.write(indent + " <PDBx:correlation_coeff_Fo_to_Fc>" + correlation_coeff_Fo_to_Fc + "</PDBx:correlation_coeff_Fo_to_Fc>\n");
			if (correlation_coeff_Fo_to_Fc_free != null) ow.write(indent + " <PDBx:correlation_coeff_Fo_to_Fc_free>" + correlation_coeff_Fo_to_Fc_free + "</PDBx:correlation_coeff_Fo_to_Fc_free>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (diff_density_max != null) ow.write(indent + " <PDBx:diff_density_max>" + diff_density_max + "</PDBx:diff_density_max>\n");
			if (diff_density_max_esd != null) ow.write(indent + " <PDBx:diff_density_max_esd>" + diff_density_max_esd + "</PDBx:diff_density_max_esd>\n");
			if (diff_density_min != null) ow.write(indent + " <PDBx:diff_density_min>" + diff_density_min + "</PDBx:diff_density_min>\n");
			if (diff_density_min_esd != null) ow.write(indent + " <PDBx:diff_density_min_esd>" + diff_density_min_esd + "</PDBx:diff_density_min_esd>\n");
			if (diff_density_rms != null) ow.write(indent + " <PDBx:diff_density_rms>" + diff_density_rms + "</PDBx:diff_density_rms>\n");
			if (diff_density_rms_esd != null) ow.write(indent + " <PDBx:diff_density_rms_esd>" + diff_density_rms_esd + "</PDBx:diff_density_rms_esd>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (ls_R_Fsqd_factor_obs != null) ow.write(indent + " <PDBx:ls_R_Fsqd_factor_obs>" + ls_R_Fsqd_factor_obs + "</PDBx:ls_R_Fsqd_factor_obs>\n");
			if (ls_R_I_factor_obs != null) ow.write(indent + " <PDBx:ls_R_I_factor_obs>" + ls_R_I_factor_obs + "</PDBx:ls_R_I_factor_obs>\n");
			if (ls_R_factor_R_free != null) ow.write(indent + " <PDBx:ls_R_factor_R_free>" + ls_R_factor_R_free + "</PDBx:ls_R_factor_R_free>\n");
			if (ls_R_factor_R_free_error != null) ow.write(indent + " <PDBx:ls_R_factor_R_free_error>" + ls_R_factor_R_free_error + "</PDBx:ls_R_factor_R_free_error>\n");
			if (ls_R_factor_R_free_error_details != null) ow.write(indent + " <PDBx:ls_R_factor_R_free_error_details>" + ls_R_factor_R_free_error_details + "</PDBx:ls_R_factor_R_free_error_details>\n");
			if (ls_R_factor_R_work != null) ow.write(indent + " <PDBx:ls_R_factor_R_work>" + ls_R_factor_R_work + "</PDBx:ls_R_factor_R_work>\n");
			if (ls_R_factor_all != null) ow.write(indent + " <PDBx:ls_R_factor_all>" + ls_R_factor_all + "</PDBx:ls_R_factor_all>\n");
			if (ls_R_factor_gt != null) ow.write(indent + " <PDBx:ls_R_factor_gt>" + ls_R_factor_gt + "</PDBx:ls_R_factor_gt>\n");
			if (ls_R_factor_obs != null) ow.write(indent + " <PDBx:ls_R_factor_obs>" + ls_R_factor_obs + "</PDBx:ls_R_factor_obs>\n");
			if (ls_abs_structure_Flack != null) ow.write(indent + " <PDBx:ls_abs_structure_Flack>" + ls_abs_structure_Flack + "</PDBx:ls_abs_structure_Flack>\n");
			if (ls_abs_structure_Flack_esd != null) ow.write(indent + " <PDBx:ls_abs_structure_Flack_esd>" + ls_abs_structure_Flack_esd + "</PDBx:ls_abs_structure_Flack_esd>\n");
			if (ls_abs_structure_Rogers != null) ow.write(indent + " <PDBx:ls_abs_structure_Rogers>" + ls_abs_structure_Rogers + "</PDBx:ls_abs_structure_Rogers>\n");
			if (ls_abs_structure_Rogers_esd != null) ow.write(indent + " <PDBx:ls_abs_structure_Rogers_esd>" + ls_abs_structure_Rogers_esd + "</PDBx:ls_abs_structure_Rogers_esd>\n");
			if (ls_abs_structure_details != null) ow.write(indent + " <PDBx:ls_abs_structure_details>" + ls_abs_structure_details + "</PDBx:ls_abs_structure_details>\n");
			if (ls_d_res_high != null) ow.write(indent + " <PDBx:ls_d_res_high>" + ls_d_res_high + "</PDBx:ls_d_res_high>\n");
			if (ls_d_res_low != null) ow.write(indent + " <PDBx:ls_d_res_low>" + ls_d_res_low + "</PDBx:ls_d_res_low>\n");
			if (ls_extinction_coef != null) ow.write(indent + " <PDBx:ls_extinction_coef>" + ls_extinction_coef + "</PDBx:ls_extinction_coef>\n");
			if (ls_extinction_coef_esd != null) ow.write(indent + " <PDBx:ls_extinction_coef_esd>" + ls_extinction_coef_esd + "</PDBx:ls_extinction_coef_esd>\n");
			if (ls_extinction_expression != null) ow.write(indent + " <PDBx:ls_extinction_expression>" + ls_extinction_expression + "</PDBx:ls_extinction_expression>\n");
			if (ls_extinction_method != null) ow.write(indent + " <PDBx:ls_extinction_method>" + ls_extinction_method + "</PDBx:ls_extinction_method>\n");
			if (ls_goodness_of_fit_all != null) ow.write(indent + " <PDBx:ls_goodness_of_fit_all>" + ls_goodness_of_fit_all + "</PDBx:ls_goodness_of_fit_all>\n");
			if (ls_goodness_of_fit_all_esd != null) ow.write(indent + " <PDBx:ls_goodness_of_fit_all_esd>" + ls_goodness_of_fit_all_esd + "</PDBx:ls_goodness_of_fit_all_esd>\n");
			if (ls_goodness_of_fit_gt != null) ow.write(indent + " <PDBx:ls_goodness_of_fit_gt>" + ls_goodness_of_fit_gt + "</PDBx:ls_goodness_of_fit_gt>\n");
			if (ls_goodness_of_fit_obs != null) ow.write(indent + " <PDBx:ls_goodness_of_fit_obs>" + ls_goodness_of_fit_obs + "</PDBx:ls_goodness_of_fit_obs>\n");
			if (ls_goodness_of_fit_obs_esd != null) ow.write(indent + " <PDBx:ls_goodness_of_fit_obs_esd>" + ls_goodness_of_fit_obs_esd + "</PDBx:ls_goodness_of_fit_obs_esd>\n");
			if (ls_goodness_of_fit_ref != null) ow.write(indent + " <PDBx:ls_goodness_of_fit_ref>" + ls_goodness_of_fit_ref + "</PDBx:ls_goodness_of_fit_ref>\n");
			if (ls_hydrogen_treatment != null) ow.write(indent + " <PDBx:ls_hydrogen_treatment>" + ls_hydrogen_treatment + "</PDBx:ls_hydrogen_treatment>\n");
			if (ls_matrix_type != null) ow.write(indent + " <PDBx:ls_matrix_type>" + ls_matrix_type + "</PDBx:ls_matrix_type>\n");
			if (ls_number_constraints != null) ow.write(indent + " <PDBx:ls_number_constraints>" + ls_number_constraints + "</PDBx:ls_number_constraints>\n");
			if (ls_number_parameters != null) ow.write(indent + " <PDBx:ls_number_parameters>" + ls_number_parameters + "</PDBx:ls_number_parameters>\n");
			if (ls_number_reflns_R_free != null) ow.write(indent + " <PDBx:ls_number_reflns_R_free>" + ls_number_reflns_R_free + "</PDBx:ls_number_reflns_R_free>\n");
			if (ls_number_reflns_R_work != null) ow.write(indent + " <PDBx:ls_number_reflns_R_work>" + ls_number_reflns_R_work + "</PDBx:ls_number_reflns_R_work>\n");
			if (ls_number_reflns_all != null) ow.write(indent + " <PDBx:ls_number_reflns_all>" + ls_number_reflns_all + "</PDBx:ls_number_reflns_all>\n");
			if (ls_number_reflns_obs != null) ow.write(indent + " <PDBx:ls_number_reflns_obs>" + ls_number_reflns_obs + "</PDBx:ls_number_reflns_obs>\n");
			if (ls_number_restraints != null) ow.write(indent + " <PDBx:ls_number_restraints>" + ls_number_restraints + "</PDBx:ls_number_restraints>\n");
			if (ls_percent_reflns_R_free != null) ow.write(indent + " <PDBx:ls_percent_reflns_R_free>" + ls_percent_reflns_R_free + "</PDBx:ls_percent_reflns_R_free>\n");
			if (ls_percent_reflns_obs != null) ow.write(indent + " <PDBx:ls_percent_reflns_obs>" + ls_percent_reflns_obs + "</PDBx:ls_percent_reflns_obs>\n");
			if (ls_redundancy_reflns_all != null) ow.write(indent + " <PDBx:ls_redundancy_reflns_all>" + ls_redundancy_reflns_all + "</PDBx:ls_redundancy_reflns_all>\n");
			if (ls_redundancy_reflns_obs != null) ow.write(indent + " <PDBx:ls_redundancy_reflns_obs>" + ls_redundancy_reflns_obs + "</PDBx:ls_redundancy_reflns_obs>\n");
			if (ls_restrained_S_all != null) ow.write(indent + " <PDBx:ls_restrained_S_all>" + ls_restrained_S_all + "</PDBx:ls_restrained_S_all>\n");
			if (ls_restrained_S_obs != null) ow.write(indent + " <PDBx:ls_restrained_S_obs>" + ls_restrained_S_obs + "</PDBx:ls_restrained_S_obs>\n");
			if (ls_shift_over_esd_max != null) ow.write(indent + " <PDBx:ls_shift_over_esd_max>" + ls_shift_over_esd_max + "</PDBx:ls_shift_over_esd_max>\n");
			if (ls_shift_over_esd_mean != null) ow.write(indent + " <PDBx:ls_shift_over_esd_mean>" + ls_shift_over_esd_mean + "</PDBx:ls_shift_over_esd_mean>\n");
			if (ls_shift_over_su_max != null) ow.write(indent + " <PDBx:ls_shift_over_su_max>" + ls_shift_over_su_max + "</PDBx:ls_shift_over_su_max>\n");
			if (ls_shift_over_su_max_lt != null) ow.write(indent + " <PDBx:ls_shift_over_su_max_lt>" + ls_shift_over_su_max_lt + "</PDBx:ls_shift_over_su_max_lt>\n");
			if (ls_shift_over_su_mean != null) ow.write(indent + " <PDBx:ls_shift_over_su_mean>" + ls_shift_over_su_mean + "</PDBx:ls_shift_over_su_mean>\n");
			if (ls_shift_over_su_mean_lt != null) ow.write(indent + " <PDBx:ls_shift_over_su_mean_lt>" + ls_shift_over_su_mean_lt + "</PDBx:ls_shift_over_su_mean_lt>\n");
			if (ls_structure_factor_coef != null) ow.write(indent + " <PDBx:ls_structure_factor_coef>" + ls_structure_factor_coef + "</PDBx:ls_structure_factor_coef>\n");
			if (ls_wR_factor_R_free != null) ow.write(indent + " <PDBx:ls_wR_factor_R_free>" + ls_wR_factor_R_free + "</PDBx:ls_wR_factor_R_free>\n");
			if (ls_wR_factor_R_work != null) ow.write(indent + " <PDBx:ls_wR_factor_R_work>" + ls_wR_factor_R_work + "</PDBx:ls_wR_factor_R_work>\n");
			if (ls_wR_factor_all != null) ow.write(indent + " <PDBx:ls_wR_factor_all>" + ls_wR_factor_all + "</PDBx:ls_wR_factor_all>\n");
			if (ls_wR_factor_obs != null) ow.write(indent + " <PDBx:ls_wR_factor_obs>" + ls_wR_factor_obs + "</PDBx:ls_wR_factor_obs>\n");
			if (ls_weighting_details != null) ow.write(indent + " <PDBx:ls_weighting_details>" + ls_weighting_details + "</PDBx:ls_weighting_details>\n");
			if (ls_weighting_scheme != null) ow.write(indent + " <PDBx:ls_weighting_scheme>" + ls_weighting_scheme + "</PDBx:ls_weighting_scheme>\n");
			if (occupancy_max != null) ow.write(indent + " <PDBx:occupancy_max>" + occupancy_max + "</PDBx:occupancy_max>\n");
			if (occupancy_min != null) ow.write(indent + " <PDBx:occupancy_min>" + occupancy_min + "</PDBx:occupancy_min>\n");
			if (overall_FOM_free_R_set != null) ow.write(indent + " <PDBx:overall_FOM_free_R_set>" + overall_FOM_free_R_set + "</PDBx:overall_FOM_free_R_set>\n");
			if (overall_FOM_work_R_set != null) ow.write(indent + " <PDBx:overall_FOM_work_R_set>" + overall_FOM_work_R_set + "</PDBx:overall_FOM_work_R_set>\n");
			if (overall_SU_B != null) ow.write(indent + " <PDBx:overall_SU_B>" + overall_SU_B + "</PDBx:overall_SU_B>\n");
			if (overall_SU_ML != null) ow.write(indent + " <PDBx:overall_SU_ML>" + overall_SU_ML + "</PDBx:overall_SU_ML>\n");
			if (overall_SU_R_Cruickshank_DPI != null) ow.write(indent + " <PDBx:overall_SU_R_Cruickshank_DPI>" + overall_SU_R_Cruickshank_DPI + "</PDBx:overall_SU_R_Cruickshank_DPI>\n");
			if (overall_SU_R_free != null) ow.write(indent + " <PDBx:overall_SU_R_free>" + overall_SU_R_free + "</PDBx:overall_SU_R_free>\n");
			if (pdbx_R_Free_selection_details != null) ow.write(indent + " <PDBx:pdbx_R_Free_selection_details>" + pdbx_R_Free_selection_details + "</PDBx:pdbx_R_Free_selection_details>\n");
			if (pdbx_data_cutoff_high_absF != null) ow.write(indent + " <PDBx:pdbx_data_cutoff_high_absF>" + pdbx_data_cutoff_high_absF + "</PDBx:pdbx_data_cutoff_high_absF>\n");
			if (pdbx_data_cutoff_high_rms_absF != null) ow.write(indent + " <PDBx:pdbx_data_cutoff_high_rms_absF>" + pdbx_data_cutoff_high_rms_absF + "</PDBx:pdbx_data_cutoff_high_rms_absF>\n");
			if (pdbx_data_cutoff_low_absF != null) ow.write(indent + " <PDBx:pdbx_data_cutoff_low_absF>" + pdbx_data_cutoff_low_absF + "</PDBx:pdbx_data_cutoff_low_absF>\n");
			if (pdbx_density_correlation != null) ow.write(indent + " <PDBx:pdbx_density_correlation>" + pdbx_density_correlation + "</PDBx:pdbx_density_correlation>\n");
			if (pdbx_isotropic_thermal_model != null) ow.write(indent + " <PDBx:pdbx_isotropic_thermal_model>" + pdbx_isotropic_thermal_model + "</PDBx:pdbx_isotropic_thermal_model>\n");
			if (pdbx_ls_cross_valid_method != null) ow.write(indent + " <PDBx:pdbx_ls_cross_valid_method>" + pdbx_ls_cross_valid_method + "</PDBx:pdbx_ls_cross_valid_method>\n");
			if (pdbx_ls_sigma_F != null) ow.write(indent + " <PDBx:pdbx_ls_sigma_F>" + pdbx_ls_sigma_F + "</PDBx:pdbx_ls_sigma_F>\n");
			if (pdbx_ls_sigma_Fsqd != null) ow.write(indent + " <PDBx:pdbx_ls_sigma_Fsqd>" + pdbx_ls_sigma_Fsqd + "</PDBx:pdbx_ls_sigma_Fsqd>\n");
			if (pdbx_ls_sigma_I != null) ow.write(indent + " <PDBx:pdbx_ls_sigma_I>" + pdbx_ls_sigma_I + "</PDBx:pdbx_ls_sigma_I>\n");
			if (pdbx_method_to_determine_struct != null) ow.write(indent + " <PDBx:pdbx_method_to_determine_struct>" + pdbx_method_to_determine_struct + "</PDBx:pdbx_method_to_determine_struct>\n");
			if (pdbx_overall_ESU_R != null) ow.write(indent + " <PDBx:pdbx_overall_ESU_R>" + pdbx_overall_ESU_R + "</PDBx:pdbx_overall_ESU_R>\n");
			if (pdbx_overall_ESU_R_Free != null) ow.write(indent + " <PDBx:pdbx_overall_ESU_R_Free>" + pdbx_overall_ESU_R_Free + "</PDBx:pdbx_overall_ESU_R_Free>\n");
			if (pdbx_pd_Fsqrd_R_factor != null) ow.write(indent + " <PDBx:pdbx_pd_Fsqrd_R_factor>" + pdbx_pd_Fsqrd_R_factor + "</PDBx:pdbx_pd_Fsqrd_R_factor>\n");
			if (pdbx_pd_Marquardt_correlation_coeff != null) ow.write(indent + " <PDBx:pdbx_pd_Marquardt_correlation_coeff>" + pdbx_pd_Marquardt_correlation_coeff + "</PDBx:pdbx_pd_Marquardt_correlation_coeff>\n");
			if (pdbx_pd_ls_matrix_band_width != null) ow.write(indent + " <PDBx:pdbx_pd_ls_matrix_band_width>" + pdbx_pd_ls_matrix_band_width + "</PDBx:pdbx_pd_ls_matrix_band_width>\n");
			if (pdbx_pd_meas_number_of_points != null) ow.write(indent + " <PDBx:pdbx_pd_meas_number_of_points>" + pdbx_pd_meas_number_of_points + "</PDBx:pdbx_pd_meas_number_of_points>\n");
			if (pdbx_pd_number_of_points != null) ow.write(indent + " <PDBx:pdbx_pd_number_of_points>" + pdbx_pd_number_of_points + "</PDBx:pdbx_pd_number_of_points>\n");
			if (pdbx_pd_number_of_powder_patterns != null) ow.write(indent + " <PDBx:pdbx_pd_number_of_powder_patterns>" + pdbx_pd_number_of_powder_patterns + "</PDBx:pdbx_pd_number_of_powder_patterns>\n");
			if (pdbx_pd_proc_ls_prof_R_factor != null) ow.write(indent + " <PDBx:pdbx_pd_proc_ls_prof_R_factor>" + pdbx_pd_proc_ls_prof_R_factor + "</PDBx:pdbx_pd_proc_ls_prof_R_factor>\n");
			if (pdbx_pd_proc_ls_prof_wR_factor != null) ow.write(indent + " <PDBx:pdbx_pd_proc_ls_prof_wR_factor>" + pdbx_pd_proc_ls_prof_wR_factor + "</PDBx:pdbx_pd_proc_ls_prof_wR_factor>\n");
			if (pdbx_real_space_R != null) ow.write(indent + " <PDBx:pdbx_real_space_R>" + pdbx_real_space_R + "</PDBx:pdbx_real_space_R>\n");
			if (pdbx_solvent_ion_probe_radii != null) ow.write(indent + " <PDBx:pdbx_solvent_ion_probe_radii>" + pdbx_solvent_ion_probe_radii + "</PDBx:pdbx_solvent_ion_probe_radii>\n");
			if (pdbx_solvent_shrinkage_radii != null) ow.write(indent + " <PDBx:pdbx_solvent_shrinkage_radii>" + pdbx_solvent_shrinkage_radii + "</PDBx:pdbx_solvent_shrinkage_radii>\n");
			if (pdbx_solvent_vdw_probe_radii != null) ow.write(indent + " <PDBx:pdbx_solvent_vdw_probe_radii>" + pdbx_solvent_vdw_probe_radii + "</PDBx:pdbx_solvent_vdw_probe_radii>\n");
			if (pdbx_starting_model != null) ow.write(indent + " <PDBx:pdbx_starting_model>" + pdbx_starting_model + "</PDBx:pdbx_starting_model>\n");
			if (pdbx_stereochem_target_val_spec_case != null) ow.write(indent + " <PDBx:pdbx_stereochem_target_val_spec_case>" + pdbx_stereochem_target_val_spec_case + "</PDBx:pdbx_stereochem_target_val_spec_case>\n");
			if (pdbx_stereochemistry_target_values != null) ow.write(indent + " <PDBx:pdbx_stereochemistry_target_values>" + pdbx_stereochemistry_target_values + "</PDBx:pdbx_stereochemistry_target_values>\n");
			if (solvent_model_details != null) ow.write(indent + " <PDBx:solvent_model_details>" + solvent_model_details + "</PDBx:solvent_model_details>\n");
			if (solvent_model_param_bsol != null) ow.write(indent + " <PDBx:solvent_model_param_bsol>" + solvent_model_param_bsol + "</PDBx:solvent_model_param_bsol>\n");
			if (solvent_model_param_ksol != null) ow.write(indent + " <PDBx:solvent_model_param_ksol>" + solvent_model_param_ksol + "</PDBx:solvent_model_param_ksol>\n");
			ow.write(indent + "</PDBx:refine>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
