package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_HIST category record details about the
 *  steps during the refinement of the structure.
 *  These data items are not meant to be as thorough a description
 *  of the refinement as is provided for the final model in other
 *  categories; rather, these data items provide a mechanism for
 *  sketching out the progress of the refinement, supported by a
 *  small set of representative statistics.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide [(POG)4 EKG (POG)5]3.
 *  <PDBx:refine_histCategory>
 *  <PDBx:refine_hist cycle_id="C134">
 *  <PDBx:d_res_high>1.85</PDBx:d_res_high>
 *  <PDBx:d_res_low>20.0</PDBx:d_res_low>
 *  <PDBx:number_atoms_solvent>217</PDBx:number_atoms_solvent>
 *  <PDBx:number_atoms_total>808</PDBx:number_atoms_total>
 *  <PDBx:number_reflns_all>6174</PDBx:number_reflns_all>
 *  <PDBx:number_reflns_obs>4886</PDBx:number_reflns_obs>
 *  <PDBx:number_reflns_R_free>476</PDBx:number_reflns_R_free>
 *  <PDBx:number_reflns_R_work>4410</PDBx:number_reflns_R_work>
 *  <PDBx:R_factor_all>.265</PDBx:R_factor_all>
 *  <PDBx:R_factor_obs>.195</PDBx:R_factor_obs>
 *  <PDBx:R_factor_R_free>.274</PDBx:R_factor_R_free>
 *  <PDBx:R_factor_R_work>.160</PDBx:R_factor_R_work>
 *  <PDBx:details> Add majority of solvent molecules. B factors refined by
 *  group. Continued to remove misplaced water molecules.</PDBx:details>
 *  </PDBx:refine_hist>
 *  </PDBx:refine_histCategory>
 * </pre>
 */
public class Refine_hist extends org.pdb.beans.Refine_hist implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_hist";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_hist()
	{
	}

	/** Full constructor */
	public Refine_hist(
		Datablock datablock,
		java.lang.Float R_factor_R_free,
		java.lang.Float R_factor_R_work,
		java.lang.Float R_factor_all,
		java.lang.Float R_factor_obs,
		java.lang.String cycle_id,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String details,
		java.lang.Integer number_atoms_solvent,
		java.lang.Integer number_atoms_total,
		java.lang.Integer number_reflns_R_free,
		java.lang.Integer number_reflns_R_work,
		java.lang.Integer number_reflns_all,
		java.lang.Integer number_reflns_obs,
		java.lang.Integer pdbx_number_atoms_carb,
		java.lang.Integer pdbx_number_atoms_ligand,
		java.lang.Integer pdbx_number_atoms_lipid,
		java.lang.Integer pdbx_number_atoms_nucleic_acid,
		java.lang.Integer pdbx_number_atoms_protein,
		java.lang.String pdbx_pseudo_atom_details)
	{
		this.datablock = datablock;
		this.R_factor_R_free = R_factor_R_free;
		this.R_factor_R_work = R_factor_R_work;
		this.R_factor_all = R_factor_all;
		this.R_factor_obs = R_factor_obs;
		this.cycle_id = cycle_id;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.details = details;
		this.number_atoms_solvent = number_atoms_solvent;
		this.number_atoms_total = number_atoms_total;
		this.number_reflns_R_free = number_reflns_R_free;
		this.number_reflns_R_work = number_reflns_R_work;
		this.number_reflns_all = number_reflns_all;
		this.number_reflns_obs = number_reflns_obs;
		this.pdbx_number_atoms_carb = pdbx_number_atoms_carb;
		this.pdbx_number_atoms_ligand = pdbx_number_atoms_ligand;
		this.pdbx_number_atoms_lipid = pdbx_number_atoms_lipid;
		this.pdbx_number_atoms_nucleic_acid = pdbx_number_atoms_nucleic_acid;
		this.pdbx_number_atoms_protein = pdbx_number_atoms_protein;
		this.pdbx_pseudo_atom_details = pdbx_pseudo_atom_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_hist");
		sb.append("\n");
		if (R_factor_R_free != null)
		{
			sb.append("R_factor_R_free = ");
			sb.append(R_factor_R_free);
			sb.append('\n');
		}
		if (R_factor_R_work != null)
		{
			sb.append("R_factor_R_work = ");
			sb.append(R_factor_R_work);
			sb.append('\n');
		}
		if (R_factor_all != null)
		{
			sb.append("R_factor_all = ");
			sb.append(R_factor_all);
			sb.append('\n');
		}
		if (R_factor_obs != null)
		{
			sb.append("R_factor_obs = ");
			sb.append(R_factor_obs);
			sb.append('\n');
		}
		if (cycle_id != null)
		{
			sb.append("cycle_id = ");
			sb.append(cycle_id);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (number_atoms_solvent != null)
		{
			sb.append("number_atoms_solvent = ");
			sb.append(number_atoms_solvent);
			sb.append('\n');
		}
		if (number_atoms_total != null)
		{
			sb.append("number_atoms_total = ");
			sb.append(number_atoms_total);
			sb.append('\n');
		}
		if (number_reflns_R_free != null)
		{
			sb.append("number_reflns_R_free = ");
			sb.append(number_reflns_R_free);
			sb.append('\n');
		}
		if (number_reflns_R_work != null)
		{
			sb.append("number_reflns_R_work = ");
			sb.append(number_reflns_R_work);
			sb.append('\n');
		}
		if (number_reflns_all != null)
		{
			sb.append("number_reflns_all = ");
			sb.append(number_reflns_all);
			sb.append('\n');
		}
		if (number_reflns_obs != null)
		{
			sb.append("number_reflns_obs = ");
			sb.append(number_reflns_obs);
			sb.append('\n');
		}
		if (pdbx_number_atoms_carb != null)
		{
			sb.append("pdbx_number_atoms_carb = ");
			sb.append(pdbx_number_atoms_carb);
			sb.append('\n');
		}
		if (pdbx_number_atoms_ligand != null)
		{
			sb.append("pdbx_number_atoms_ligand = ");
			sb.append(pdbx_number_atoms_ligand);
			sb.append('\n');
		}
		if (pdbx_number_atoms_lipid != null)
		{
			sb.append("pdbx_number_atoms_lipid = ");
			sb.append(pdbx_number_atoms_lipid);
			sb.append('\n');
		}
		if (pdbx_number_atoms_nucleic_acid != null)
		{
			sb.append("pdbx_number_atoms_nucleic_acid = ");
			sb.append(pdbx_number_atoms_nucleic_acid);
			sb.append('\n');
		}
		if (pdbx_number_atoms_protein != null)
		{
			sb.append("pdbx_number_atoms_protein = ");
			sb.append(pdbx_number_atoms_protein);
			sb.append('\n');
		}
		if (pdbx_pseudo_atom_details != null)
		{
			sb.append("pdbx_pseudo_atom_details = ");
			sb.append(pdbx_pseudo_atom_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_factor_R_free = null;
		R_factor_R_work = null;
		R_factor_all = null;
		R_factor_obs = null;
		cycle_id = null;
		d_res_high = null;
		d_res_low = null;
		details = null;
		number_atoms_solvent = null;
		number_atoms_total = null;
		number_reflns_R_free = null;
		number_reflns_R_work = null;
		number_reflns_all = null;
		number_reflns_obs = null;
		pdbx_number_atoms_carb = null;
		pdbx_number_atoms_ligand = null;
		pdbx_number_atoms_lipid = null;
		pdbx_number_atoms_nucleic_acid = null;
		pdbx_number_atoms_protein = null;
		pdbx_pseudo_atom_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_hist)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_hist>\n");
			if (R_factor_R_free != null) ow.write(indent + " <PDBx:R_factor_R_free>" + R_factor_R_free + "</PDBx:R_factor_R_free>\n");
			if (R_factor_R_work != null) ow.write(indent + " <PDBx:R_factor_R_work>" + R_factor_R_work + "</PDBx:R_factor_R_work>\n");
			if (R_factor_all != null) ow.write(indent + " <PDBx:R_factor_all>" + R_factor_all + "</PDBx:R_factor_all>\n");
			if (R_factor_obs != null) ow.write(indent + " <PDBx:R_factor_obs>" + R_factor_obs + "</PDBx:R_factor_obs>\n");
			if (cycle_id != null) ow.write(indent + " <PDBx:cycle_id>" + cycle_id + "</PDBx:cycle_id>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (number_atoms_solvent != null) ow.write(indent + " <PDBx:number_atoms_solvent>" + number_atoms_solvent + "</PDBx:number_atoms_solvent>\n");
			if (number_atoms_total != null) ow.write(indent + " <PDBx:number_atoms_total>" + number_atoms_total + "</PDBx:number_atoms_total>\n");
			if (number_reflns_R_free != null) ow.write(indent + " <PDBx:number_reflns_R_free>" + number_reflns_R_free + "</PDBx:number_reflns_R_free>\n");
			if (number_reflns_R_work != null) ow.write(indent + " <PDBx:number_reflns_R_work>" + number_reflns_R_work + "</PDBx:number_reflns_R_work>\n");
			if (number_reflns_all != null) ow.write(indent + " <PDBx:number_reflns_all>" + number_reflns_all + "</PDBx:number_reflns_all>\n");
			if (number_reflns_obs != null) ow.write(indent + " <PDBx:number_reflns_obs>" + number_reflns_obs + "</PDBx:number_reflns_obs>\n");
			if (pdbx_number_atoms_carb != null) ow.write(indent + " <PDBx:pdbx_number_atoms_carb>" + pdbx_number_atoms_carb + "</PDBx:pdbx_number_atoms_carb>\n");
			if (pdbx_number_atoms_ligand != null) ow.write(indent + " <PDBx:pdbx_number_atoms_ligand>" + pdbx_number_atoms_ligand + "</PDBx:pdbx_number_atoms_ligand>\n");
			if (pdbx_number_atoms_lipid != null) ow.write(indent + " <PDBx:pdbx_number_atoms_lipid>" + pdbx_number_atoms_lipid + "</PDBx:pdbx_number_atoms_lipid>\n");
			if (pdbx_number_atoms_nucleic_acid != null) ow.write(indent + " <PDBx:pdbx_number_atoms_nucleic_acid>" + pdbx_number_atoms_nucleic_acid + "</PDBx:pdbx_number_atoms_nucleic_acid>\n");
			if (pdbx_number_atoms_protein != null) ow.write(indent + " <PDBx:pdbx_number_atoms_protein>" + pdbx_number_atoms_protein + "</PDBx:pdbx_number_atoms_protein>\n");
			if (pdbx_pseudo_atom_details != null) ow.write(indent + " <PDBx:pdbx_pseudo_atom_details>" + pdbx_pseudo_atom_details + "</PDBx:pdbx_pseudo_atom_details>\n");
			ow.write(indent + "</PDBx:refine_hist>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
