package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_LS_CLASS category record details
 *  about the reflections used for the structure refinement
 *  for each reflection class separately.
 *  
 * <pre>
 *  Example 1 - data for a modulated structure from van Smaalen
 *  [J. Phys. Condens. Matter (1991),  3, 1247-1263].
 *  <PDBx:refine_ls_classCategory>
 *  <PDBx:refine_ls_class code="Main">
 *  <PDBx:R_factor_gt>0.057</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="Com">
 *  <PDBx:R_factor_gt>0.074</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="NbRefls">
 *  <PDBx:R_factor_gt>0.064</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="LaRefls">
 *  <PDBx:R_factor_gt>0.046</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="Sat1">
 *  <PDBx:R_factor_gt>0.112</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="Sat2">
 *  <PDBx:R_factor_gt>0.177</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  </PDBx:refine_ls_classCategory>
 * </pre>
 */
public class Refine_ls_class extends org.pdb.beans.Refine_ls_class implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_ls_class";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_ls_class()
	{
	}

	/** Full constructor */
	public Refine_ls_class(
		Datablock datablock,
		java.lang.Float R_Fsqd_factor,
		java.lang.Float R_I_factor,
		java.lang.Float R_factor_all,
		java.lang.Float R_factor_gt,
		java.lang.String code,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.Float wR_factor_all)
	{
		this.datablock = datablock;
		this.R_Fsqd_factor = R_Fsqd_factor;
		this.R_I_factor = R_I_factor;
		this.R_factor_all = R_factor_all;
		this.R_factor_gt = R_factor_gt;
		this.code = code;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.wR_factor_all = wR_factor_all;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_ls_class");
		sb.append("\n");
		if (R_Fsqd_factor != null)
		{
			sb.append("R_Fsqd_factor = ");
			sb.append(R_Fsqd_factor);
			sb.append('\n');
		}
		if (R_I_factor != null)
		{
			sb.append("R_I_factor = ");
			sb.append(R_I_factor);
			sb.append('\n');
		}
		if (R_factor_all != null)
		{
			sb.append("R_factor_all = ");
			sb.append(R_factor_all);
			sb.append('\n');
		}
		if (R_factor_gt != null)
		{
			sb.append("R_factor_gt = ");
			sb.append(R_factor_gt);
			sb.append('\n');
		}
		if (code != null)
		{
			sb.append("code = ");
			sb.append(code);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (wR_factor_all != null)
		{
			sb.append("wR_factor_all = ");
			sb.append(wR_factor_all);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_Fsqd_factor = null;
		R_I_factor = null;
		R_factor_all = null;
		R_factor_gt = null;
		code = null;
		d_res_high = null;
		d_res_low = null;
		wR_factor_all = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_ls_class)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_ls_class>\n");
			if (R_Fsqd_factor != null) ow.write(indent + " <PDBx:R_Fsqd_factor>" + R_Fsqd_factor + "</PDBx:R_Fsqd_factor>\n");
			if (R_I_factor != null) ow.write(indent + " <PDBx:R_I_factor>" + R_I_factor + "</PDBx:R_I_factor>\n");
			if (R_factor_all != null) ow.write(indent + " <PDBx:R_factor_all>" + R_factor_all + "</PDBx:R_factor_all>\n");
			if (R_factor_gt != null) ow.write(indent + " <PDBx:R_factor_gt>" + R_factor_gt + "</PDBx:R_factor_gt>\n");
			if (code != null) ow.write(indent + " <PDBx:code>" + code + "</PDBx:code>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (wR_factor_all != null) ow.write(indent + " <PDBx:wR_factor_all>" + wR_factor_all + "</PDBx:wR_factor_all>\n");
			ow.write(indent + "</PDBx:refine_ls_class>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
