package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_LS_RESTR_NCS category record details
 *  about the restraints applied to atom positions in domains
 *  related by noncrystallographic symmetry during least-squares
 *  refinement, and also about the deviation of the restrained
 *  atomic parameters at the end of the refinement.  It is
 *  expected that these values will only be reported once for each
 *  set of restrained domains.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:refine_ls_restr_ncsCategory>
 *  <PDBx:refine_ls_restr_ncs dom_id="d2" pdbx_asym_id="A" pdbx_type="medium positional">
 *  <PDBx:weight_position>300.0</PDBx:weight_position>
 *  <PDBx:weight_B_iso>2.0</PDBx:weight_B_iso>
 *  <PDBx:rms_dev_position>0.09</PDBx:rms_dev_position>
 *  <PDBx:rms_dev_B_iso>0.16</PDBx:rms_dev_B_iso>
 *  <PDBx:ncs_model_details>
 *  NCS restraint for pseudo-twofold symmetry between domains
 *  d1 and d2.  Position weight coefficient given in
 *  Kcal/(mol \&#37;A^2^) and isotropic B weight coefficient given
 *  in \&#37;A^2^.</PDBx:ncs_model_details>
 *  </PDBx:refine_ls_restr_ncs>
 *  </PDBx:refine_ls_restr_ncsCategory>
 * </pre>
 */
public class Refine_ls_restr_ncs extends org.pdb.beans.Refine_ls_restr_ncs implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_ls_restr_ncs";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_ls_restr_ncs()
	{
	}

	/** Full constructor */
	public Refine_ls_restr_ncs(
		Datablock datablock,
		java.lang.String dom_id,
		java.lang.String ncs_model_details,
		java.lang.String pdbx_asym_id,
		java.lang.Integer pdbx_number,
		java.lang.Float pdbx_rms,
		java.lang.String pdbx_type,
		java.lang.Float pdbx_weight,
		java.lang.Float rms_dev_B_iso,
		java.lang.Float rms_dev_position,
		java.lang.Float weight_B_iso,
		java.lang.Float weight_position)
	{
		this.datablock = datablock;
		this.dom_id = dom_id;
		this.ncs_model_details = ncs_model_details;
		this.pdbx_asym_id = pdbx_asym_id;
		this.pdbx_number = pdbx_number;
		this.pdbx_rms = pdbx_rms;
		this.pdbx_type = pdbx_type;
		this.pdbx_weight = pdbx_weight;
		this.rms_dev_B_iso = rms_dev_B_iso;
		this.rms_dev_position = rms_dev_position;
		this.weight_B_iso = weight_B_iso;
		this.weight_position = weight_position;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_ls_restr_ncs");
		sb.append("\n");
		if (dom_id != null)
		{
			sb.append("dom_id = ");
			sb.append(dom_id);
			sb.append('\n');
		}
		if (ncs_model_details != null)
		{
			sb.append("ncs_model_details = ");
			sb.append(ncs_model_details);
			sb.append('\n');
		}
		if (pdbx_asym_id != null)
		{
			sb.append("pdbx_asym_id = ");
			sb.append(pdbx_asym_id);
			sb.append('\n');
		}
		if (pdbx_number != null)
		{
			sb.append("pdbx_number = ");
			sb.append(pdbx_number);
			sb.append('\n');
		}
		if (pdbx_rms != null)
		{
			sb.append("pdbx_rms = ");
			sb.append(pdbx_rms);
			sb.append('\n');
		}
		if (pdbx_type != null)
		{
			sb.append("pdbx_type = ");
			sb.append(pdbx_type);
			sb.append('\n');
		}
		if (pdbx_weight != null)
		{
			sb.append("pdbx_weight = ");
			sb.append(pdbx_weight);
			sb.append('\n');
		}
		if (rms_dev_B_iso != null)
		{
			sb.append("rms_dev_B_iso = ");
			sb.append(rms_dev_B_iso);
			sb.append('\n');
		}
		if (rms_dev_position != null)
		{
			sb.append("rms_dev_position = ");
			sb.append(rms_dev_position);
			sb.append('\n');
		}
		if (weight_B_iso != null)
		{
			sb.append("weight_B_iso = ");
			sb.append(weight_B_iso);
			sb.append('\n');
		}
		if (weight_position != null)
		{
			sb.append("weight_position = ");
			sb.append(weight_position);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		dom_id = null;
		ncs_model_details = null;
		pdbx_asym_id = null;
		pdbx_number = null;
		pdbx_rms = null;
		pdbx_type = null;
		pdbx_weight = null;
		rms_dev_B_iso = null;
		rms_dev_position = null;
		weight_B_iso = null;
		weight_position = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_ls_restr_ncs)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_ls_restr_ncs>\n");
			if (dom_id != null) ow.write(indent + " <PDBx:dom_id>" + dom_id + "</PDBx:dom_id>\n");
			if (ncs_model_details != null) ow.write(indent + " <PDBx:ncs_model_details>" + ncs_model_details + "</PDBx:ncs_model_details>\n");
			if (pdbx_asym_id != null) ow.write(indent + " <PDBx:pdbx_asym_id>" + pdbx_asym_id + "</PDBx:pdbx_asym_id>\n");
			if (pdbx_number != null) ow.write(indent + " <PDBx:pdbx_number>" + pdbx_number + "</PDBx:pdbx_number>\n");
			if (pdbx_rms != null) ow.write(indent + " <PDBx:pdbx_rms>" + pdbx_rms + "</PDBx:pdbx_rms>\n");
			if (pdbx_type != null) ow.write(indent + " <PDBx:pdbx_type>" + pdbx_type + "</PDBx:pdbx_type>\n");
			if (pdbx_weight != null) ow.write(indent + " <PDBx:pdbx_weight>" + pdbx_weight + "</PDBx:pdbx_weight>\n");
			if (rms_dev_B_iso != null) ow.write(indent + " <PDBx:rms_dev_B_iso>" + rms_dev_B_iso + "</PDBx:rms_dev_B_iso>\n");
			if (rms_dev_position != null) ow.write(indent + " <PDBx:rms_dev_position>" + rms_dev_position + "</PDBx:rms_dev_position>\n");
			if (weight_B_iso != null) ow.write(indent + " <PDBx:weight_B_iso>" + weight_B_iso + "</PDBx:weight_B_iso>\n");
			if (weight_position != null) ow.write(indent + " <PDBx:weight_position>" + weight_position + "</PDBx:weight_position>\n");
			ow.write(indent + "</PDBx:refine_ls_restr_ncs>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
