package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_LS_SHELL category record details about
 *  the results of the least-squares refinement broken down into
 *  shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_ls_shellCategory>
 *  <PDBx:refine_ls_shell d_res_low="8.00" d_res_high="4.51">
 *  <PDBx:number_reflns_obs>1226</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.196</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="4.51" d_res_high="3.48">
 *  <PDBx:number_reflns_obs>1679</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.146</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="3.48" d_res_high="2.94">
 *  <PDBx:number_reflns_obs>2014</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.160</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.94" d_res_high="2.59">
 *  <PDBx:number_reflns_obs>2147</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.182</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.59" d_res_high="2.34">
 *  <PDBx:number_reflns_obs>2127</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.193</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.34" d_res_high="2.15">
 *  <PDBx:number_reflns_obs>2061</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.203</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  <PDBx:refine_ls_shell d_res_low="2.15" d_res_high="2.00">
 *  <PDBx:number_reflns_obs>1647</PDBx:number_reflns_obs>
 *  <PDBx:R_factor_obs>0.188</PDBx:R_factor_obs>
 *  </PDBx:refine_ls_shell>
 *  </PDBx:refine_ls_shellCategory>
 * </pre>
 */
public class Refine_ls_shell extends org.pdb.beans.Refine_ls_shell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_ls_shell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_ls_shell()
	{
	}

	/** Full constructor */
	public Refine_ls_shell(
		Datablock datablock,
		java.lang.Float R_factor_R_free,
		java.lang.Float R_factor_R_free_error,
		java.lang.Float R_factor_R_work,
		java.lang.Float R_factor_all,
		java.lang.Float R_factor_obs,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.Integer number_reflns_R_free,
		java.lang.Integer number_reflns_R_work,
		java.lang.Integer number_reflns_all,
		java.lang.Integer number_reflns_obs,
		java.lang.Integer pdbx_total_number_of_bins_used,
		java.lang.Float percent_reflns_R_free,
		java.lang.Float percent_reflns_obs,
		java.lang.Float redundancy_reflns_all,
		java.lang.Float redundancy_reflns_obs,
		java.lang.Float wR_factor_R_free,
		java.lang.Float wR_factor_R_work,
		java.lang.Float wR_factor_all,
		java.lang.Float wR_factor_obs)
	{
		this.datablock = datablock;
		this.R_factor_R_free = R_factor_R_free;
		this.R_factor_R_free_error = R_factor_R_free_error;
		this.R_factor_R_work = R_factor_R_work;
		this.R_factor_all = R_factor_all;
		this.R_factor_obs = R_factor_obs;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.number_reflns_R_free = number_reflns_R_free;
		this.number_reflns_R_work = number_reflns_R_work;
		this.number_reflns_all = number_reflns_all;
		this.number_reflns_obs = number_reflns_obs;
		this.pdbx_total_number_of_bins_used = pdbx_total_number_of_bins_used;
		this.percent_reflns_R_free = percent_reflns_R_free;
		this.percent_reflns_obs = percent_reflns_obs;
		this.redundancy_reflns_all = redundancy_reflns_all;
		this.redundancy_reflns_obs = redundancy_reflns_obs;
		this.wR_factor_R_free = wR_factor_R_free;
		this.wR_factor_R_work = wR_factor_R_work;
		this.wR_factor_all = wR_factor_all;
		this.wR_factor_obs = wR_factor_obs;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_ls_shell");
		sb.append("\n");
		if (R_factor_R_free != null)
		{
			sb.append("R_factor_R_free = ");
			sb.append(R_factor_R_free);
			sb.append('\n');
		}
		if (R_factor_R_free_error != null)
		{
			sb.append("R_factor_R_free_error = ");
			sb.append(R_factor_R_free_error);
			sb.append('\n');
		}
		if (R_factor_R_work != null)
		{
			sb.append("R_factor_R_work = ");
			sb.append(R_factor_R_work);
			sb.append('\n');
		}
		if (R_factor_all != null)
		{
			sb.append("R_factor_all = ");
			sb.append(R_factor_all);
			sb.append('\n');
		}
		if (R_factor_obs != null)
		{
			sb.append("R_factor_obs = ");
			sb.append(R_factor_obs);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (number_reflns_R_free != null)
		{
			sb.append("number_reflns_R_free = ");
			sb.append(number_reflns_R_free);
			sb.append('\n');
		}
		if (number_reflns_R_work != null)
		{
			sb.append("number_reflns_R_work = ");
			sb.append(number_reflns_R_work);
			sb.append('\n');
		}
		if (number_reflns_all != null)
		{
			sb.append("number_reflns_all = ");
			sb.append(number_reflns_all);
			sb.append('\n');
		}
		if (number_reflns_obs != null)
		{
			sb.append("number_reflns_obs = ");
			sb.append(number_reflns_obs);
			sb.append('\n');
		}
		if (pdbx_total_number_of_bins_used != null)
		{
			sb.append("pdbx_total_number_of_bins_used = ");
			sb.append(pdbx_total_number_of_bins_used);
			sb.append('\n');
		}
		if (percent_reflns_R_free != null)
		{
			sb.append("percent_reflns_R_free = ");
			sb.append(percent_reflns_R_free);
			sb.append('\n');
		}
		if (percent_reflns_obs != null)
		{
			sb.append("percent_reflns_obs = ");
			sb.append(percent_reflns_obs);
			sb.append('\n');
		}
		if (redundancy_reflns_all != null)
		{
			sb.append("redundancy_reflns_all = ");
			sb.append(redundancy_reflns_all);
			sb.append('\n');
		}
		if (redundancy_reflns_obs != null)
		{
			sb.append("redundancy_reflns_obs = ");
			sb.append(redundancy_reflns_obs);
			sb.append('\n');
		}
		if (wR_factor_R_free != null)
		{
			sb.append("wR_factor_R_free = ");
			sb.append(wR_factor_R_free);
			sb.append('\n');
		}
		if (wR_factor_R_work != null)
		{
			sb.append("wR_factor_R_work = ");
			sb.append(wR_factor_R_work);
			sb.append('\n');
		}
		if (wR_factor_all != null)
		{
			sb.append("wR_factor_all = ");
			sb.append(wR_factor_all);
			sb.append('\n');
		}
		if (wR_factor_obs != null)
		{
			sb.append("wR_factor_obs = ");
			sb.append(wR_factor_obs);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_factor_R_free = null;
		R_factor_R_free_error = null;
		R_factor_R_work = null;
		R_factor_all = null;
		R_factor_obs = null;
		d_res_high = null;
		d_res_low = null;
		number_reflns_R_free = null;
		number_reflns_R_work = null;
		number_reflns_all = null;
		number_reflns_obs = null;
		pdbx_total_number_of_bins_used = null;
		percent_reflns_R_free = null;
		percent_reflns_obs = null;
		redundancy_reflns_all = null;
		redundancy_reflns_obs = null;
		wR_factor_R_free = null;
		wR_factor_R_work = null;
		wR_factor_all = null;
		wR_factor_obs = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_ls_shell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_ls_shell>\n");
			if (R_factor_R_free != null) ow.write(indent + " <PDBx:R_factor_R_free>" + R_factor_R_free + "</PDBx:R_factor_R_free>\n");
			if (R_factor_R_free_error != null) ow.write(indent + " <PDBx:R_factor_R_free_error>" + R_factor_R_free_error + "</PDBx:R_factor_R_free_error>\n");
			if (R_factor_R_work != null) ow.write(indent + " <PDBx:R_factor_R_work>" + R_factor_R_work + "</PDBx:R_factor_R_work>\n");
			if (R_factor_all != null) ow.write(indent + " <PDBx:R_factor_all>" + R_factor_all + "</PDBx:R_factor_all>\n");
			if (R_factor_obs != null) ow.write(indent + " <PDBx:R_factor_obs>" + R_factor_obs + "</PDBx:R_factor_obs>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (number_reflns_R_free != null) ow.write(indent + " <PDBx:number_reflns_R_free>" + number_reflns_R_free + "</PDBx:number_reflns_R_free>\n");
			if (number_reflns_R_work != null) ow.write(indent + " <PDBx:number_reflns_R_work>" + number_reflns_R_work + "</PDBx:number_reflns_R_work>\n");
			if (number_reflns_all != null) ow.write(indent + " <PDBx:number_reflns_all>" + number_reflns_all + "</PDBx:number_reflns_all>\n");
			if (number_reflns_obs != null) ow.write(indent + " <PDBx:number_reflns_obs>" + number_reflns_obs + "</PDBx:number_reflns_obs>\n");
			if (pdbx_total_number_of_bins_used != null) ow.write(indent + " <PDBx:pdbx_total_number_of_bins_used>" + pdbx_total_number_of_bins_used + "</PDBx:pdbx_total_number_of_bins_used>\n");
			if (percent_reflns_R_free != null) ow.write(indent + " <PDBx:percent_reflns_R_free>" + percent_reflns_R_free + "</PDBx:percent_reflns_R_free>\n");
			if (percent_reflns_obs != null) ow.write(indent + " <PDBx:percent_reflns_obs>" + percent_reflns_obs + "</PDBx:percent_reflns_obs>\n");
			if (redundancy_reflns_all != null) ow.write(indent + " <PDBx:redundancy_reflns_all>" + redundancy_reflns_all + "</PDBx:redundancy_reflns_all>\n");
			if (redundancy_reflns_obs != null) ow.write(indent + " <PDBx:redundancy_reflns_obs>" + redundancy_reflns_obs + "</PDBx:redundancy_reflns_obs>\n");
			if (wR_factor_R_free != null) ow.write(indent + " <PDBx:wR_factor_R_free>" + wR_factor_R_free + "</PDBx:wR_factor_R_free>\n");
			if (wR_factor_R_work != null) ow.write(indent + " <PDBx:wR_factor_R_work>" + wR_factor_R_work + "</PDBx:wR_factor_R_work>\n");
			if (wR_factor_all != null) ow.write(indent + " <PDBx:wR_factor_all>" + wR_factor_all + "</PDBx:wR_factor_all>\n");
			if (wR_factor_obs != null) ow.write(indent + " <PDBx:wR_factor_obs>" + wR_factor_obs + "</PDBx:wR_factor_obs>\n");
			ow.write(indent + "</PDBx:refine_ls_shell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
