package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_OCCUPANCY category record details
 *  about the treatment of atom occupancies during refinement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_occupancyCategory>
 *  <PDBx:refine_occupancy class="protein">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>1.00</PDBx:value>
 *  </PDBx:refine_occupancy>
 *  <PDBx:refine_occupancy class="solvent">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>1.00</PDBx:value>
 *  </PDBx:refine_occupancy>
 *  <PDBx:refine_occupancy class="inhibitor orientation 1">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>0.65</PDBx:value>
 *  </PDBx:refine_occupancy>
 *  <PDBx:refine_occupancy class="inhibitor orientation 2">
 *  <PDBx:treatment>fix</PDBx:treatment>
 *  <PDBx:value>0.35</PDBx:value>
 *  <PDBx:details> The inhibitor binds to the enzyme in two alternative
 *  conformations. The occupancy of each conformation was
 *  adjusted so as to result in approximately equal mean
 *  thermal factors for the atoms in each conformation.</PDBx:details>
 *  </PDBx:refine_occupancy>
 *  </PDBx:refine_occupancyCategory>
 * </pre>
 */
public class Refine_occupancy extends org.pdb.beans.Refine_occupancy implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_occupancy";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_occupancy()
	{
	}

	/** Full constructor */
	public Refine_occupancy(
		Datablock datablock,
		java.lang.String class_,
		java.lang.String details,
		java.lang.String treatment,
		java.lang.Float value)
	{
		this.datablock = datablock;
		this.class_ = class_;
		this.details = details;
		this.treatment = treatment;
		this.value = value;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_occupancy");
		sb.append("\n");
		if (class_ != null)
		{
			sb.append("class = ");
			sb.append(class_);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (treatment != null)
		{
			sb.append("treatment = ");
			sb.append(treatment);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		class_ = null;
		details = null;
		treatment = null;
		value = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_occupancy)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_occupancy>\n");
			if (class_ != null) ow.write(indent + " <PDBx:class>" + class_ + "</PDBx:class>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (treatment != null) ow.write(indent + " <PDBx:treatment>" + treatment + "</PDBx:treatment>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			ow.write(indent + "</PDBx:refine_occupancy>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
