package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the SOFTWARE category record details about
 *  the software used in the structure analysis, which implies
 *  any software used in the generation of any data items
 *  associated with the structure determination and
 *  structure representation.
 *  
 *  These data items allow computer programs to be referenced
 *  in more detail than data items in the COMPUTING category do.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:softwareCategory>
 *  <PDBx:software name="Prolsq" version="unknown" classification="refinement">
 *  <PDBx:type>program</PDBx:type>
 *  <PDBx:contact_author>Wayne A. Hendrickson</PDBx:contact_author>
 *  <PDBx:location>ftp://rosebud.sdsc.edu/pub/sdsc/xtal/CCP4/ccp4/</PDBx:location>
 *  <PDBx:citation_id>ref5</PDBx:citation_id>
 *  <PDBx:language>Fortran</PDBx:language>
 *  <PDBx:compiler_name>Convex Fortran</PDBx:compiler_name>
 *  <PDBx:compiler_version>v8.0</PDBx:compiler_version>
 *  <PDBx:hardware>Convex C220</PDBx:hardware>
 *  <PDBx:os>ConvexOS</PDBx:os>
 *  <PDBx:os_version>v10.1</PDBx:os_version>
 *  <PDBx:dependencies>Requires that Protin be run first</PDBx:dependencies>
 *  <PDBx:mods>optimized</PDBx:mods>
 *  <PDBx:description>restrained least-squares refinement</PDBx:description>
 *  </PDBx:software>
 *  </PDBx:softwareCategory>
 * </pre>
 */
public class Software extends org.pdb.beans.Software implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "software";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Software()
	{
	}

	/** Full constructor */
	public Software(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String classification,
		java.lang.String compiler_name,
		java.lang.String compiler_version,
		java.lang.String contact_author,
		java.lang.String contact_author_email,
		java.lang.String date,
		java.lang.String dependencies,
		java.lang.String description,
		java.lang.String hardware,
		java.lang.String language,
		java.lang.String location,
		java.lang.String mods,
		java.lang.String name,
		java.lang.String os,
		java.lang.String os_version,
		java.lang.String type,
		java.lang.String version)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.classification = classification;
		this.compiler_name = compiler_name;
		this.compiler_version = compiler_version;
		this.contact_author = contact_author;
		this.contact_author_email = contact_author_email;
		this.date = date;
		this.dependencies = dependencies;
		this.description = description;
		this.hardware = hardware;
		this.language = language;
		this.location = location;
		this.mods = mods;
		this.name = name;
		this.os = os;
		this.os_version = os_version;
		this.type = type;
		this.version = version;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Software");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (classification != null)
		{
			sb.append("classification = ");
			sb.append(classification);
			sb.append('\n');
		}
		if (compiler_name != null)
		{
			sb.append("compiler_name = ");
			sb.append(compiler_name);
			sb.append('\n');
		}
		if (compiler_version != null)
		{
			sb.append("compiler_version = ");
			sb.append(compiler_version);
			sb.append('\n');
		}
		if (contact_author != null)
		{
			sb.append("contact_author = ");
			sb.append(contact_author);
			sb.append('\n');
		}
		if (contact_author_email != null)
		{
			sb.append("contact_author_email = ");
			sb.append(contact_author_email);
			sb.append('\n');
		}
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (dependencies != null)
		{
			sb.append("dependencies = ");
			sb.append(dependencies);
			sb.append('\n');
		}
		if (description != null)
		{
			sb.append("description = ");
			sb.append(description);
			sb.append('\n');
		}
		if (hardware != null)
		{
			sb.append("hardware = ");
			sb.append(hardware);
			sb.append('\n');
		}
		if (language != null)
		{
			sb.append("language = ");
			sb.append(language);
			sb.append('\n');
		}
		if (location != null)
		{
			sb.append("location = ");
			sb.append(location);
			sb.append('\n');
		}
		if (mods != null)
		{
			sb.append("mods = ");
			sb.append(mods);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (os != null)
		{
			sb.append("os = ");
			sb.append(os);
			sb.append('\n');
		}
		if (os_version != null)
		{
			sb.append("os_version = ");
			sb.append(os_version);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (version != null)
		{
			sb.append("version = ");
			sb.append(version);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		classification = null;
		compiler_name = null;
		compiler_version = null;
		contact_author = null;
		contact_author_email = null;
		date = null;
		dependencies = null;
		description = null;
		hardware = null;
		language = null;
		location = null;
		mods = null;
		name = null;
		os = null;
		os_version = null;
		type = null;
		version = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Software)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:software>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (classification != null) ow.write(indent + " <PDBx:classification>" + classification + "</PDBx:classification>\n");
			if (compiler_name != null) ow.write(indent + " <PDBx:compiler_name>" + compiler_name + "</PDBx:compiler_name>\n");
			if (compiler_version != null) ow.write(indent + " <PDBx:compiler_version>" + compiler_version + "</PDBx:compiler_version>\n");
			if (contact_author != null) ow.write(indent + " <PDBx:contact_author>" + contact_author + "</PDBx:contact_author>\n");
			if (contact_author_email != null) ow.write(indent + " <PDBx:contact_author_email>" + contact_author_email + "</PDBx:contact_author_email>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (dependencies != null) ow.write(indent + " <PDBx:dependencies>" + dependencies + "</PDBx:dependencies>\n");
			if (description != null) ow.write(indent + " <PDBx:description>" + description + "</PDBx:description>\n");
			if (hardware != null) ow.write(indent + " <PDBx:hardware>" + hardware + "</PDBx:hardware>\n");
			if (language != null) ow.write(indent + " <PDBx:language>" + language + "</PDBx:language>\n");
			if (location != null) ow.write(indent + " <PDBx:location>" + location + "</PDBx:location>\n");
			if (mods != null) ow.write(indent + " <PDBx:mods>" + mods + "</PDBx:mods>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (os != null) ow.write(indent + " <PDBx:os>" + os + "</PDBx:os>\n");
			if (os_version != null) ow.write(indent + " <PDBx:os_version>" + os_version + "</PDBx:os_version>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (version != null) ow.write(indent + " <PDBx:version>" + version + "</PDBx:version>\n");
			ow.write(indent + "</PDBx:software>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
