package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Contains all the data items that refer to the space group as a
 *  whole, such as its name or crystal system. They may be looped,
 *  for example, in a list of space groups and their properties.
 *  
 *  Only a subset of the SPACE_GROUP category items appear in
 *  this dictionary.  The remainder are found in the symmetry CIF
 *  dictionary.
 *  
 *  Space-group types are identified by their number as given in
 *  International Tables for Crystallography Vol. A. Specific
 *  settings of the space groups can be identified either by their
 *  Hall symbol or by specifying their symmetry operations.
 *  
 *  The commonly used Hermann-Mauguin symbol determines the
 *  space-group type uniquely but several different Hermann-Mauguin
 *  symbols may refer to the same space-group type. A Hermann-Mauguin
 *  symbol contains information on the choice of the basis, but not
 *  on the choice of origin.  Different formats for the
 *  Hermann-Mauguin symbol are found in the symmetry CIF dictionary.
 *  
 * <pre>
 *  Example 1 - the monoclinic space group No. 15 with unique axis b.
 *  <PDBx:space_groupCategory>
 *  <PDBx:space_group id="1">
 *  <PDBx:name_H-M_alt>C 2/c</PDBx:name_H-M_alt>
 *  <PDBx:IT_number>15</PDBx:IT_number>
 *  <PDBx:name_Hall>-C 2yc</PDBx:name_Hall>
 *  <PDBx:crystal_system>monoclinic</PDBx:crystal_system>
 *  </PDBx:space_group>
 *  </PDBx:space_groupCategory>
 * </pre>
 */
public class Space_group extends org.pdb.beans.Space_group implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "space_group";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Space_group()
	{
	}

	/** Full constructor */
	public Space_group(
		Datablock datablock,
		java.lang.Integer IT_number,
		java.lang.String crystal_system,
		java.lang.String id_,
		java.lang.String name_H_M_alt,
		java.lang.String name_Hall)
	{
		this.datablock = datablock;
		this.IT_number = IT_number;
		this.crystal_system = crystal_system;
		this.id_ = id_;
		this.name_H_M_alt = name_H_M_alt;
		this.name_Hall = name_Hall;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Space_group");
		sb.append("\n");
		if (IT_number != null)
		{
			sb.append("IT_number = ");
			sb.append(IT_number);
			sb.append('\n');
		}
		if (crystal_system != null)
		{
			sb.append("crystal_system = ");
			sb.append(crystal_system);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (name_H_M_alt != null)
		{
			sb.append("name_H-M_alt = ");
			sb.append(name_H_M_alt);
			sb.append('\n');
		}
		if (name_Hall != null)
		{
			sb.append("name_Hall = ");
			sb.append(name_Hall);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		IT_number = null;
		crystal_system = null;
		id_ = null;
		name_H_M_alt = null;
		name_Hall = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Space_group)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:space_group>\n");
			if (IT_number != null) ow.write(indent + " <PDBx:IT_number>" + IT_number + "</PDBx:IT_number>\n");
			if (crystal_system != null) ow.write(indent + " <PDBx:crystal_system>" + crystal_system + "</PDBx:crystal_system>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (name_H_M_alt != null) ow.write(indent + " <PDBx:name_H-M_alt>" + name_H_M_alt + "</PDBx:name_H-M_alt>\n");
			if (name_Hall != null) ow.write(indent + " <PDBx:name_Hall>" + name_Hall + "</PDBx:name_Hall>\n");
			ow.write(indent + "</PDBx:space_group>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
