package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Contains information about the symmetry operations of the
 *  space group.
 *  
 * <pre>
 *  Example 1 - The symmetry operations for the space group P21/c.
 *  <PDBx:space_group_symopCategory>
 *  <PDBx:space_group_symop id="1">
 *  <PDBx:operation_xyz>x,y,z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  <PDBx:space_group_symop id="2">
 *  <PDBx:operation_xyz>-x,-y,-z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  <PDBx:space_group_symop id="3">
 *  <PDBx:operation_xyz>-x,1/2+y,1/2-z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  <PDBx:space_group_symop id="4">
 *  <PDBx:operation_xyz>x,1/2-y,1/2+z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  </PDBx:space_group_symopCategory>
 * </pre>
 */
public class Space_group_symop extends org.pdb.beans.Space_group_symop implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "space_group_symop";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Space_group_symop()
	{
	}

	/** Full constructor */
	public Space_group_symop(
		Datablock datablock,
		java.lang.String id_,
		java.lang.String operation_xyz,
		java.lang.String sg_id)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.operation_xyz = operation_xyz;
		this.sg_id = sg_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Space_group_symop");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (operation_xyz != null)
		{
			sb.append("operation_xyz = ");
			sb.append(operation_xyz);
			sb.append('\n');
		}
		if (sg_id != null)
		{
			sb.append("sg_id = ");
			sb.append(sg_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		operation_xyz = null;
		sg_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Space_group_symop)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:space_group_symop>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (operation_xyz != null) ow.write(indent + " <PDBx:operation_xyz>" + operation_xyz + "</PDBx:operation_xyz>\n");
			if (sg_id != null) ow.write(indent + " <PDBx:sg_id>" + sg_id + "</PDBx:sg_id>\n");
			ow.write(indent + "</PDBx:space_group_symop>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
