package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_BIOL category record details about
 *  the structural elements that form each structure of biological
 *  significance.
 *  
 *  A given crystal structure may contain many different biological
 *  structures. A given structural component in the asymmetric
 *  unit may be part of more than one biological unit. A given
 *  biological structure may involve crystallographic symmetry.
 *  
 *  For instance, in a structure of a lysozyme-FAB structure, the
 *  light- and heavy-chain components of the FAB could be one
 *  biological unit, while the two chains of the FAB and the lysozyme
 *  could constitute a second biological unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_biolCategory>
 *  <PDBx:struct_biol id="1">
 *  <PDBx:details> significant deviations from twofold symmetry exist in this
 *  dimeric enzyme</PDBx:details>
 *  </PDBx:struct_biol>
 *  <PDBx:struct_biol id="2">
 *  <PDBx:details> The drug binds to this enzyme in two roughly twofold
 *  symmetric modes. Hence this biological unit (2) is roughly
 *  twofold symmetric to biological unit (3). Disorder in the
 *  protein chain indicated with alternative ID 1 should be
 *  used with this biological unit.</PDBx:details>
 *  </PDBx:struct_biol>
 *  <PDBx:struct_biol id="3">
 *  <PDBx:details> The drug binds to this enzyme in two roughly twofold
 *  symmetric modes. Hence this biological unit (3) is roughly
 *  twofold symmetric to biological unit (2). Disorder in the
 *  protein chain indicated with alternative ID 2 should be
 *  used with this biological unit.</PDBx:details>
 *  </PDBx:struct_biol>
 *  </PDBx:struct_biolCategory>
 * </pre>
 */
public class Struct_biol extends org.pdb.beans.Struct_biol implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_biol";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_biol()
	{
	}

	/** Full constructor */
	public Struct_biol(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String pdbx_aggregation_state,
		java.lang.String pdbx_assembly_method,
		java.lang.Float pdbx_formula_weight,
		java.lang.String pdbx_formula_weight_method,
		java.lang.String pdbx_parent_biol_id)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
		this.pdbx_aggregation_state = pdbx_aggregation_state;
		this.pdbx_assembly_method = pdbx_assembly_method;
		this.pdbx_formula_weight = pdbx_formula_weight;
		this.pdbx_formula_weight_method = pdbx_formula_weight_method;
		this.pdbx_parent_biol_id = pdbx_parent_biol_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_biol");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_aggregation_state != null)
		{
			sb.append("pdbx_aggregation_state = ");
			sb.append(pdbx_aggregation_state);
			sb.append('\n');
		}
		if (pdbx_assembly_method != null)
		{
			sb.append("pdbx_assembly_method = ");
			sb.append(pdbx_assembly_method);
			sb.append('\n');
		}
		if (pdbx_formula_weight != null)
		{
			sb.append("pdbx_formula_weight = ");
			sb.append(pdbx_formula_weight);
			sb.append('\n');
		}
		if (pdbx_formula_weight_method != null)
		{
			sb.append("pdbx_formula_weight_method = ");
			sb.append(pdbx_formula_weight_method);
			sb.append('\n');
		}
		if (pdbx_parent_biol_id != null)
		{
			sb.append("pdbx_parent_biol_id = ");
			sb.append(pdbx_parent_biol_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		pdbx_aggregation_state = null;
		pdbx_assembly_method = null;
		pdbx_formula_weight = null;
		pdbx_formula_weight_method = null;
		pdbx_parent_biol_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_biol)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_biol>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_aggregation_state != null) ow.write(indent + " <PDBx:pdbx_aggregation_state>" + pdbx_aggregation_state + "</PDBx:pdbx_aggregation_state>\n");
			if (pdbx_assembly_method != null) ow.write(indent + " <PDBx:pdbx_assembly_method>" + pdbx_assembly_method + "</PDBx:pdbx_assembly_method>\n");
			if (pdbx_formula_weight != null) ow.write(indent + " <PDBx:pdbx_formula_weight>" + pdbx_formula_weight + "</PDBx:pdbx_formula_weight>\n");
			if (pdbx_formula_weight_method != null) ow.write(indent + " <PDBx:pdbx_formula_weight_method>" + pdbx_formula_weight_method + "</PDBx:pdbx_formula_weight_method>\n");
			if (pdbx_parent_biol_id != null) ow.write(indent + " <PDBx:pdbx_parent_biol_id>" + pdbx_parent_biol_id + "</PDBx:pdbx_parent_biol_id>\n");
			ow.write(indent + "</PDBx:struct_biol>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
