package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_BIOL_KEYWORDS category record
 *  keywords that describe each biological unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_biol_keywordsCategory>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartyl-protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartic-protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="acid-protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartyl-proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="aspartic-proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="acid-proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="enzyme"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="protease"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="proteinase"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="1" text="dimer"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="drug-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="inhibitor-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="drug-protease complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="2" text="inhibitor-protease complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="drug-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="inhibitor-enzyme complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="drug-protease complex"></PDBx:struct_biol_keywords>
 *  <PDBx:struct_biol_keywords biol_id="3" text="inhibitor-protease complex"></PDBx:struct_biol_keywords>
 *  </PDBx:struct_biol_keywordsCategory>
 * </pre>
 */
public class Struct_biol_keywords extends org.pdb.beans.Struct_biol_keywords implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_biol_keywords";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_biol_keywords()
	{
	}

	/** Full constructor */
	public Struct_biol_keywords(
		Datablock datablock,
		java.lang.String biol_id,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.biol_id = biol_id;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_biol_keywords");
		sb.append("\n");
		if (biol_id != null)
		{
			sb.append("biol_id = ");
			sb.append(biol_id);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		biol_id = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_biol_keywords)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_biol_keywords>\n");
			if (biol_id != null) ow.write(indent + " <PDBx:biol_id>" + biol_id + "</PDBx:biol_id>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:struct_biol_keywords>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
