package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_CONF category record details about
 *  the backbone conformation of a segment of polymer.
 *  
 *  Data items in the STRUCT_CONF_TYPE category define the
 *  criteria used to identify the backbone conformations.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_confCategory>
 *  <PDBx:struct_conf id="HELX1">
 *  <PDBx:conf_type_id>HELX_RH_AL_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ARG</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>87</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLN</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>92</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="HELX2">
 *  <PDBx:conf_type_id>HELX_RH_AL_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ARG</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>B</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>287</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLN</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>B</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>292</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN1">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>PRO</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>1</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>LEU</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>5</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN2">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>CYS</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>B</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>295</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>PHE</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>B</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>299</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN3">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>CYS</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>95</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>PHE</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>299</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="STRN4">
 *  <PDBx:conf_type_id>STRN_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>PRO</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>B</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>201</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>LEU</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>B</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>205</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN1">
 *  <PDBx:conf_type_id>TURN_TY1P_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ILE</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>15</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLN</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>18</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN2">
 *  <PDBx:conf_type_id>TURN_TY2_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>GLY</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>49</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLY</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>52</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN3">
 *  <PDBx:conf_type_id>TURN_TY1P_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>ILE</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>55</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>HIS</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>69</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  <PDBx:struct_conf id="TURN4">
 *  <PDBx:conf_type_id>TURN_TY1_P</PDBx:conf_type_id>
 *  <PDBx:beg_label_comp_id>THR</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>91</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>GLY</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>94</PDBx:end_label_seq_id>
 *  </PDBx:struct_conf>
 *  </PDBx:struct_confCategory>
 * </pre>
 */
public class Struct_conf extends org.pdb.beans.Struct_conf implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_conf";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_conf()
	{
	}

	/** Full constructor */
	public Struct_conf(
		Datablock datablock,
		java.lang.String beg_auth_asym_id,
		java.lang.String beg_auth_comp_id,
		java.lang.String beg_auth_seq_id,
		java.lang.String beg_label_asym_id,
		java.lang.String beg_label_comp_id,
		java.lang.Integer beg_label_seq_id,
		java.lang.String conf_type_id,
		java.lang.String details,
		java.lang.String end_auth_asym_id,
		java.lang.String end_auth_comp_id,
		java.lang.String end_auth_seq_id,
		java.lang.String end_label_asym_id,
		java.lang.String end_label_comp_id,
		java.lang.Integer end_label_seq_id,
		java.lang.String id_,
		java.lang.String pdbx_PDB_helix_class,
		java.lang.String pdbx_PDB_helix_id,
		java.lang.Integer pdbx_PDB_helix_length,
		java.lang.String pdbx_beg_PDB_ins_code,
		java.lang.String pdbx_end_PDB_ins_code)
	{
		this.datablock = datablock;
		this.beg_auth_asym_id = beg_auth_asym_id;
		this.beg_auth_comp_id = beg_auth_comp_id;
		this.beg_auth_seq_id = beg_auth_seq_id;
		this.beg_label_asym_id = beg_label_asym_id;
		this.beg_label_comp_id = beg_label_comp_id;
		this.beg_label_seq_id = beg_label_seq_id;
		this.conf_type_id = conf_type_id;
		this.details = details;
		this.end_auth_asym_id = end_auth_asym_id;
		this.end_auth_comp_id = end_auth_comp_id;
		this.end_auth_seq_id = end_auth_seq_id;
		this.end_label_asym_id = end_label_asym_id;
		this.end_label_comp_id = end_label_comp_id;
		this.end_label_seq_id = end_label_seq_id;
		this.id_ = id_;
		this.pdbx_PDB_helix_class = pdbx_PDB_helix_class;
		this.pdbx_PDB_helix_id = pdbx_PDB_helix_id;
		this.pdbx_PDB_helix_length = pdbx_PDB_helix_length;
		this.pdbx_beg_PDB_ins_code = pdbx_beg_PDB_ins_code;
		this.pdbx_end_PDB_ins_code = pdbx_end_PDB_ins_code;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_conf");
		sb.append("\n");
		if (beg_auth_asym_id != null)
		{
			sb.append("beg_auth_asym_id = ");
			sb.append(beg_auth_asym_id);
			sb.append('\n');
		}
		if (beg_auth_comp_id != null)
		{
			sb.append("beg_auth_comp_id = ");
			sb.append(beg_auth_comp_id);
			sb.append('\n');
		}
		if (beg_auth_seq_id != null)
		{
			sb.append("beg_auth_seq_id = ");
			sb.append(beg_auth_seq_id);
			sb.append('\n');
		}
		if (beg_label_asym_id != null)
		{
			sb.append("beg_label_asym_id = ");
			sb.append(beg_label_asym_id);
			sb.append('\n');
		}
		if (beg_label_comp_id != null)
		{
			sb.append("beg_label_comp_id = ");
			sb.append(beg_label_comp_id);
			sb.append('\n');
		}
		if (beg_label_seq_id != null)
		{
			sb.append("beg_label_seq_id = ");
			sb.append(beg_label_seq_id);
			sb.append('\n');
		}
		if (conf_type_id != null)
		{
			sb.append("conf_type_id = ");
			sb.append(conf_type_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (end_auth_asym_id != null)
		{
			sb.append("end_auth_asym_id = ");
			sb.append(end_auth_asym_id);
			sb.append('\n');
		}
		if (end_auth_comp_id != null)
		{
			sb.append("end_auth_comp_id = ");
			sb.append(end_auth_comp_id);
			sb.append('\n');
		}
		if (end_auth_seq_id != null)
		{
			sb.append("end_auth_seq_id = ");
			sb.append(end_auth_seq_id);
			sb.append('\n');
		}
		if (end_label_asym_id != null)
		{
			sb.append("end_label_asym_id = ");
			sb.append(end_label_asym_id);
			sb.append('\n');
		}
		if (end_label_comp_id != null)
		{
			sb.append("end_label_comp_id = ");
			sb.append(end_label_comp_id);
			sb.append('\n');
		}
		if (end_label_seq_id != null)
		{
			sb.append("end_label_seq_id = ");
			sb.append(end_label_seq_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_PDB_helix_class != null)
		{
			sb.append("pdbx_PDB_helix_class = ");
			sb.append(pdbx_PDB_helix_class);
			sb.append('\n');
		}
		if (pdbx_PDB_helix_id != null)
		{
			sb.append("pdbx_PDB_helix_id = ");
			sb.append(pdbx_PDB_helix_id);
			sb.append('\n');
		}
		if (pdbx_PDB_helix_length != null)
		{
			sb.append("pdbx_PDB_helix_length = ");
			sb.append(pdbx_PDB_helix_length);
			sb.append('\n');
		}
		if (pdbx_beg_PDB_ins_code != null)
		{
			sb.append("pdbx_beg_PDB_ins_code = ");
			sb.append(pdbx_beg_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_end_PDB_ins_code != null)
		{
			sb.append("pdbx_end_PDB_ins_code = ");
			sb.append(pdbx_end_PDB_ins_code);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		beg_auth_asym_id = null;
		beg_auth_comp_id = null;
		beg_auth_seq_id = null;
		beg_label_asym_id = null;
		beg_label_comp_id = null;
		beg_label_seq_id = null;
		conf_type_id = null;
		details = null;
		end_auth_asym_id = null;
		end_auth_comp_id = null;
		end_auth_seq_id = null;
		end_label_asym_id = null;
		end_label_comp_id = null;
		end_label_seq_id = null;
		id_ = null;
		pdbx_PDB_helix_class = null;
		pdbx_PDB_helix_id = null;
		pdbx_PDB_helix_length = null;
		pdbx_beg_PDB_ins_code = null;
		pdbx_end_PDB_ins_code = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_conf)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_conf>\n");
			if (beg_auth_asym_id != null) ow.write(indent + " <PDBx:beg_auth_asym_id>" + beg_auth_asym_id + "</PDBx:beg_auth_asym_id>\n");
			if (beg_auth_comp_id != null) ow.write(indent + " <PDBx:beg_auth_comp_id>" + beg_auth_comp_id + "</PDBx:beg_auth_comp_id>\n");
			if (beg_auth_seq_id != null) ow.write(indent + " <PDBx:beg_auth_seq_id>" + beg_auth_seq_id + "</PDBx:beg_auth_seq_id>\n");
			if (beg_label_asym_id != null) ow.write(indent + " <PDBx:beg_label_asym_id>" + beg_label_asym_id + "</PDBx:beg_label_asym_id>\n");
			if (beg_label_comp_id != null) ow.write(indent + " <PDBx:beg_label_comp_id>" + beg_label_comp_id + "</PDBx:beg_label_comp_id>\n");
			if (beg_label_seq_id != null) ow.write(indent + " <PDBx:beg_label_seq_id>" + beg_label_seq_id + "</PDBx:beg_label_seq_id>\n");
			if (conf_type_id != null) ow.write(indent + " <PDBx:conf_type_id>" + conf_type_id + "</PDBx:conf_type_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (end_auth_asym_id != null) ow.write(indent + " <PDBx:end_auth_asym_id>" + end_auth_asym_id + "</PDBx:end_auth_asym_id>\n");
			if (end_auth_comp_id != null) ow.write(indent + " <PDBx:end_auth_comp_id>" + end_auth_comp_id + "</PDBx:end_auth_comp_id>\n");
			if (end_auth_seq_id != null) ow.write(indent + " <PDBx:end_auth_seq_id>" + end_auth_seq_id + "</PDBx:end_auth_seq_id>\n");
			if (end_label_asym_id != null) ow.write(indent + " <PDBx:end_label_asym_id>" + end_label_asym_id + "</PDBx:end_label_asym_id>\n");
			if (end_label_comp_id != null) ow.write(indent + " <PDBx:end_label_comp_id>" + end_label_comp_id + "</PDBx:end_label_comp_id>\n");
			if (end_label_seq_id != null) ow.write(indent + " <PDBx:end_label_seq_id>" + end_label_seq_id + "</PDBx:end_label_seq_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_PDB_helix_class != null) ow.write(indent + " <PDBx:pdbx_PDB_helix_class>" + pdbx_PDB_helix_class + "</PDBx:pdbx_PDB_helix_class>\n");
			if (pdbx_PDB_helix_id != null) ow.write(indent + " <PDBx:pdbx_PDB_helix_id>" + pdbx_PDB_helix_id + "</PDBx:pdbx_PDB_helix_id>\n");
			if (pdbx_PDB_helix_length != null) ow.write(indent + " <PDBx:pdbx_PDB_helix_length>" + pdbx_PDB_helix_length + "</PDBx:pdbx_PDB_helix_length>\n");
			if (pdbx_beg_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_beg_PDB_ins_code>" + pdbx_beg_PDB_ins_code + "</PDBx:pdbx_beg_PDB_ins_code>\n");
			if (pdbx_end_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_end_PDB_ins_code>" + pdbx_end_PDB_ins_code + "</PDBx:pdbx_end_PDB_ins_code>\n");
			ow.write(indent + "</PDBx:struct_conf>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
