package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_CONF_TYPE category record details
 *  about the criteria used to identify backbone conformations of a
 *  segment of polymer.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_conf_typeCategory>
 *  <PDBx:struct_conf_type id="HELX_RH_AL_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="STRN_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY1_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY1P_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY2_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  <PDBx:struct_conf_type id="TURN_TY2P_P">
 *  <PDBx:criteria>author judgement</PDBx:criteria>
 *  </PDBx:struct_conf_type>
 *  </PDBx:struct_conf_typeCategory>
 * </pre>
 */
public class Struct_conf_type extends org.pdb.beans.Struct_conf_type implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_conf_type";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_conf_type()
	{
	}

	/** Full constructor */
	public Struct_conf_type(
		Datablock datablock,
		java.lang.String criteria,
		java.lang.String id_,
		java.lang.String reference)
	{
		this.datablock = datablock;
		this.criteria = criteria;
		this.id_ = id_;
		this.reference = reference;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_conf_type");
		sb.append("\n");
		if (criteria != null)
		{
			sb.append("criteria = ");
			sb.append(criteria);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (reference != null)
		{
			sb.append("reference = ");
			sb.append(reference);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		criteria = null;
		id_ = null;
		reference = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_conf_type)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_conf_type>\n");
			if (criteria != null) ow.write(indent + " <PDBx:criteria>" + criteria + "</PDBx:criteria>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (reference != null) ow.write(indent + " <PDBx:reference>" + reference + "</PDBx:reference>\n");
			ow.write(indent + "</PDBx:struct_conf_type>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
