package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_KEYWORDS category specify keywords
 *  that describe the chemical structure in this entry.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_keywordsCategory>
 *  <PDBx:struct_keywords entry_id="5HVP">
 *  <PDBx:text>enzyme-inhibitor complex, aspartyl protease, static disorder</PDBx:text>
 *  </PDBx:struct_keywords>
 *  </PDBx:struct_keywordsCategory>
 * </pre>
 */
public class Struct_keywords extends org.pdb.beans.Struct_keywords implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_keywords";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_keywords()
	{
	}

	/** Full constructor */
	public Struct_keywords(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.String pdbx_keywords,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.pdbx_keywords = pdbx_keywords;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_keywords");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (pdbx_keywords != null)
		{
			sb.append("pdbx_keywords = ");
			sb.append(pdbx_keywords);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		pdbx_keywords = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_keywords)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_keywords>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (pdbx_keywords != null) ow.write(indent + " <PDBx:pdbx_keywords>" + pdbx_keywords + "</PDBx:pdbx_keywords>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:struct_keywords>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
