package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_MON_PROT category record details about
 *  structural properties of a protein when analyzed at the monomer
 *  level. Analogous data items for nucleic acids are given in the
 *  STRUCT_MON_NUCL category. For items where the value of the
 *  property depends on the method employed to calculate it,
 *  details of the method of calculation are given using data items
 *  in the STRUCT_MON_DETAILS category.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for protein NS1.
 *  This example provides details for residue ARG 35.
 *  <PDBx:struct_mon_protCategory>
 *  <PDBx:struct_mon_prot label_comp_id="ARG" label_seq_id="35" label_asym_id="A" label_alt_id="">
 *  <PDBx:chi1>-67.9</PDBx:chi1>
 *  <PDBx:chi2>-174.7</PDBx:chi2>
 *  <PDBx:chi3>-67.7</PDBx:chi3>
 *  <PDBx:chi4>-86.3</PDBx:chi4>
 *  <PDBx:chi5>4.2</PDBx:chi5>
 *  <PDBx:RSCC_all>0.90</PDBx:RSCC_all>
 *  <PDBx:RSR_all>0.18</PDBx:RSR_all>
 *  <PDBx:mean_B_all>30.0</PDBx:mean_B_all>
 *  <PDBx:mean_B_main>25.0</PDBx:mean_B_main>
 *  <PDBx:mean_B_side>35.1</PDBx:mean_B_side>
 *  <PDBx:omega>180.1</PDBx:omega>
 *  <PDBx:phi>-60.3</PDBx:phi>
 *  <PDBx:psi>-46.0</PDBx:psi>
 *  </PDBx:struct_mon_prot>
 *  </PDBx:struct_mon_protCategory>
 * </pre>
 */
public class Struct_mon_prot extends org.pdb.beans.Struct_mon_prot implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_mon_prot";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_mon_prot()
	{
	}

	/** Full constructor */
	public Struct_mon_prot(
		Datablock datablock,
		java.lang.Float RSCC_all,
		java.lang.Float RSCC_main,
		java.lang.Float RSCC_side,
		java.lang.Float RSR_all,
		java.lang.Float RSR_main,
		java.lang.Float RSR_side,
		java.lang.String auth_asym_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.Float chi1,
		java.lang.Float chi2,
		java.lang.Float chi3,
		java.lang.Float chi4,
		java.lang.Float chi5,
		java.lang.Float details,
		java.lang.String label_alt_id,
		java.lang.String label_asym_id,
		java.lang.String label_comp_id,
		java.lang.Integer label_seq_id,
		java.lang.Float mean_B_all,
		java.lang.Float mean_B_main,
		java.lang.Float mean_B_side,
		java.lang.Float omega,
		java.lang.Float phi,
		java.lang.Float psi)
	{
		this.datablock = datablock;
		this.RSCC_all = RSCC_all;
		this.RSCC_main = RSCC_main;
		this.RSCC_side = RSCC_side;
		this.RSR_all = RSR_all;
		this.RSR_main = RSR_main;
		this.RSR_side = RSR_side;
		this.auth_asym_id = auth_asym_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.chi1 = chi1;
		this.chi2 = chi2;
		this.chi3 = chi3;
		this.chi4 = chi4;
		this.chi5 = chi5;
		this.details = details;
		this.label_alt_id = label_alt_id;
		this.label_asym_id = label_asym_id;
		this.label_comp_id = label_comp_id;
		this.label_seq_id = label_seq_id;
		this.mean_B_all = mean_B_all;
		this.mean_B_main = mean_B_main;
		this.mean_B_side = mean_B_side;
		this.omega = omega;
		this.phi = phi;
		this.psi = psi;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_mon_prot");
		sb.append("\n");
		if (RSCC_all != null)
		{
			sb.append("RSCC_all = ");
			sb.append(RSCC_all);
			sb.append('\n');
		}
		if (RSCC_main != null)
		{
			sb.append("RSCC_main = ");
			sb.append(RSCC_main);
			sb.append('\n');
		}
		if (RSCC_side != null)
		{
			sb.append("RSCC_side = ");
			sb.append(RSCC_side);
			sb.append('\n');
		}
		if (RSR_all != null)
		{
			sb.append("RSR_all = ");
			sb.append(RSR_all);
			sb.append('\n');
		}
		if (RSR_main != null)
		{
			sb.append("RSR_main = ");
			sb.append(RSR_main);
			sb.append('\n');
		}
		if (RSR_side != null)
		{
			sb.append("RSR_side = ");
			sb.append(RSR_side);
			sb.append('\n');
		}
		if (auth_asym_id != null)
		{
			sb.append("auth_asym_id = ");
			sb.append(auth_asym_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (chi1 != null)
		{
			sb.append("chi1 = ");
			sb.append(chi1);
			sb.append('\n');
		}
		if (chi2 != null)
		{
			sb.append("chi2 = ");
			sb.append(chi2);
			sb.append('\n');
		}
		if (chi3 != null)
		{
			sb.append("chi3 = ");
			sb.append(chi3);
			sb.append('\n');
		}
		if (chi4 != null)
		{
			sb.append("chi4 = ");
			sb.append(chi4);
			sb.append('\n');
		}
		if (chi5 != null)
		{
			sb.append("chi5 = ");
			sb.append(chi5);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (label_alt_id != null)
		{
			sb.append("label_alt_id = ");
			sb.append(label_alt_id);
			sb.append('\n');
		}
		if (label_asym_id != null)
		{
			sb.append("label_asym_id = ");
			sb.append(label_asym_id);
			sb.append('\n');
		}
		if (label_comp_id != null)
		{
			sb.append("label_comp_id = ");
			sb.append(label_comp_id);
			sb.append('\n');
		}
		if (label_seq_id != null)
		{
			sb.append("label_seq_id = ");
			sb.append(label_seq_id);
			sb.append('\n');
		}
		if (mean_B_all != null)
		{
			sb.append("mean_B_all = ");
			sb.append(mean_B_all);
			sb.append('\n');
		}
		if (mean_B_main != null)
		{
			sb.append("mean_B_main = ");
			sb.append(mean_B_main);
			sb.append('\n');
		}
		if (mean_B_side != null)
		{
			sb.append("mean_B_side = ");
			sb.append(mean_B_side);
			sb.append('\n');
		}
		if (omega != null)
		{
			sb.append("omega = ");
			sb.append(omega);
			sb.append('\n');
		}
		if (phi != null)
		{
			sb.append("phi = ");
			sb.append(phi);
			sb.append('\n');
		}
		if (psi != null)
		{
			sb.append("psi = ");
			sb.append(psi);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		RSCC_all = null;
		RSCC_main = null;
		RSCC_side = null;
		RSR_all = null;
		RSR_main = null;
		RSR_side = null;
		auth_asym_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		chi1 = null;
		chi2 = null;
		chi3 = null;
		chi4 = null;
		chi5 = null;
		details = null;
		label_alt_id = null;
		label_asym_id = null;
		label_comp_id = null;
		label_seq_id = null;
		mean_B_all = null;
		mean_B_main = null;
		mean_B_side = null;
		omega = null;
		phi = null;
		psi = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_mon_prot)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_mon_prot>\n");
			if (RSCC_all != null) ow.write(indent + " <PDBx:RSCC_all>" + RSCC_all + "</PDBx:RSCC_all>\n");
			if (RSCC_main != null) ow.write(indent + " <PDBx:RSCC_main>" + RSCC_main + "</PDBx:RSCC_main>\n");
			if (RSCC_side != null) ow.write(indent + " <PDBx:RSCC_side>" + RSCC_side + "</PDBx:RSCC_side>\n");
			if (RSR_all != null) ow.write(indent + " <PDBx:RSR_all>" + RSR_all + "</PDBx:RSR_all>\n");
			if (RSR_main != null) ow.write(indent + " <PDBx:RSR_main>" + RSR_main + "</PDBx:RSR_main>\n");
			if (RSR_side != null) ow.write(indent + " <PDBx:RSR_side>" + RSR_side + "</PDBx:RSR_side>\n");
			if (auth_asym_id != null) ow.write(indent + " <PDBx:auth_asym_id>" + auth_asym_id + "</PDBx:auth_asym_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (chi1 != null) ow.write(indent + " <PDBx:chi1>" + chi1 + "</PDBx:chi1>\n");
			if (chi2 != null) ow.write(indent + " <PDBx:chi2>" + chi2 + "</PDBx:chi2>\n");
			if (chi3 != null) ow.write(indent + " <PDBx:chi3>" + chi3 + "</PDBx:chi3>\n");
			if (chi4 != null) ow.write(indent + " <PDBx:chi4>" + chi4 + "</PDBx:chi4>\n");
			if (chi5 != null) ow.write(indent + " <PDBx:chi5>" + chi5 + "</PDBx:chi5>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (label_alt_id != null) ow.write(indent + " <PDBx:label_alt_id>" + label_alt_id + "</PDBx:label_alt_id>\n");
			if (label_asym_id != null) ow.write(indent + " <PDBx:label_asym_id>" + label_asym_id + "</PDBx:label_asym_id>\n");
			if (label_comp_id != null) ow.write(indent + " <PDBx:label_comp_id>" + label_comp_id + "</PDBx:label_comp_id>\n");
			if (label_seq_id != null) ow.write(indent + " <PDBx:label_seq_id>" + label_seq_id + "</PDBx:label_seq_id>\n");
			if (mean_B_all != null) ow.write(indent + " <PDBx:mean_B_all>" + mean_B_all + "</PDBx:mean_B_all>\n");
			if (mean_B_main != null) ow.write(indent + " <PDBx:mean_B_main>" + mean_B_main + "</PDBx:mean_B_main>\n");
			if (mean_B_side != null) ow.write(indent + " <PDBx:mean_B_side>" + mean_B_side + "</PDBx:mean_B_side>\n");
			if (omega != null) ow.write(indent + " <PDBx:omega>" + omega + "</PDBx:omega>\n");
			if (phi != null) ow.write(indent + " <PDBx:phi>" + phi + "</PDBx:phi>\n");
			if (psi != null) ow.write(indent + " <PDBx:psi>" + psi + "</PDBx:psi>\n");
			ow.write(indent + "</PDBx:struct_mon_prot>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
