package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_REF_SEQ category provide a mechanism
 *  for indicating and annotating a region (or regions) of alignment
 *  between the sequence of an entity or biological unit described
 *  in the data block and the sequence in the referenced database
 *  entry.
 *  
 * <pre>
 *  Example 1 - based on the sequence alignment of CHER from M. xantus
 *  (36 to 288) and CHER from S. typhimurium (18 to 276).
 *  <PDBx:struct_ref_seqCategory>
 *  <PDBx:struct_ref_seq align_id="alg1">
 *  <PDBx:ref_id>seqdb1</PDBx:ref_id>
 *  <PDBx:seq_align_beg>36</PDBx:seq_align_beg>
 *  <PDBx:seq_align_end>288</PDBx:seq_align_end>
 *  <PDBx:db_align_beg>18</PDBx:db_align_beg>
 *  <PDBx:db_align_end>276</PDBx:db_align_end>
 *  <PDBx:details> The alignment contains 3 gaps larger than 2 residues</PDBx:details>
 *  </PDBx:struct_ref_seq>
 *  </PDBx:struct_ref_seqCategory>
 * </pre>
 */
public class Struct_ref_seq extends org.pdb.beans.Struct_ref_seq implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ref_seq";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ref_seq()
	{
	}

	/** Full constructor */
	public Struct_ref_seq(
		Datablock datablock,
		java.lang.String align_id,
		java.lang.Integer db_align_beg,
		java.lang.Integer db_align_end,
		java.lang.String details,
		java.lang.String pdbx_PDB_id_code,
		java.lang.String pdbx_auth_seq_align_beg,
		java.lang.String pdbx_auth_seq_align_end,
		java.lang.String pdbx_db_accession,
		java.lang.String pdbx_db_align_beg_ins_code,
		java.lang.String pdbx_db_align_end_ins_code,
		java.lang.String pdbx_seq_align_beg_ins_code,
		java.lang.String pdbx_seq_align_end_ins_code,
		java.lang.String pdbx_strand_id,
		java.lang.String ref_id,
		java.lang.Integer seq_align_beg,
		java.lang.Integer seq_align_end)
	{
		this.datablock = datablock;
		this.align_id = align_id;
		this.db_align_beg = db_align_beg;
		this.db_align_end = db_align_end;
		this.details = details;
		this.pdbx_PDB_id_code = pdbx_PDB_id_code;
		this.pdbx_auth_seq_align_beg = pdbx_auth_seq_align_beg;
		this.pdbx_auth_seq_align_end = pdbx_auth_seq_align_end;
		this.pdbx_db_accession = pdbx_db_accession;
		this.pdbx_db_align_beg_ins_code = pdbx_db_align_beg_ins_code;
		this.pdbx_db_align_end_ins_code = pdbx_db_align_end_ins_code;
		this.pdbx_seq_align_beg_ins_code = pdbx_seq_align_beg_ins_code;
		this.pdbx_seq_align_end_ins_code = pdbx_seq_align_end_ins_code;
		this.pdbx_strand_id = pdbx_strand_id;
		this.ref_id = ref_id;
		this.seq_align_beg = seq_align_beg;
		this.seq_align_end = seq_align_end;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ref_seq");
		sb.append("\n");
		if (align_id != null)
		{
			sb.append("align_id = ");
			sb.append(align_id);
			sb.append('\n');
		}
		if (db_align_beg != null)
		{
			sb.append("db_align_beg = ");
			sb.append(db_align_beg);
			sb.append('\n');
		}
		if (db_align_end != null)
		{
			sb.append("db_align_end = ");
			sb.append(db_align_end);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (pdbx_PDB_id_code != null)
		{
			sb.append("pdbx_PDB_id_code = ");
			sb.append(pdbx_PDB_id_code);
			sb.append('\n');
		}
		if (pdbx_auth_seq_align_beg != null)
		{
			sb.append("pdbx_auth_seq_align_beg = ");
			sb.append(pdbx_auth_seq_align_beg);
			sb.append('\n');
		}
		if (pdbx_auth_seq_align_end != null)
		{
			sb.append("pdbx_auth_seq_align_end = ");
			sb.append(pdbx_auth_seq_align_end);
			sb.append('\n');
		}
		if (pdbx_db_accession != null)
		{
			sb.append("pdbx_db_accession = ");
			sb.append(pdbx_db_accession);
			sb.append('\n');
		}
		if (pdbx_db_align_beg_ins_code != null)
		{
			sb.append("pdbx_db_align_beg_ins_code = ");
			sb.append(pdbx_db_align_beg_ins_code);
			sb.append('\n');
		}
		if (pdbx_db_align_end_ins_code != null)
		{
			sb.append("pdbx_db_align_end_ins_code = ");
			sb.append(pdbx_db_align_end_ins_code);
			sb.append('\n');
		}
		if (pdbx_seq_align_beg_ins_code != null)
		{
			sb.append("pdbx_seq_align_beg_ins_code = ");
			sb.append(pdbx_seq_align_beg_ins_code);
			sb.append('\n');
		}
		if (pdbx_seq_align_end_ins_code != null)
		{
			sb.append("pdbx_seq_align_end_ins_code = ");
			sb.append(pdbx_seq_align_end_ins_code);
			sb.append('\n');
		}
		if (pdbx_strand_id != null)
		{
			sb.append("pdbx_strand_id = ");
			sb.append(pdbx_strand_id);
			sb.append('\n');
		}
		if (ref_id != null)
		{
			sb.append("ref_id = ");
			sb.append(ref_id);
			sb.append('\n');
		}
		if (seq_align_beg != null)
		{
			sb.append("seq_align_beg = ");
			sb.append(seq_align_beg);
			sb.append('\n');
		}
		if (seq_align_end != null)
		{
			sb.append("seq_align_end = ");
			sb.append(seq_align_end);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		align_id = null;
		db_align_beg = null;
		db_align_end = null;
		details = null;
		pdbx_PDB_id_code = null;
		pdbx_auth_seq_align_beg = null;
		pdbx_auth_seq_align_end = null;
		pdbx_db_accession = null;
		pdbx_db_align_beg_ins_code = null;
		pdbx_db_align_end_ins_code = null;
		pdbx_seq_align_beg_ins_code = null;
		pdbx_seq_align_end_ins_code = null;
		pdbx_strand_id = null;
		ref_id = null;
		seq_align_beg = null;
		seq_align_end = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ref_seq)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ref_seq>\n");
			if (align_id != null) ow.write(indent + " <PDBx:align_id>" + align_id + "</PDBx:align_id>\n");
			if (db_align_beg != null) ow.write(indent + " <PDBx:db_align_beg>" + db_align_beg + "</PDBx:db_align_beg>\n");
			if (db_align_end != null) ow.write(indent + " <PDBx:db_align_end>" + db_align_end + "</PDBx:db_align_end>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (pdbx_PDB_id_code != null) ow.write(indent + " <PDBx:pdbx_PDB_id_code>" + pdbx_PDB_id_code + "</PDBx:pdbx_PDB_id_code>\n");
			if (pdbx_auth_seq_align_beg != null) ow.write(indent + " <PDBx:pdbx_auth_seq_align_beg>" + pdbx_auth_seq_align_beg + "</PDBx:pdbx_auth_seq_align_beg>\n");
			if (pdbx_auth_seq_align_end != null) ow.write(indent + " <PDBx:pdbx_auth_seq_align_end>" + pdbx_auth_seq_align_end + "</PDBx:pdbx_auth_seq_align_end>\n");
			if (pdbx_db_accession != null) ow.write(indent + " <PDBx:pdbx_db_accession>" + pdbx_db_accession + "</PDBx:pdbx_db_accession>\n");
			if (pdbx_db_align_beg_ins_code != null) ow.write(indent + " <PDBx:pdbx_db_align_beg_ins_code>" + pdbx_db_align_beg_ins_code + "</PDBx:pdbx_db_align_beg_ins_code>\n");
			if (pdbx_db_align_end_ins_code != null) ow.write(indent + " <PDBx:pdbx_db_align_end_ins_code>" + pdbx_db_align_end_ins_code + "</PDBx:pdbx_db_align_end_ins_code>\n");
			if (pdbx_seq_align_beg_ins_code != null) ow.write(indent + " <PDBx:pdbx_seq_align_beg_ins_code>" + pdbx_seq_align_beg_ins_code + "</PDBx:pdbx_seq_align_beg_ins_code>\n");
			if (pdbx_seq_align_end_ins_code != null) ow.write(indent + " <PDBx:pdbx_seq_align_end_ins_code>" + pdbx_seq_align_end_ins_code + "</PDBx:pdbx_seq_align_end_ins_code>\n");
			if (pdbx_strand_id != null) ow.write(indent + " <PDBx:pdbx_strand_id>" + pdbx_strand_id + "</PDBx:pdbx_strand_id>\n");
			if (ref_id != null) ow.write(indent + " <PDBx:ref_id>" + ref_id + "</PDBx:ref_id>\n");
			if (seq_align_beg != null) ow.write(indent + " <PDBx:seq_align_beg>" + seq_align_beg + "</PDBx:seq_align_beg>\n");
			if (seq_align_end != null) ow.write(indent + " <PDBx:seq_align_end>" + seq_align_end + "</PDBx:seq_align_end>\n");
			ow.write(indent + "</PDBx:struct_ref_seq>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
