package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SHEET category record details about
 *  the beta-sheets.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  10--11--12--13--14--15--16--17--18--19--20  strand_a
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  30--31--32--33--34--35--36--37--38--39--40  strand_b
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  50--51--52--53--54--55--56--57--58--59--60  strand_c
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  70--71--72--73--74--75--76--77--78--79--80  strand_d
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  90--91--92--93--94--95--96--97--98--99-100  strand_e
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  110-111-112-113-114-115-116-117-118-119-120  strand_f
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  130-131-132-133-134-135-136-137-138-139-140  strand_g
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  150-151-152-153-154-155-156-157-158-159-160  strand_h
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  <PDBx:struct_sheetCategory>
 *  <PDBx:struct_sheet id="sheet_1">
 *  <PDBx:type>beta-barrel</PDBx:type>
 *  <PDBx:number_strands>8</PDBx:number_strands>
 *  </PDBx:struct_sheet>
 *  </PDBx:struct_sheetCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  
 *  N  O    N  O    N  O    N  O
 *  -10--11--12--13--14--15--16--17--18->  strand_a
 *  N  O    N  O    N  O    N  O    N  O
 *  |  |    |  |    |  |    |  |    |  |
 *  O  N    O  N    O  N    O  N    O  N
 *  <-119-118-117-116-115-114-113-112-111-110-  strand_b
 *  O  N    O  N    O  N    O  N    O  N
 *  \  /   \   /   \   /   \   /   \
 *  O  N    O  N    O  N    O  N    O  N    O  N
 *  <-41--40--39--38--37--36--35--34--33--32--31--30-  strand_c
 *  O  N    O  N    O  N    O  N    O  N    O  N
 *  |  |    |  |    |  |    |  |    |  |    |  |
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  strand_d1  -50--51--52->   -90--91--92--93--95--95--96--97->  strand_d2
 *  N  O            N  O    N  O    N  O    N  O
 *  |  |    |  |    |  |    |  |    |  |    |  |
 *  O  N    O  N    O  N    O  N    O  N    O  N
 *  <-80--79--78--77--76--75--74--73--72--71--70-   strand_e
 *  O  N    O  N    O  N    O  N    O  N
 *  <PDBx:struct_sheetCategory>
 *  <PDBx:struct_sheet id="sheet_2">
 *  <PDBx:type>five stranded, mixed-sense</PDBx:type>
 *  <PDBx:number_strands>5</PDBx:number_strands>
 *  <PDBx:details>strand_d is in two pieces</PDBx:details>
 *  </PDBx:struct_sheet>
 *  </PDBx:struct_sheetCategory>
 * </pre>
 */
public class Struct_sheet extends org.pdb.beans.Struct_sheet implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_sheet";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_sheet()
	{
	}

	/** Full constructor */
	public Struct_sheet(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_,
		java.lang.Integer number_strands,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
		this.number_strands = number_strands;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_sheet");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (number_strands != null)
		{
			sb.append("number_strands = ");
			sb.append(number_strands);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		number_strands = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_sheet)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_sheet>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (number_strands != null) ow.write(indent + " <PDBx:number_strands>" + number_strands + "</PDBx:number_strands>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:struct_sheet>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
