package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SHEET_HBOND category record details
 *  about the hydrogen bonding between residue ranges in a beta-
 *  sheet. It is necessary to treat hydrogen bonding independently
 *  of the designation of ranges, because the hydrogen bonding may
 *  begin in different places for the interactions of a given strand
 *  with the one preceding it and the one following it in the sheet.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  <PDBx:struct_sheet_hbondCategory>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:range_1_beg_label_seq_id>11</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>30</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>19</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>40</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:range_1_beg_label_seq_id>31</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>50</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>39</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>60</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_c" range_id_2="strand_d">
 *  <PDBx:range_1_beg_label_seq_id>51</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>70</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>59</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>80</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_d" range_id_2="strand_e">
 *  <PDBx:range_1_beg_label_seq_id>71</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>90</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>89</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>100</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_e" range_id_2="strand_f">
 *  <PDBx:range_1_beg_label_seq_id>91</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>110</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>99</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>120</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_f" range_id_2="strand_g">
 *  <PDBx:range_1_beg_label_seq_id>111</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>130</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>119</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>140</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_g" range_id_2="strand_h">
 *  <PDBx:range_1_beg_label_seq_id>131</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>150</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>139</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>160</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_h" range_id_2="strand_a">
 *  <PDBx:range_1_beg_label_seq_id>151</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>10</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>159</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>180</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  </PDBx:struct_sheet_hbondCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  <PDBx:struct_sheet_hbondCategory>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:range_1_beg_label_seq_id>20</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>119</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>18</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>111</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:range_1_beg_label_seq_id>110</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>33</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>118</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>N</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>41</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>O</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d1">
 *  <PDBx:range_1_beg_label_seq_id>38</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>52</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>40</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>50</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d2">
 *  <PDBx:range_1_beg_label_seq_id>30</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>96</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>36</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>90</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_d1" range_id_2="strand_e">
 *  <PDBx:range_1_beg_label_seq_id>51</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>80</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>51</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>80</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_d2" range_id_2="strand_e">
 *  <PDBx:range_1_beg_label_seq_id>91</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>76</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>97</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>70</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  </PDBx:struct_sheet_hbondCategory>
 * </pre>
 */
public class Struct_sheet_hbond extends org.pdb.beans.Struct_sheet_hbond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_sheet_hbond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_sheet_hbond()
	{
	}

	/** Full constructor */
	public Struct_sheet_hbond(
		Datablock datablock,
		java.lang.String pdbx_range_1_beg_PDB_ins_code,
		java.lang.String pdbx_range_1_beg_auth_asym_id,
		java.lang.String pdbx_range_1_beg_auth_comp_id,
		java.lang.String pdbx_range_1_beg_label_asym_id,
		java.lang.String pdbx_range_1_beg_label_comp_id,
		java.lang.String pdbx_range_1_end_PDB_ins_code,
		java.lang.String pdbx_range_1_end_auth_asym_id,
		java.lang.String pdbx_range_1_end_auth_comp_id,
		java.lang.String pdbx_range_1_end_label_asym_id,
		java.lang.String pdbx_range_1_end_label_comp_id,
		java.lang.String pdbx_range_2_beg_PDB_ins_code,
		java.lang.String pdbx_range_2_beg_label_asym_id,
		java.lang.String pdbx_range_2_beg_label_comp_id,
		java.lang.String pdbx_range_2_end_label_asym_id,
		java.lang.String pdbx_range_2_end_label_comp_id,
		java.lang.String pdbx_range_2_end_label_ins_code,
		java.lang.String range_1_beg_auth_atom_id,
		java.lang.String range_1_beg_auth_seq_id,
		java.lang.String range_1_beg_label_atom_id,
		java.lang.Integer range_1_beg_label_seq_id,
		java.lang.String range_1_end_auth_atom_id,
		java.lang.String range_1_end_auth_seq_id,
		java.lang.String range_1_end_label_atom_id,
		java.lang.Integer range_1_end_label_seq_id,
		java.lang.String range_2_beg_auth_atom_id,
		java.lang.String range_2_beg_auth_seq_id,
		java.lang.String range_2_beg_label_atom_id,
		java.lang.Integer range_2_beg_label_seq_id,
		java.lang.String range_2_end_auth_atom_id,
		java.lang.String range_2_end_auth_seq_id,
		java.lang.String range_2_end_label_atom_id,
		java.lang.Integer range_2_end_label_seq_id,
		java.lang.String range_id_1,
		java.lang.String range_id_2,
		java.lang.String sheet_id)
	{
		this.datablock = datablock;
		this.pdbx_range_1_beg_PDB_ins_code = pdbx_range_1_beg_PDB_ins_code;
		this.pdbx_range_1_beg_auth_asym_id = pdbx_range_1_beg_auth_asym_id;
		this.pdbx_range_1_beg_auth_comp_id = pdbx_range_1_beg_auth_comp_id;
		this.pdbx_range_1_beg_label_asym_id = pdbx_range_1_beg_label_asym_id;
		this.pdbx_range_1_beg_label_comp_id = pdbx_range_1_beg_label_comp_id;
		this.pdbx_range_1_end_PDB_ins_code = pdbx_range_1_end_PDB_ins_code;
		this.pdbx_range_1_end_auth_asym_id = pdbx_range_1_end_auth_asym_id;
		this.pdbx_range_1_end_auth_comp_id = pdbx_range_1_end_auth_comp_id;
		this.pdbx_range_1_end_label_asym_id = pdbx_range_1_end_label_asym_id;
		this.pdbx_range_1_end_label_comp_id = pdbx_range_1_end_label_comp_id;
		this.pdbx_range_2_beg_PDB_ins_code = pdbx_range_2_beg_PDB_ins_code;
		this.pdbx_range_2_beg_label_asym_id = pdbx_range_2_beg_label_asym_id;
		this.pdbx_range_2_beg_label_comp_id = pdbx_range_2_beg_label_comp_id;
		this.pdbx_range_2_end_label_asym_id = pdbx_range_2_end_label_asym_id;
		this.pdbx_range_2_end_label_comp_id = pdbx_range_2_end_label_comp_id;
		this.pdbx_range_2_end_label_ins_code = pdbx_range_2_end_label_ins_code;
		this.range_1_beg_auth_atom_id = range_1_beg_auth_atom_id;
		this.range_1_beg_auth_seq_id = range_1_beg_auth_seq_id;
		this.range_1_beg_label_atom_id = range_1_beg_label_atom_id;
		this.range_1_beg_label_seq_id = range_1_beg_label_seq_id;
		this.range_1_end_auth_atom_id = range_1_end_auth_atom_id;
		this.range_1_end_auth_seq_id = range_1_end_auth_seq_id;
		this.range_1_end_label_atom_id = range_1_end_label_atom_id;
		this.range_1_end_label_seq_id = range_1_end_label_seq_id;
		this.range_2_beg_auth_atom_id = range_2_beg_auth_atom_id;
		this.range_2_beg_auth_seq_id = range_2_beg_auth_seq_id;
		this.range_2_beg_label_atom_id = range_2_beg_label_atom_id;
		this.range_2_beg_label_seq_id = range_2_beg_label_seq_id;
		this.range_2_end_auth_atom_id = range_2_end_auth_atom_id;
		this.range_2_end_auth_seq_id = range_2_end_auth_seq_id;
		this.range_2_end_label_atom_id = range_2_end_label_atom_id;
		this.range_2_end_label_seq_id = range_2_end_label_seq_id;
		this.range_id_1 = range_id_1;
		this.range_id_2 = range_id_2;
		this.sheet_id = sheet_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_sheet_hbond");
		sb.append("\n");
		if (pdbx_range_1_beg_PDB_ins_code != null)
		{
			sb.append("pdbx_range_1_beg_PDB_ins_code = ");
			sb.append(pdbx_range_1_beg_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_range_1_beg_auth_asym_id != null)
		{
			sb.append("pdbx_range_1_beg_auth_asym_id = ");
			sb.append(pdbx_range_1_beg_auth_asym_id);
			sb.append('\n');
		}
		if (pdbx_range_1_beg_auth_comp_id != null)
		{
			sb.append("pdbx_range_1_beg_auth_comp_id = ");
			sb.append(pdbx_range_1_beg_auth_comp_id);
			sb.append('\n');
		}
		if (pdbx_range_1_beg_label_asym_id != null)
		{
			sb.append("pdbx_range_1_beg_label_asym_id = ");
			sb.append(pdbx_range_1_beg_label_asym_id);
			sb.append('\n');
		}
		if (pdbx_range_1_beg_label_comp_id != null)
		{
			sb.append("pdbx_range_1_beg_label_comp_id = ");
			sb.append(pdbx_range_1_beg_label_comp_id);
			sb.append('\n');
		}
		if (pdbx_range_1_end_PDB_ins_code != null)
		{
			sb.append("pdbx_range_1_end_PDB_ins_code = ");
			sb.append(pdbx_range_1_end_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_range_1_end_auth_asym_id != null)
		{
			sb.append("pdbx_range_1_end_auth_asym_id = ");
			sb.append(pdbx_range_1_end_auth_asym_id);
			sb.append('\n');
		}
		if (pdbx_range_1_end_auth_comp_id != null)
		{
			sb.append("pdbx_range_1_end_auth_comp_id = ");
			sb.append(pdbx_range_1_end_auth_comp_id);
			sb.append('\n');
		}
		if (pdbx_range_1_end_label_asym_id != null)
		{
			sb.append("pdbx_range_1_end_label_asym_id = ");
			sb.append(pdbx_range_1_end_label_asym_id);
			sb.append('\n');
		}
		if (pdbx_range_1_end_label_comp_id != null)
		{
			sb.append("pdbx_range_1_end_label_comp_id = ");
			sb.append(pdbx_range_1_end_label_comp_id);
			sb.append('\n');
		}
		if (pdbx_range_2_beg_PDB_ins_code != null)
		{
			sb.append("pdbx_range_2_beg_PDB_ins_code = ");
			sb.append(pdbx_range_2_beg_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_range_2_beg_label_asym_id != null)
		{
			sb.append("pdbx_range_2_beg_label_asym_id = ");
			sb.append(pdbx_range_2_beg_label_asym_id);
			sb.append('\n');
		}
		if (pdbx_range_2_beg_label_comp_id != null)
		{
			sb.append("pdbx_range_2_beg_label_comp_id = ");
			sb.append(pdbx_range_2_beg_label_comp_id);
			sb.append('\n');
		}
		if (pdbx_range_2_end_label_asym_id != null)
		{
			sb.append("pdbx_range_2_end_label_asym_id = ");
			sb.append(pdbx_range_2_end_label_asym_id);
			sb.append('\n');
		}
		if (pdbx_range_2_end_label_comp_id != null)
		{
			sb.append("pdbx_range_2_end_label_comp_id = ");
			sb.append(pdbx_range_2_end_label_comp_id);
			sb.append('\n');
		}
		if (pdbx_range_2_end_label_ins_code != null)
		{
			sb.append("pdbx_range_2_end_label_ins_code = ");
			sb.append(pdbx_range_2_end_label_ins_code);
			sb.append('\n');
		}
		if (range_1_beg_auth_atom_id != null)
		{
			sb.append("range_1_beg_auth_atom_id = ");
			sb.append(range_1_beg_auth_atom_id);
			sb.append('\n');
		}
		if (range_1_beg_auth_seq_id != null)
		{
			sb.append("range_1_beg_auth_seq_id = ");
			sb.append(range_1_beg_auth_seq_id);
			sb.append('\n');
		}
		if (range_1_beg_label_atom_id != null)
		{
			sb.append("range_1_beg_label_atom_id = ");
			sb.append(range_1_beg_label_atom_id);
			sb.append('\n');
		}
		if (range_1_beg_label_seq_id != null)
		{
			sb.append("range_1_beg_label_seq_id = ");
			sb.append(range_1_beg_label_seq_id);
			sb.append('\n');
		}
		if (range_1_end_auth_atom_id != null)
		{
			sb.append("range_1_end_auth_atom_id = ");
			sb.append(range_1_end_auth_atom_id);
			sb.append('\n');
		}
		if (range_1_end_auth_seq_id != null)
		{
			sb.append("range_1_end_auth_seq_id = ");
			sb.append(range_1_end_auth_seq_id);
			sb.append('\n');
		}
		if (range_1_end_label_atom_id != null)
		{
			sb.append("range_1_end_label_atom_id = ");
			sb.append(range_1_end_label_atom_id);
			sb.append('\n');
		}
		if (range_1_end_label_seq_id != null)
		{
			sb.append("range_1_end_label_seq_id = ");
			sb.append(range_1_end_label_seq_id);
			sb.append('\n');
		}
		if (range_2_beg_auth_atom_id != null)
		{
			sb.append("range_2_beg_auth_atom_id = ");
			sb.append(range_2_beg_auth_atom_id);
			sb.append('\n');
		}
		if (range_2_beg_auth_seq_id != null)
		{
			sb.append("range_2_beg_auth_seq_id = ");
			sb.append(range_2_beg_auth_seq_id);
			sb.append('\n');
		}
		if (range_2_beg_label_atom_id != null)
		{
			sb.append("range_2_beg_label_atom_id = ");
			sb.append(range_2_beg_label_atom_id);
			sb.append('\n');
		}
		if (range_2_beg_label_seq_id != null)
		{
			sb.append("range_2_beg_label_seq_id = ");
			sb.append(range_2_beg_label_seq_id);
			sb.append('\n');
		}
		if (range_2_end_auth_atom_id != null)
		{
			sb.append("range_2_end_auth_atom_id = ");
			sb.append(range_2_end_auth_atom_id);
			sb.append('\n');
		}
		if (range_2_end_auth_seq_id != null)
		{
			sb.append("range_2_end_auth_seq_id = ");
			sb.append(range_2_end_auth_seq_id);
			sb.append('\n');
		}
		if (range_2_end_label_atom_id != null)
		{
			sb.append("range_2_end_label_atom_id = ");
			sb.append(range_2_end_label_atom_id);
			sb.append('\n');
		}
		if (range_2_end_label_seq_id != null)
		{
			sb.append("range_2_end_label_seq_id = ");
			sb.append(range_2_end_label_seq_id);
			sb.append('\n');
		}
		if (range_id_1 != null)
		{
			sb.append("range_id_1 = ");
			sb.append(range_id_1);
			sb.append('\n');
		}
		if (range_id_2 != null)
		{
			sb.append("range_id_2 = ");
			sb.append(range_id_2);
			sb.append('\n');
		}
		if (sheet_id != null)
		{
			sb.append("sheet_id = ");
			sb.append(sheet_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		pdbx_range_1_beg_PDB_ins_code = null;
		pdbx_range_1_beg_auth_asym_id = null;
		pdbx_range_1_beg_auth_comp_id = null;
		pdbx_range_1_beg_label_asym_id = null;
		pdbx_range_1_beg_label_comp_id = null;
		pdbx_range_1_end_PDB_ins_code = null;
		pdbx_range_1_end_auth_asym_id = null;
		pdbx_range_1_end_auth_comp_id = null;
		pdbx_range_1_end_label_asym_id = null;
		pdbx_range_1_end_label_comp_id = null;
		pdbx_range_2_beg_PDB_ins_code = null;
		pdbx_range_2_beg_label_asym_id = null;
		pdbx_range_2_beg_label_comp_id = null;
		pdbx_range_2_end_label_asym_id = null;
		pdbx_range_2_end_label_comp_id = null;
		pdbx_range_2_end_label_ins_code = null;
		range_1_beg_auth_atom_id = null;
		range_1_beg_auth_seq_id = null;
		range_1_beg_label_atom_id = null;
		range_1_beg_label_seq_id = null;
		range_1_end_auth_atom_id = null;
		range_1_end_auth_seq_id = null;
		range_1_end_label_atom_id = null;
		range_1_end_label_seq_id = null;
		range_2_beg_auth_atom_id = null;
		range_2_beg_auth_seq_id = null;
		range_2_beg_label_atom_id = null;
		range_2_beg_label_seq_id = null;
		range_2_end_auth_atom_id = null;
		range_2_end_auth_seq_id = null;
		range_2_end_label_atom_id = null;
		range_2_end_label_seq_id = null;
		range_id_1 = null;
		range_id_2 = null;
		sheet_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_sheet_hbond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_sheet_hbond>\n");
			if (pdbx_range_1_beg_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_range_1_beg_PDB_ins_code>" + pdbx_range_1_beg_PDB_ins_code + "</PDBx:pdbx_range_1_beg_PDB_ins_code>\n");
			if (pdbx_range_1_beg_auth_asym_id != null) ow.write(indent + " <PDBx:pdbx_range_1_beg_auth_asym_id>" + pdbx_range_1_beg_auth_asym_id + "</PDBx:pdbx_range_1_beg_auth_asym_id>\n");
			if (pdbx_range_1_beg_auth_comp_id != null) ow.write(indent + " <PDBx:pdbx_range_1_beg_auth_comp_id>" + pdbx_range_1_beg_auth_comp_id + "</PDBx:pdbx_range_1_beg_auth_comp_id>\n");
			if (pdbx_range_1_beg_label_asym_id != null) ow.write(indent + " <PDBx:pdbx_range_1_beg_label_asym_id>" + pdbx_range_1_beg_label_asym_id + "</PDBx:pdbx_range_1_beg_label_asym_id>\n");
			if (pdbx_range_1_beg_label_comp_id != null) ow.write(indent + " <PDBx:pdbx_range_1_beg_label_comp_id>" + pdbx_range_1_beg_label_comp_id + "</PDBx:pdbx_range_1_beg_label_comp_id>\n");
			if (pdbx_range_1_end_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_range_1_end_PDB_ins_code>" + pdbx_range_1_end_PDB_ins_code + "</PDBx:pdbx_range_1_end_PDB_ins_code>\n");
			if (pdbx_range_1_end_auth_asym_id != null) ow.write(indent + " <PDBx:pdbx_range_1_end_auth_asym_id>" + pdbx_range_1_end_auth_asym_id + "</PDBx:pdbx_range_1_end_auth_asym_id>\n");
			if (pdbx_range_1_end_auth_comp_id != null) ow.write(indent + " <PDBx:pdbx_range_1_end_auth_comp_id>" + pdbx_range_1_end_auth_comp_id + "</PDBx:pdbx_range_1_end_auth_comp_id>\n");
			if (pdbx_range_1_end_label_asym_id != null) ow.write(indent + " <PDBx:pdbx_range_1_end_label_asym_id>" + pdbx_range_1_end_label_asym_id + "</PDBx:pdbx_range_1_end_label_asym_id>\n");
			if (pdbx_range_1_end_label_comp_id != null) ow.write(indent + " <PDBx:pdbx_range_1_end_label_comp_id>" + pdbx_range_1_end_label_comp_id + "</PDBx:pdbx_range_1_end_label_comp_id>\n");
			if (pdbx_range_2_beg_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_range_2_beg_PDB_ins_code>" + pdbx_range_2_beg_PDB_ins_code + "</PDBx:pdbx_range_2_beg_PDB_ins_code>\n");
			if (pdbx_range_2_beg_label_asym_id != null) ow.write(indent + " <PDBx:pdbx_range_2_beg_label_asym_id>" + pdbx_range_2_beg_label_asym_id + "</PDBx:pdbx_range_2_beg_label_asym_id>\n");
			if (pdbx_range_2_beg_label_comp_id != null) ow.write(indent + " <PDBx:pdbx_range_2_beg_label_comp_id>" + pdbx_range_2_beg_label_comp_id + "</PDBx:pdbx_range_2_beg_label_comp_id>\n");
			if (pdbx_range_2_end_label_asym_id != null) ow.write(indent + " <PDBx:pdbx_range_2_end_label_asym_id>" + pdbx_range_2_end_label_asym_id + "</PDBx:pdbx_range_2_end_label_asym_id>\n");
			if (pdbx_range_2_end_label_comp_id != null) ow.write(indent + " <PDBx:pdbx_range_2_end_label_comp_id>" + pdbx_range_2_end_label_comp_id + "</PDBx:pdbx_range_2_end_label_comp_id>\n");
			if (pdbx_range_2_end_label_ins_code != null) ow.write(indent + " <PDBx:pdbx_range_2_end_label_ins_code>" + pdbx_range_2_end_label_ins_code + "</PDBx:pdbx_range_2_end_label_ins_code>\n");
			if (range_1_beg_auth_atom_id != null) ow.write(indent + " <PDBx:range_1_beg_auth_atom_id>" + range_1_beg_auth_atom_id + "</PDBx:range_1_beg_auth_atom_id>\n");
			if (range_1_beg_auth_seq_id != null) ow.write(indent + " <PDBx:range_1_beg_auth_seq_id>" + range_1_beg_auth_seq_id + "</PDBx:range_1_beg_auth_seq_id>\n");
			if (range_1_beg_label_atom_id != null) ow.write(indent + " <PDBx:range_1_beg_label_atom_id>" + range_1_beg_label_atom_id + "</PDBx:range_1_beg_label_atom_id>\n");
			if (range_1_beg_label_seq_id != null) ow.write(indent + " <PDBx:range_1_beg_label_seq_id>" + range_1_beg_label_seq_id + "</PDBx:range_1_beg_label_seq_id>\n");
			if (range_1_end_auth_atom_id != null) ow.write(indent + " <PDBx:range_1_end_auth_atom_id>" + range_1_end_auth_atom_id + "</PDBx:range_1_end_auth_atom_id>\n");
			if (range_1_end_auth_seq_id != null) ow.write(indent + " <PDBx:range_1_end_auth_seq_id>" + range_1_end_auth_seq_id + "</PDBx:range_1_end_auth_seq_id>\n");
			if (range_1_end_label_atom_id != null) ow.write(indent + " <PDBx:range_1_end_label_atom_id>" + range_1_end_label_atom_id + "</PDBx:range_1_end_label_atom_id>\n");
			if (range_1_end_label_seq_id != null) ow.write(indent + " <PDBx:range_1_end_label_seq_id>" + range_1_end_label_seq_id + "</PDBx:range_1_end_label_seq_id>\n");
			if (range_2_beg_auth_atom_id != null) ow.write(indent + " <PDBx:range_2_beg_auth_atom_id>" + range_2_beg_auth_atom_id + "</PDBx:range_2_beg_auth_atom_id>\n");
			if (range_2_beg_auth_seq_id != null) ow.write(indent + " <PDBx:range_2_beg_auth_seq_id>" + range_2_beg_auth_seq_id + "</PDBx:range_2_beg_auth_seq_id>\n");
			if (range_2_beg_label_atom_id != null) ow.write(indent + " <PDBx:range_2_beg_label_atom_id>" + range_2_beg_label_atom_id + "</PDBx:range_2_beg_label_atom_id>\n");
			if (range_2_beg_label_seq_id != null) ow.write(indent + " <PDBx:range_2_beg_label_seq_id>" + range_2_beg_label_seq_id + "</PDBx:range_2_beg_label_seq_id>\n");
			if (range_2_end_auth_atom_id != null) ow.write(indent + " <PDBx:range_2_end_auth_atom_id>" + range_2_end_auth_atom_id + "</PDBx:range_2_end_auth_atom_id>\n");
			if (range_2_end_auth_seq_id != null) ow.write(indent + " <PDBx:range_2_end_auth_seq_id>" + range_2_end_auth_seq_id + "</PDBx:range_2_end_auth_seq_id>\n");
			if (range_2_end_label_atom_id != null) ow.write(indent + " <PDBx:range_2_end_label_atom_id>" + range_2_end_label_atom_id + "</PDBx:range_2_end_label_atom_id>\n");
			if (range_2_end_label_seq_id != null) ow.write(indent + " <PDBx:range_2_end_label_seq_id>" + range_2_end_label_seq_id + "</PDBx:range_2_end_label_seq_id>\n");
			if (range_id_1 != null) ow.write(indent + " <PDBx:range_id_1>" + range_id_1 + "</PDBx:range_id_1>\n");
			if (range_id_2 != null) ow.write(indent + " <PDBx:range_id_2>" + range_id_2 + "</PDBx:range_id_2>\n");
			if (sheet_id != null) ow.write(indent + " <PDBx:sheet_id>" + sheet_id + "</PDBx:sheet_id>\n");
			ow.write(indent + "</PDBx:struct_sheet_hbond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
