package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SHEET_RANGE category record details
 *  about the residue ranges that form a beta-sheet. Residues are
 *  included in a range if they made beta-sheet-type hydrogen-bonding
 *  interactions with at least one adjacent strand and if there are
 *  at least two residues in the range.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  <PDBx:struct_sheet_rangeCategory>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_a">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>20</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>30</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_b">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>40</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>50</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_c">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>60</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>70</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_d">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>80</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>90</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_e">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>100</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>110</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_f">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>120</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>130</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_g">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>140</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>150</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_h">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>160</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>170</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  </PDBx:struct_sheet_rangeCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  <PDBx:struct_sheet_rangeCategory>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_a">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>10</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>18</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_b">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>110</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>119</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_c">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>30</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>41</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_d1">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>50</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>52</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_d2">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>90</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>97</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_e">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>70</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>80</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  </PDBx:struct_sheet_rangeCategory>
 * </pre>
 */
public class Struct_sheet_range extends org.pdb.beans.Struct_sheet_range implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_sheet_range";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_sheet_range()
	{
	}

	/** Full constructor */
	public Struct_sheet_range(
		Datablock datablock,
		java.lang.String beg_auth_asym_id,
		java.lang.String beg_auth_comp_id,
		java.lang.String beg_auth_seq_id,
		java.lang.String beg_label_asym_id,
		java.lang.String beg_label_comp_id,
		java.lang.Integer beg_label_seq_id,
		java.lang.String end_auth_asym_id,
		java.lang.String end_auth_comp_id,
		java.lang.String end_auth_seq_id,
		java.lang.String end_label_asym_id,
		java.lang.String end_label_comp_id,
		java.lang.Integer end_label_seq_id,
		java.lang.String id_,
		java.lang.String pdbx_beg_PDB_ins_code,
		java.lang.String pdbx_end_PDB_ins_code,
		java.lang.String sheet_id,
		java.lang.String symmetry)
	{
		this.datablock = datablock;
		this.beg_auth_asym_id = beg_auth_asym_id;
		this.beg_auth_comp_id = beg_auth_comp_id;
		this.beg_auth_seq_id = beg_auth_seq_id;
		this.beg_label_asym_id = beg_label_asym_id;
		this.beg_label_comp_id = beg_label_comp_id;
		this.beg_label_seq_id = beg_label_seq_id;
		this.end_auth_asym_id = end_auth_asym_id;
		this.end_auth_comp_id = end_auth_comp_id;
		this.end_auth_seq_id = end_auth_seq_id;
		this.end_label_asym_id = end_label_asym_id;
		this.end_label_comp_id = end_label_comp_id;
		this.end_label_seq_id = end_label_seq_id;
		this.id_ = id_;
		this.pdbx_beg_PDB_ins_code = pdbx_beg_PDB_ins_code;
		this.pdbx_end_PDB_ins_code = pdbx_end_PDB_ins_code;
		this.sheet_id = sheet_id;
		this.symmetry = symmetry;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_sheet_range");
		sb.append("\n");
		if (beg_auth_asym_id != null)
		{
			sb.append("beg_auth_asym_id = ");
			sb.append(beg_auth_asym_id);
			sb.append('\n');
		}
		if (beg_auth_comp_id != null)
		{
			sb.append("beg_auth_comp_id = ");
			sb.append(beg_auth_comp_id);
			sb.append('\n');
		}
		if (beg_auth_seq_id != null)
		{
			sb.append("beg_auth_seq_id = ");
			sb.append(beg_auth_seq_id);
			sb.append('\n');
		}
		if (beg_label_asym_id != null)
		{
			sb.append("beg_label_asym_id = ");
			sb.append(beg_label_asym_id);
			sb.append('\n');
		}
		if (beg_label_comp_id != null)
		{
			sb.append("beg_label_comp_id = ");
			sb.append(beg_label_comp_id);
			sb.append('\n');
		}
		if (beg_label_seq_id != null)
		{
			sb.append("beg_label_seq_id = ");
			sb.append(beg_label_seq_id);
			sb.append('\n');
		}
		if (end_auth_asym_id != null)
		{
			sb.append("end_auth_asym_id = ");
			sb.append(end_auth_asym_id);
			sb.append('\n');
		}
		if (end_auth_comp_id != null)
		{
			sb.append("end_auth_comp_id = ");
			sb.append(end_auth_comp_id);
			sb.append('\n');
		}
		if (end_auth_seq_id != null)
		{
			sb.append("end_auth_seq_id = ");
			sb.append(end_auth_seq_id);
			sb.append('\n');
		}
		if (end_label_asym_id != null)
		{
			sb.append("end_label_asym_id = ");
			sb.append(end_label_asym_id);
			sb.append('\n');
		}
		if (end_label_comp_id != null)
		{
			sb.append("end_label_comp_id = ");
			sb.append(end_label_comp_id);
			sb.append('\n');
		}
		if (end_label_seq_id != null)
		{
			sb.append("end_label_seq_id = ");
			sb.append(end_label_seq_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_beg_PDB_ins_code != null)
		{
			sb.append("pdbx_beg_PDB_ins_code = ");
			sb.append(pdbx_beg_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_end_PDB_ins_code != null)
		{
			sb.append("pdbx_end_PDB_ins_code = ");
			sb.append(pdbx_end_PDB_ins_code);
			sb.append('\n');
		}
		if (sheet_id != null)
		{
			sb.append("sheet_id = ");
			sb.append(sheet_id);
			sb.append('\n');
		}
		if (symmetry != null)
		{
			sb.append("symmetry = ");
			sb.append(symmetry);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		beg_auth_asym_id = null;
		beg_auth_comp_id = null;
		beg_auth_seq_id = null;
		beg_label_asym_id = null;
		beg_label_comp_id = null;
		beg_label_seq_id = null;
		end_auth_asym_id = null;
		end_auth_comp_id = null;
		end_auth_seq_id = null;
		end_label_asym_id = null;
		end_label_comp_id = null;
		end_label_seq_id = null;
		id_ = null;
		pdbx_beg_PDB_ins_code = null;
		pdbx_end_PDB_ins_code = null;
		sheet_id = null;
		symmetry = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_sheet_range)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_sheet_range>\n");
			if (beg_auth_asym_id != null) ow.write(indent + " <PDBx:beg_auth_asym_id>" + beg_auth_asym_id + "</PDBx:beg_auth_asym_id>\n");
			if (beg_auth_comp_id != null) ow.write(indent + " <PDBx:beg_auth_comp_id>" + beg_auth_comp_id + "</PDBx:beg_auth_comp_id>\n");
			if (beg_auth_seq_id != null) ow.write(indent + " <PDBx:beg_auth_seq_id>" + beg_auth_seq_id + "</PDBx:beg_auth_seq_id>\n");
			if (beg_label_asym_id != null) ow.write(indent + " <PDBx:beg_label_asym_id>" + beg_label_asym_id + "</PDBx:beg_label_asym_id>\n");
			if (beg_label_comp_id != null) ow.write(indent + " <PDBx:beg_label_comp_id>" + beg_label_comp_id + "</PDBx:beg_label_comp_id>\n");
			if (beg_label_seq_id != null) ow.write(indent + " <PDBx:beg_label_seq_id>" + beg_label_seq_id + "</PDBx:beg_label_seq_id>\n");
			if (end_auth_asym_id != null) ow.write(indent + " <PDBx:end_auth_asym_id>" + end_auth_asym_id + "</PDBx:end_auth_asym_id>\n");
			if (end_auth_comp_id != null) ow.write(indent + " <PDBx:end_auth_comp_id>" + end_auth_comp_id + "</PDBx:end_auth_comp_id>\n");
			if (end_auth_seq_id != null) ow.write(indent + " <PDBx:end_auth_seq_id>" + end_auth_seq_id + "</PDBx:end_auth_seq_id>\n");
			if (end_label_asym_id != null) ow.write(indent + " <PDBx:end_label_asym_id>" + end_label_asym_id + "</PDBx:end_label_asym_id>\n");
			if (end_label_comp_id != null) ow.write(indent + " <PDBx:end_label_comp_id>" + end_label_comp_id + "</PDBx:end_label_comp_id>\n");
			if (end_label_seq_id != null) ow.write(indent + " <PDBx:end_label_seq_id>" + end_label_seq_id + "</PDBx:end_label_seq_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_beg_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_beg_PDB_ins_code>" + pdbx_beg_PDB_ins_code + "</PDBx:pdbx_beg_PDB_ins_code>\n");
			if (pdbx_end_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_end_PDB_ins_code>" + pdbx_end_PDB_ins_code + "</PDBx:pdbx_end_PDB_ins_code>\n");
			if (sheet_id != null) ow.write(indent + " <PDBx:sheet_id>" + sheet_id + "</PDBx:sheet_id>\n");
			if (symmetry != null) ow.write(indent + " <PDBx:symmetry>" + symmetry + "</PDBx:symmetry>\n");
			ow.write(indent + "</PDBx:struct_sheet_range>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
