package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SITE category record details about
 *  portions of the structure that contribute to structurally
 *  relevant sites (e.g. active sites, substrate-binding subsites,
 *  metal-coordination sites).
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_siteCategory>
 *  <PDBx:struct_site id="P2 site C">
 *  <PDBx:details> residues with a contact &lt; 3.7 \&#37;A to an atom in the P2
 *  moiety of the inhibitor in the conformation with
 *  _struct_asym.id = C</PDBx:details>
 *  </PDBx:struct_site>
 *  <PDBx:struct_site id="P2 site D">
 *  <PDBx:details> residues with a contact &lt; 3.7 \&#37;A to an atom in the P1
 *  moiety of the inhibitor in the conformation with
 *  _struct_asym.id = D)</PDBx:details>
 *  </PDBx:struct_site>
 *  </PDBx:struct_siteCategory>
 * </pre>
 */
public class Struct_site extends org.pdb.beans.Struct_site implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_site";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_site()
	{
	}

	/** Full constructor */
	public Struct_site(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_,
		java.lang.Integer pdbx_num_residues)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
		this.pdbx_num_residues = pdbx_num_residues;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_site");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_num_residues != null)
		{
			sb.append("pdbx_num_residues = ");
			sb.append(pdbx_num_residues);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		pdbx_num_residues = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_site)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_site>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_num_residues != null) ow.write(indent + " <PDBx:pdbx_num_residues>" + pdbx_num_residues + "</PDBx:pdbx_num_residues>\n");
			ow.write(indent + "</PDBx:struct_site>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
