package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SITE_GEN category record details about
 *  the generation of portions of the structure that contribute to
 *  structurally relevant sites.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_site_genCategory>
 *  <PDBx:struct_site_gen id="1" site_id="1">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>32</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="2" site_id="1">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>47</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="3" site_id="1">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>82</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="4" site_id="1">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>84</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="5" site_id="2">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>232</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="6" site_id="2">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>247</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="7" site_id="2">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>282</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="8" site_id="2">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>284</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  </PDBx:struct_site_genCategory>
 * </pre>
 */
public class Struct_site_gen extends org.pdb.beans.Struct_site_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_site_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_site_gen()
	{
	}

	/** Full constructor */
	public Struct_site_gen(
		Datablock datablock,
		java.lang.String auth_asym_id,
		java.lang.String auth_atom_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String label_alt_id,
		java.lang.String label_asym_id,
		java.lang.String label_atom_id,
		java.lang.String label_comp_id,
		java.lang.Integer label_seq_id,
		java.lang.String pdbx_auth_ins_code,
		java.lang.Integer pdbx_num_res,
		java.lang.String site_id,
		java.lang.String symmetry)
	{
		this.datablock = datablock;
		this.auth_asym_id = auth_asym_id;
		this.auth_atom_id = auth_atom_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.details = details;
		this.id_ = id_;
		this.label_alt_id = label_alt_id;
		this.label_asym_id = label_asym_id;
		this.label_atom_id = label_atom_id;
		this.label_comp_id = label_comp_id;
		this.label_seq_id = label_seq_id;
		this.pdbx_auth_ins_code = pdbx_auth_ins_code;
		this.pdbx_num_res = pdbx_num_res;
		this.site_id = site_id;
		this.symmetry = symmetry;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_site_gen");
		sb.append("\n");
		if (auth_asym_id != null)
		{
			sb.append("auth_asym_id = ");
			sb.append(auth_asym_id);
			sb.append('\n');
		}
		if (auth_atom_id != null)
		{
			sb.append("auth_atom_id = ");
			sb.append(auth_atom_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (label_alt_id != null)
		{
			sb.append("label_alt_id = ");
			sb.append(label_alt_id);
			sb.append('\n');
		}
		if (label_asym_id != null)
		{
			sb.append("label_asym_id = ");
			sb.append(label_asym_id);
			sb.append('\n');
		}
		if (label_atom_id != null)
		{
			sb.append("label_atom_id = ");
			sb.append(label_atom_id);
			sb.append('\n');
		}
		if (label_comp_id != null)
		{
			sb.append("label_comp_id = ");
			sb.append(label_comp_id);
			sb.append('\n');
		}
		if (label_seq_id != null)
		{
			sb.append("label_seq_id = ");
			sb.append(label_seq_id);
			sb.append('\n');
		}
		if (pdbx_auth_ins_code != null)
		{
			sb.append("pdbx_auth_ins_code = ");
			sb.append(pdbx_auth_ins_code);
			sb.append('\n');
		}
		if (pdbx_num_res != null)
		{
			sb.append("pdbx_num_res = ");
			sb.append(pdbx_num_res);
			sb.append('\n');
		}
		if (site_id != null)
		{
			sb.append("site_id = ");
			sb.append(site_id);
			sb.append('\n');
		}
		if (symmetry != null)
		{
			sb.append("symmetry = ");
			sb.append(symmetry);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		auth_asym_id = null;
		auth_atom_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		details = null;
		id_ = null;
		label_alt_id = null;
		label_asym_id = null;
		label_atom_id = null;
		label_comp_id = null;
		label_seq_id = null;
		pdbx_auth_ins_code = null;
		pdbx_num_res = null;
		site_id = null;
		symmetry = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_site_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_site_gen>\n");
			if (auth_asym_id != null) ow.write(indent + " <PDBx:auth_asym_id>" + auth_asym_id + "</PDBx:auth_asym_id>\n");
			if (auth_atom_id != null) ow.write(indent + " <PDBx:auth_atom_id>" + auth_atom_id + "</PDBx:auth_atom_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (label_alt_id != null) ow.write(indent + " <PDBx:label_alt_id>" + label_alt_id + "</PDBx:label_alt_id>\n");
			if (label_asym_id != null) ow.write(indent + " <PDBx:label_asym_id>" + label_asym_id + "</PDBx:label_asym_id>\n");
			if (label_atom_id != null) ow.write(indent + " <PDBx:label_atom_id>" + label_atom_id + "</PDBx:label_atom_id>\n");
			if (label_comp_id != null) ow.write(indent + " <PDBx:label_comp_id>" + label_comp_id + "</PDBx:label_comp_id>\n");
			if (label_seq_id != null) ow.write(indent + " <PDBx:label_seq_id>" + label_seq_id + "</PDBx:label_seq_id>\n");
			if (pdbx_auth_ins_code != null) ow.write(indent + " <PDBx:pdbx_auth_ins_code>" + pdbx_auth_ins_code + "</PDBx:pdbx_auth_ins_code>\n");
			if (pdbx_num_res != null) ow.write(indent + " <PDBx:pdbx_num_res>" + pdbx_num_res + "</PDBx:pdbx_num_res>\n");
			if (site_id != null) ow.write(indent + " <PDBx:site_id>" + site_id + "</PDBx:site_id>\n");
			if (symmetry != null) ow.write(indent + " <PDBx:symmetry>" + symmetry + "</PDBx:symmetry>\n");
			ow.write(indent + "</PDBx:struct_site_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
