package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the VALENCE_PARAM category define the
 *  parameters used for calculating bond valences from bond
 *  lengths.  In addition to the parameters, a pointer
 *  is given to the reference (in VALENCE_REF) from which
 *  the bond-valence parameters were taken.
 *  
 * <pre>
 *  Example 1 - a bond-valence parameter list with accompanying references.
 *  <PDBx:valence_paramCategory>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="O" atom_2_valence="-2">
 *  <PDBx:Ro>1.679</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>a</PDBx:ref_id>
 *  </PDBx:valence_param>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="O" atom_2_valence="-2">
 *  <PDBx:Ro>1.649</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>j</PDBx:ref_id>
 *  </PDBx:valence_param>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="N" atom_2_valence="-3">
 *  <PDBx:Ro>1.64</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>m</PDBx:ref_id>
 *  <PDBx:details>2-coordinate N</PDBx:details>
 *  </PDBx:valence_param>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="N" atom_2_valence="-3">
 *  <PDBx:Ro>1.76</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>m</PDBx:ref_id>
 *  <PDBx:details>3-coordinate N</PDBx:details>
 *  </PDBx:valence_param>
 *  </PDBx:valence_paramCategory>
 *  <PDBx:valence_refCategory>
 *  <PDBx:valence_ref id="a">
 *  <PDBx:reference>Brown &amp; Altermatt (1985), Acta Cryst. B41, 244-247</PDBx:reference>
 *  </PDBx:valence_ref>
 *  <PDBx:valence_ref id="j">
 *  <PDBx:reference>Liu &amp; Thorp (1993), Inorg. Chem. 32, 4102-4205</PDBx:reference>
 *  </PDBx:valence_ref>
 *  <PDBx:valence_ref id="m">
 *  <PDBx:reference>See, Krause &amp; Strub (1998), Inorg. Chem. 37, 5369-5375</PDBx:reference>
 *  </PDBx:valence_ref>
 *  </PDBx:valence_refCategory>
 * </pre>
 */
public class Valence_param extends org.pdb.beans.Valence_param implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "valence_param";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Valence_param()
	{
	}

	/** Full constructor */
	public Valence_param(
		Datablock datablock,
		java.lang.Float B,
		java.lang.Float Ro,
		java.lang.String atom_1,
		java.lang.Integer atom_1_valence,
		java.lang.String atom_2,
		java.lang.Integer atom_2_valence,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String ref_id)
	{
		this.datablock = datablock;
		this.B = B;
		this.Ro = Ro;
		this.atom_1 = atom_1;
		this.atom_1_valence = atom_1_valence;
		this.atom_2 = atom_2;
		this.atom_2_valence = atom_2_valence;
		this.details = details;
		this.id_ = id_;
		this.ref_id = ref_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Valence_param");
		sb.append("\n");
		if (B != null)
		{
			sb.append("B = ");
			sb.append(B);
			sb.append('\n');
		}
		if (Ro != null)
		{
			sb.append("Ro = ");
			sb.append(Ro);
			sb.append('\n');
		}
		if (atom_1 != null)
		{
			sb.append("atom_1 = ");
			sb.append(atom_1);
			sb.append('\n');
		}
		if (atom_1_valence != null)
		{
			sb.append("atom_1_valence = ");
			sb.append(atom_1_valence);
			sb.append('\n');
		}
		if (atom_2 != null)
		{
			sb.append("atom_2 = ");
			sb.append(atom_2);
			sb.append('\n');
		}
		if (atom_2_valence != null)
		{
			sb.append("atom_2_valence = ");
			sb.append(atom_2_valence);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (ref_id != null)
		{
			sb.append("ref_id = ");
			sb.append(ref_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		B = null;
		Ro = null;
		atom_1 = null;
		atom_1_valence = null;
		atom_2 = null;
		atom_2_valence = null;
		details = null;
		id_ = null;
		ref_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Valence_param)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:valence_param>\n");
			if (B != null) ow.write(indent + " <PDBx:B>" + B + "</PDBx:B>\n");
			if (Ro != null) ow.write(indent + " <PDBx:Ro>" + Ro + "</PDBx:Ro>\n");
			if (atom_1 != null) ow.write(indent + " <PDBx:atom_1>" + atom_1 + "</PDBx:atom_1>\n");
			if (atom_1_valence != null) ow.write(indent + " <PDBx:atom_1_valence>" + atom_1_valence + "</PDBx:atom_1_valence>\n");
			if (atom_2 != null) ow.write(indent + " <PDBx:atom_2>" + atom_2 + "</PDBx:atom_2>\n");
			if (atom_2_valence != null) ow.write(indent + " <PDBx:atom_2_valence>" + atom_2_valence + "</PDBx:atom_2_valence>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (ref_id != null) ow.write(indent + " <PDBx:ref_id>" + ref_id + "</PDBx:ref_id>\n");
			ow.write(indent + "</PDBx:valence_param>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
