package org.pdb.ormapping.handlers;

public class CellHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Cell myBean = new org.pdb.ormapping.Cell();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("Z_PDB".equalsIgnoreCase(fieldName))
		{
			myBean.setZ_PDB( new java.lang.Integer(fieldValue) );
		}
		else if ("angle_alpha".equalsIgnoreCase(fieldName))
		{
			myBean.setAngle_alpha( new java.lang.Float(fieldValue) );
		}
		else if ("angle_alpha_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setAngle_alpha_esd( new java.lang.Float(fieldValue) );
		}
		else if ("angle_beta".equalsIgnoreCase(fieldName))
		{
			myBean.setAngle_beta( new java.lang.Float(fieldValue) );
		}
		else if ("angle_beta_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setAngle_beta_esd( new java.lang.Float(fieldValue) );
		}
		else if ("angle_gamma".equalsIgnoreCase(fieldName))
		{
			myBean.setAngle_gamma( new java.lang.Float(fieldValue) );
		}
		else if ("angle_gamma_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setAngle_gamma_esd( new java.lang.Float(fieldValue) );
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetails(fieldValue);
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("formula_units_Z".equalsIgnoreCase(fieldName))
		{
			myBean.setFormula_units_Z( new java.lang.Integer(fieldValue) );
		}
		else if ("length_a".equalsIgnoreCase(fieldName))
		{
			myBean.setLength_a( new java.lang.Float(fieldValue) );
		}
		else if ("length_a_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setLength_a_esd( new java.lang.Float(fieldValue) );
		}
		else if ("length_b".equalsIgnoreCase(fieldName))
		{
			myBean.setLength_b( new java.lang.Float(fieldValue) );
		}
		else if ("length_b_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setLength_b_esd( new java.lang.Float(fieldValue) );
		}
		else if ("length_c".equalsIgnoreCase(fieldName))
		{
			myBean.setLength_c( new java.lang.Float(fieldValue) );
		}
		else if ("length_c_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setLength_c_esd( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_unique_axis".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setPdbx_unique_axis(fieldValue);
		}
		else if ("reciprocal_angle_alpha".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_angle_alpha( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_angle_alpha_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_angle_alpha_esd( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_angle_beta".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_angle_beta( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_angle_beta_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_angle_beta_esd( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_angle_gamma".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_angle_gamma( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_angle_gamma_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_angle_gamma_esd( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_length_a".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_length_a( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_length_a_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_length_a_esd( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_length_b".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_length_b( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_length_b_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_length_b_esd( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_length_c".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_length_c( new java.lang.Float(fieldValue) );
		}
		else if ("reciprocal_length_c_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setReciprocal_length_c_esd( new java.lang.Float(fieldValue) );
		}
		else if ("volume".equalsIgnoreCase(fieldName))
		{
			myBean.setVolume( new java.lang.Float(fieldValue) );
		}
		else if ("volume_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setVolume_esd( new java.lang.Float(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
