package org.pdb.ormapping.handlers;

public class Cell_measurementHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Cell_measurement myBean = new org.pdb.ormapping.Cell_measurement();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("pressure".equalsIgnoreCase(fieldName))
		{
			myBean.setPressure( new java.lang.Float(fieldValue) );
		}
		else if ("pressure_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setPressure_esd( new java.lang.Float(fieldValue) );
		}
		else if ("radiation".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setRadiation(fieldValue);
		}
		else if ("reflns_used".equalsIgnoreCase(fieldName))
		{
			myBean.setReflns_used( new java.lang.Integer(fieldValue) );
		}
		else if ("temp".equalsIgnoreCase(fieldName))
		{
			myBean.setTemp( new java.lang.Float(fieldValue) );
		}
		else if ("temp_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setTemp_esd( new java.lang.Float(fieldValue) );
		}
		else if ("theta_max".equalsIgnoreCase(fieldName))
		{
			myBean.setTheta_max( new java.lang.Float(fieldValue) );
		}
		else if ("theta_min".equalsIgnoreCase(fieldName))
		{
			myBean.setTheta_min( new java.lang.Float(fieldValue) );
		}
		else if ("wavelength".equalsIgnoreCase(fieldName))
		{
			myBean.setWavelength( new java.lang.Float(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
