package org.pdb.ormapping.handlers;

public class Chem_comp_chirHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Chem_comp_chir myBean = new org.pdb.ormapping.Chem_comp_chir();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("atom_config".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAtom_config(fieldValue);
		}
		else if ("atom_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAtom_id(fieldValue);
		}
		else if ("comp_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setComp_id(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setId_(fieldValue);
		}
		else if ("number_atoms_all".equalsIgnoreCase(fieldName))
		{
			myBean.setNumber_atoms_all( new java.lang.Integer(fieldValue) );
		}
		else if ("number_atoms_nh".equalsIgnoreCase(fieldName))
		{
			myBean.setNumber_atoms_nh( new java.lang.Integer(fieldValue) );
		}
		else if ("volume_flag".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setVolume_flag(fieldValue);
		}
		else if ("volume_three".equalsIgnoreCase(fieldName))
		{
			myBean.setVolume_three( new java.lang.Float(fieldValue) );
		}
		else if ("volume_three_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setVolume_three_esd( new java.lang.Float(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
