package org.pdb.ormapping.handlers;

public class ChemicalHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Chemical myBean = new org.pdb.ormapping.Chemical();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("absolute_configuration".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAbsolute_configuration(fieldValue);
		}
		else if ("compound_source".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCompound_source(fieldValue);
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("melting_point".equalsIgnoreCase(fieldName))
		{
			myBean.setMelting_point( new java.lang.Float(fieldValue) );
		}
		else if ("melting_point_gt".equalsIgnoreCase(fieldName))
		{
			myBean.setMelting_point_gt( new java.lang.Float(fieldValue) );
		}
		else if ("melting_point_lt".equalsIgnoreCase(fieldName))
		{
			myBean.setMelting_point_lt( new java.lang.Float(fieldValue) );
		}
		else if ("name_common".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setName_common(fieldValue);
		}
		else if ("name_mineral".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setName_mineral(fieldValue);
		}
		else if ("name_structure_type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setName_structure_type(fieldValue);
		}
		else if ("name_systematic".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setName_systematic(fieldValue);
		}
		else if ("optical_rotation".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setOptical_rotation(fieldValue);
		}
		else if ("properties_biological".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setProperties_biological(fieldValue);
		}
		else if ("properties_physical".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setProperties_physical(fieldValue);
		}
		else if ("temperature_decomposition".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_decomposition( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_decomposition_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_decomposition_esd( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_decomposition_gt".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_decomposition_gt( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_decomposition_lt".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_decomposition_lt( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_sublimation".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_sublimation( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_sublimation_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_sublimation_esd( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_sublimation_gt".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_sublimation_gt( new java.lang.Float(fieldValue) );
		}
		else if ("temperature_sublimation_lt".equalsIgnoreCase(fieldName))
		{
			myBean.setTemperature_sublimation_lt( new java.lang.Float(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
