package org.pdb.ormapping.handlers;

public class CitationHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Citation myBean = new org.pdb.ormapping.Citation();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("abstract".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAbstract_(fieldValue);
		}
		else if ("abstract_id_CAS".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAbstract_id_CAS(fieldValue);
		}
		else if ("book_id_ISBN".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setBook_id_ISBN(fieldValue);
		}
		else if ("book_publisher".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setBook_publisher(fieldValue);
		}
		else if ("book_publisher_city".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setBook_publisher_city(fieldValue);
		}
		else if ("book_title".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setBook_title(fieldValue);
		}
		else if ("coordinate_linkage".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCoordinate_linkage(fieldValue);
		}
		else if ("country".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setCountry(fieldValue);
		}
		else if ("database_id_CSD".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDatabase_id_CSD(fieldValue);
		}
		else if ("database_id_Medline".equalsIgnoreCase(fieldName))
		{
			myBean.setDatabase_id_Medline( new java.lang.Integer(fieldValue) );
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetails(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setId_(fieldValue);
		}
		else if ("journal_abbrev".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 500)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,500);
			}
			myBean.setJournal_abbrev(fieldValue);
		}
		else if ("journal_full".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setJournal_full(fieldValue);
		}
		else if ("journal_id_ASTM".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setJournal_id_ASTM(fieldValue);
		}
		else if ("journal_id_CSD".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setJournal_id_CSD(fieldValue);
		}
		else if ("journal_id_ISSN".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setJournal_id_ISSN(fieldValue);
		}
		else if ("journal_issue".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setJournal_issue(fieldValue);
		}
		else if ("journal_volume".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setJournal_volume(fieldValue);
		}
		else if ("language".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setLanguage(fieldValue);
		}
		else if ("page_first".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPage_first(fieldValue);
		}
		else if ("page_last".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPage_last(fieldValue);
		}
		else if ("pdbx_database_id_DOI".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_database_id_DOI(fieldValue);
		}
		else if ("pdbx_database_id_PubMed".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_database_id_PubMed( new java.lang.Integer(fieldValue) );
		}
		else if ("title".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 2000)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,2000);
			}
			myBean.setTitle(fieldValue);
		}
		else if ("unpublished_flag".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setUnpublished_flag(fieldValue);
		}
		else if ("year".equalsIgnoreCase(fieldName))
		{
			myBean.setYear( new java.lang.Integer(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
