package org.pdb.ormapping.handlers;

public class DiffrnHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Diffrn myBean = new org.pdb.ormapping.Diffrn();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("ambient_environment".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAmbient_environment(fieldValue);
		}
		else if ("ambient_pressure".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_pressure( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_pressure_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_pressure_esd( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_pressure_gt".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_pressure_gt( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_pressure_lt".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_pressure_lt( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_temp".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_temp( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_temp_details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setAmbient_temp_details(fieldValue);
		}
		else if ("ambient_temp_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_temp_esd( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_temp_gt".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_temp_gt( new java.lang.Float(fieldValue) );
		}
		else if ("ambient_temp_lt".equalsIgnoreCase(fieldName))
		{
			myBean.setAmbient_temp_lt( new java.lang.Float(fieldValue) );
		}
		else if ("crystal_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setCrystal_id(fieldValue);
		}
		else if ("crystal_support".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCrystal_support(fieldValue);
		}
		else if ("crystal_treatment".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCrystal_treatment(fieldValue);
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetails(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setId_(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
