package org.pdb.ormapping.handlers;

public class Diffrn_radiationHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Diffrn_radiation myBean = new org.pdb.ormapping.Diffrn_radiation();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("collimation".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCollimation(fieldValue);
		}
		else if ("diffrn_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setDiffrn_id(fieldValue);
		}
		else if ("filter_edge".equalsIgnoreCase(fieldName))
		{
			myBean.setFilter_edge( new java.lang.Float(fieldValue) );
		}
		else if ("inhomogeneity".equalsIgnoreCase(fieldName))
		{
			myBean.setInhomogeneity( new java.lang.Float(fieldValue) );
		}
		else if ("monochromator".equalsIgnoreCase(fieldName))
		{
			myBean.setMonochromator(fieldValue);
		}
		else if ("pdbx_analyzer".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_analyzer(fieldValue);
		}
		else if ("pdbx_diffrn_protocol".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 500)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,500);
			}
			myBean.setPdbx_diffrn_protocol(fieldValue);
		}
		else if ("pdbx_monochromatic_or_laue_m_l".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setPdbx_monochromatic_or_laue_m_l(fieldValue);
		}
		else if ("pdbx_wavelength".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_wavelength(fieldValue);
		}
		else if ("pdbx_wavelength_list".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_wavelength_list(fieldValue);
		}
		else if ("polarisn_norm".equalsIgnoreCase(fieldName))
		{
			myBean.setPolarisn_norm( new java.lang.Float(fieldValue) );
		}
		else if ("polarisn_ratio".equalsIgnoreCase(fieldName))
		{
			myBean.setPolarisn_ratio( new java.lang.Float(fieldValue) );
		}
		else if ("probe".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setProbe(fieldValue);
		}
		else if ("type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setType(fieldValue);
		}
		else if ("wavelength_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setWavelength_id(fieldValue);
		}
		else if ("xray_symbol".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setXray_symbol(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
