package org.pdb.ormapping.handlers;

public class Diffrn_sourceHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Diffrn_source myBean = new org.pdb.ormapping.Diffrn_source();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("current".equalsIgnoreCase(fieldName))
		{
			myBean.setCurrent( new java.lang.Float(fieldValue) );
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetails(fieldValue);
		}
		else if ("diffrn_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setDiffrn_id(fieldValue);
		}
		else if ("pdbx_synchrotron_beamline".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPdbx_synchrotron_beamline(fieldValue);
		}
		else if ("pdbx_synchrotron_site".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_synchrotron_site(fieldValue);
		}
		else if ("pdbx_wavelength".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPdbx_wavelength(fieldValue);
		}
		else if ("pdbx_wavelength_list".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPdbx_wavelength_list(fieldValue);
		}
		else if ("power".equalsIgnoreCase(fieldName))
		{
			myBean.setPower( new java.lang.Float(fieldValue) );
		}
		else if ("size".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setSize(fieldValue);
		}
		else if ("source".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setSource(fieldValue);
		}
		else if ("take-off_angle".equalsIgnoreCase(fieldName))
		{
			myBean.setTake_off_angle( new java.lang.Float(fieldValue) );
		}
		else if ("target".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setTarget(fieldValue);
		}
		else if ("type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setType(fieldValue);
		}
		else if ("voltage".equalsIgnoreCase(fieldName))
		{
			myBean.setVoltage( new java.lang.Float(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
