package org.pdb.ormapping.handlers;

public class Em_2d_crystal_growHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Em_2d_crystal_grow myBean = new org.pdb.ormapping.Em_2d_crystal_grow();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("apparatus".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setApparatus(fieldValue);
		}
		else if ("atmosphere".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAtmosphere(fieldValue);
		}
		else if ("buffer_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setBuffer_id(fieldValue);
		}
		else if ("citation_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCitation_id(fieldValue);
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			myBean.setDetails(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setId_(fieldValue);
		}
		else if ("mean_2d_crystal_size".equalsIgnoreCase(fieldName))
		{
			myBean.setMean_2d_crystal_size( new java.lang.Float(fieldValue) );
		}
		else if ("method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setMethod(fieldValue);
		}
		else if ("number_2d_crystals".equalsIgnoreCase(fieldName))
		{
			myBean.setNumber_2d_crystals( new java.lang.Integer(fieldValue) );
		}
		else if ("pH".equalsIgnoreCase(fieldName))
		{
			myBean.setPH( new java.lang.Float(fieldValue) );
		}
		else if ("temp".equalsIgnoreCase(fieldName))
		{
			myBean.setTemp( new java.lang.Float(fieldValue) );
		}
		else if ("time".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setTime(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
