package org.pdb.ormapping.handlers;

public class Em_assemblyHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Em_assembly myBean = new org.pdb.ormapping.Em_assembly();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("aggregation_state".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAggregation_state(fieldValue);
		}
		else if ("composition".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setComposition(fieldValue);
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			myBean.setDetails(fieldValue);
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setId_(fieldValue);
		}
		else if ("mol_wt_exp".equalsIgnoreCase(fieldName))
		{
			myBean.setMol_wt_exp( new java.lang.Float(fieldValue) );
		}
		else if ("mol_wt_method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setMol_wt_method(fieldValue);
		}
		else if ("mol_wt_theo".equalsIgnoreCase(fieldName))
		{
			myBean.setMol_wt_theo( new java.lang.Float(fieldValue) );
		}
		else if ("name".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setName(fieldValue);
		}
		else if ("num_components".equalsIgnoreCase(fieldName))
		{
			myBean.setNum_components( new java.lang.Integer(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
