package org.pdb.ormapping.handlers;

public class EntityHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Entity myBean = new org.pdb.ormapping.Entity();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("details".equalsIgnoreCase(fieldName))
		{
			myBean.setDetails(fieldValue);
		}
		else if ("formula_weight".equalsIgnoreCase(fieldName))
		{
			myBean.setFormula_weight( new java.lang.Float(fieldValue) );
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setId_(fieldValue);
		}
		else if ("pdbx_description".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_description(fieldValue);
		}
		else if ("pdbx_ec".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 250)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,250);
			}
			myBean.setPdbx_ec(fieldValue);
		}
		else if ("pdbx_formula_weight_exptl".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_formula_weight_exptl( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_formula_weight_exptl_method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_formula_weight_exptl_method(fieldValue);
		}
		else if ("pdbx_fragment".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_fragment(fieldValue);
		}
		else if ("pdbx_modification".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_modification(fieldValue);
		}
		else if ("pdbx_mutation".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_mutation(fieldValue);
		}
		else if ("pdbx_number_of_molecules".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_number_of_molecules( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_parent_entity_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_parent_entity_id(fieldValue);
		}
		else if ("pdbx_target_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_target_id(fieldValue);
		}
		else if ("src_method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setSrc_method(fieldValue);
		}
		else if ("type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 20)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,20);
			}
			myBean.setType(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
