package org.pdb.ormapping.handlers;

public class Exptl_crystal_growHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Exptl_crystal_grow myBean = new org.pdb.ormapping.Exptl_crystal_grow();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("apparatus".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setApparatus(fieldValue);
		}
		else if ("atmosphere".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAtmosphere(fieldValue);
		}
		else if ("crystal_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setCrystal_id(fieldValue);
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetails(fieldValue);
		}
		else if ("method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setMethod(fieldValue);
		}
		else if ("method_ref".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setMethod_ref(fieldValue);
		}
		else if ("pH".equalsIgnoreCase(fieldName))
		{
			myBean.setPH( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_details".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_details(fieldValue);
		}
		else if ("pdbx_pH_range".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPdbx_pH_range(fieldValue);
		}
		else if ("pressure".equalsIgnoreCase(fieldName))
		{
			myBean.setPressure( new java.lang.Float(fieldValue) );
		}
		else if ("pressure_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setPressure_esd( new java.lang.Float(fieldValue) );
		}
		else if ("seeding".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setSeeding(fieldValue);
		}
		else if ("seeding_ref".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setSeeding_ref(fieldValue);
		}
		else if ("temp".equalsIgnoreCase(fieldName))
		{
			myBean.setTemp( new java.lang.Float(fieldValue) );
		}
		else if ("temp_details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setTemp_details(fieldValue);
		}
		else if ("temp_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setTemp_esd( new java.lang.Float(fieldValue) );
		}
		else if ("time".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setTime(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
