package org.pdb.ormapping.handlers;

public class Pdbx_nmr_ensemble_rmsHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Pdbx_nmr_ensemble_rms myBean = new org.pdb.ormapping.Pdbx_nmr_ensemble_rms();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("atom_type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setAtom_type(fieldValue);
		}
		else if ("bond_angle_rms_dev".equalsIgnoreCase(fieldName))
		{
			myBean.setBond_angle_rms_dev( new java.lang.Float(fieldValue) );
		}
		else if ("bond_angle_rms_dev_error".equalsIgnoreCase(fieldName))
		{
			myBean.setBond_angle_rms_dev_error( new java.lang.Float(fieldValue) );
		}
		else if ("chain_range_begin".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setChain_range_begin(fieldValue);
		}
		else if ("chain_range_end".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setChain_range_end(fieldValue);
		}
		else if ("coord_average_rmsd_method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setCoord_average_rmsd_method(fieldValue);
		}
		else if ("covalent_bond_rms_dev".equalsIgnoreCase(fieldName))
		{
			myBean.setCovalent_bond_rms_dev( new java.lang.Float(fieldValue) );
		}
		else if ("covalent_bond_rms_dev_error".equalsIgnoreCase(fieldName))
		{
			myBean.setCovalent_bond_rms_dev_error( new java.lang.Float(fieldValue) );
		}
		else if ("dihedral_angles_rms_dev".equalsIgnoreCase(fieldName))
		{
			myBean.setDihedral_angles_rms_dev( new java.lang.Float(fieldValue) );
		}
		else if ("dihedral_angles_rms_dev_error".equalsIgnoreCase(fieldName))
		{
			myBean.setDihedral_angles_rms_dev_error( new java.lang.Float(fieldValue) );
		}
		else if ("distance_rms_dev".equalsIgnoreCase(fieldName))
		{
			myBean.setDistance_rms_dev( new java.lang.Float(fieldValue) );
		}
		else if ("distance_rms_dev_error".equalsIgnoreCase(fieldName))
		{
			myBean.setDistance_rms_dev_error( new java.lang.Float(fieldValue) );
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("improper_torsion_angle_rms_dev".equalsIgnoreCase(fieldName))
		{
			myBean.setImproper_torsion_angle_rms_dev( new java.lang.Float(fieldValue) );
		}
		else if ("improper_torsion_angle_rms_dev_error".equalsIgnoreCase(fieldName))
		{
			myBean.setImproper_torsion_angle_rms_dev_error( new java.lang.Float(fieldValue) );
		}
		else if ("peptide_planarity_rms_dev".equalsIgnoreCase(fieldName))
		{
			myBean.setPeptide_planarity_rms_dev( new java.lang.Float(fieldValue) );
		}
		else if ("peptide_planarity_rms_dev_error".equalsIgnoreCase(fieldName))
		{
			myBean.setPeptide_planarity_rms_dev_error( new java.lang.Float(fieldValue) );
		}
		else if ("residue_range_begin".equalsIgnoreCase(fieldName))
		{
			myBean.setResidue_range_begin( new java.lang.Integer(fieldValue) );
		}
		else if ("residue_range_end".equalsIgnoreCase(fieldName))
		{
			myBean.setResidue_range_end( new java.lang.Integer(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
