package org.pdb.ormapping.handlers;

public class Pdbx_versionHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Pdbx_version myBean = new org.pdb.ormapping.Pdbx_version();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetails(fieldValue);
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("major_version".equalsIgnoreCase(fieldName))
		{
			myBean.setMajor_version( new java.lang.Integer(fieldValue) );
		}
		else if ("minor_version".equalsIgnoreCase(fieldName))
		{
			myBean.setMinor_version( new java.lang.Integer(fieldValue) );
		}
		else if ("revision_date".equalsIgnoreCase(fieldName))
		{
			myBean.setRevision_date(org.pdb.ormapping.util.Utils.getCalendar(fieldValue).getTime());
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
