package org.pdb.ormapping.handlers;

public class SoftwareHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Software myBean = new org.pdb.ormapping.Software();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("citation_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setCitation_id(fieldValue);
		}
		else if ("classification".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setClassification(fieldValue);
		}
		else if ("compiler_name".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCompiler_name(fieldValue);
		}
		else if ("compiler_version".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setCompiler_version(fieldValue);
		}
		else if ("contact_author".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setContact_author(fieldValue);
		}
		else if ("contact_author_email".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setContact_author_email(fieldValue);
		}
		else if ("date".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setDate(fieldValue);
		}
		else if ("dependencies".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDependencies(fieldValue);
		}
		else if ("description".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 5000)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,5000);
			}
			myBean.setDescription(fieldValue);
		}
		else if ("hardware".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setHardware(fieldValue);
		}
		else if ("language".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setLanguage(fieldValue);
		}
		else if ("location".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setLocation(fieldValue);
		}
		else if ("mods".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setMods(fieldValue);
		}
		else if ("name".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setName(fieldValue);
		}
		else if ("os".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setOs(fieldValue);
		}
		else if ("os_version".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setOs_version(fieldValue);
		}
		else if ("type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setType(fieldValue);
		}
		else if ("version".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 500)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,500);
			}
			myBean.setVersion(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
