package org.pdb.ormapping.util;

import java.util.Set;

import org.pdb.ormapping.Citation_author;
import org.pdb.ormapping.handlers.Citation_authorHandler;
import org.pdb.derived.CitationAuthorMaster;

/**
 * @author wayne
 *
 */
public class CitationAuthorListHandler implements org.pdb.ormapping.util.BeanHandler
{
	protected Citation_authorHandler subHandler = new Citation_authorHandler();
	protected CitationAuthorMaster cam = new CitationAuthorMaster();
	protected StringBuffer authors = new StringBuffer(); 
	protected Citation_author subBean = (Citation_author) subHandler.getBean();
	protected String structId = null;
	
	public CitationAuthorListHandler(String structId)
	{
		String aStructId = structId.toUpperCase();
		if (aStructId.length() > 4)
		{
			aStructId = aStructId.substring(0,4);
		}
		this.structId = aStructId;
	}
	
	public CitationAuthorMaster getCitationAuthorMaster()
	{

		if (authors.length() > 2)
		{	
			cam.setAuthors(authors.substring(2));
		}
		else
		{
			cam.setAuthors("");
		}
		
		cam.setCitationOrder(subBean.getCitation_id());
		cam.setStructId(structId);
		return cam;
	}
	
	/**
	 * @param fieldName
	 * @param fieldValue
	 */
	public void setField(String fieldName, String fieldValue)
	{
		if (fieldName.equalsIgnoreCase("name"))
		{
			authors.append(", ");
			authors.append(fieldValue);
		}
		subHandler.setField(fieldName, fieldValue);
	}
	
	/**
	 * @param collectionName
	 * @param aChild
	 */
	public void addChild(String collectionName, Object aChild)
	{
		subHandler.addChild(collectionName, aChild);
	}

	/**
	 * @param collectionName
	 * @param children
	 */
	public void addChildren(String collectionName, Set children)
	{
		subHandler.addChildren(collectionName, children);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj)
	{
		return subHandler.equals(obj);
	}

	/**
	 * @return
	 */
	public OrMappingBean getBean()
	{
		return subHandler.getBean();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode()
	{
		return subHandler.hashCode();
	}

	/**
	 * 
	 */
	public void reInit()
	{
		subHandler.reInit();
		authors = new StringBuffer(); 
		cam = new CitationAuthorMaster();
	}



	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return subHandler.toString();
	}

}
