package org.pdb.ormapping.util;

import java.beans.Introspector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.type.CollectionType;
import org.hibernate.type.OneToOneType;
import org.pdb.derived.ChemCompRef;
import org.pdb.derived.DerivedStructConn;
import org.pdb.derived.MetadataCategory;
import org.pdb.derived.MetadataEnumeration;
import org.pdb.derived.MetadataItem;
import org.pdb.derived.Model;
import org.pdb.derived.MoleculeType;
import org.pdb.derived.MvStructure;
import org.pdb.derived.PolyStats;
import org.pdb.derived.Pubmed;
import org.pdb.derived.VSequence;

/**
 * @author wayne
 */
public class MetadataSerializer
{

   public static void main(String[] args)
   {
      String argOne = "";

      if (args != null && args.length > 0)
      {
         argOne = args[0];
      }
      generateMetadata(getSchemaFile());
      serializeCatsToFile(argOne);
      System.exit(0);
   }

   public static final String METADATA_SEROBJ = "metadata.serobj";

   protected InputStream serializedObjInputStream = null;

   /**
    * @param serializedObjInputStream
    *           The serializedObjInputStream to set.
    */
   public void setSerializedObjInputStream(InputStream serializedObjInputStream)
   {
      if (serializedObjInputStream == null)
      {
         System.err.println("serializedObjInputStream was passed null!");
      }
      else
      {
         System.err.println(serializedObjInputStream.toString());
      }
      this.serializedObjInputStream = serializedObjInputStream;
   }

   protected static void addDerivedField(MetadataCategory cat, String itemName, Column acol, List flds, int itemCount)
   {
      MetadataItem item = new MetadataItem();
      item.setItemName(itemName);
      item.setFieldName(acol.getName());
      item.setItemOrder(new Integer(itemCount));
      item.setJavaName(Field.toFirstLetterUpper(itemName));
      item.setDataType(acol.getValue().getType().getReturnedClass().getName());
      // item.setDescription(???);
      item.setIsNullable(Boolean.valueOf(acol.isNullable()));
      item.setDataLength(new Integer(acol.getLength()));
      item.setMetadataCategory(cat);
      // for now use item name for display
      item.setDisplayName(itemName);
      item.setShortDisplayName(itemName);
      flds.add(item);
   }

   protected static void processDerivedTable(Class c)
   {
      Configuration hcfg = HibernateUtils.getHibernateConfig();
      PersistentClass aPersistentClass = hcfg.getClassMapping(c.getName());
      org.hibernate.mapping.Table hibernateTable = aPersistentClass.getTable();
      int pos = c.getName().lastIndexOf('.');
      String catName = Introspector.decapitalize(c.getName().substring(pos + 1));

      MetadataCategory cat = new MetadataCategory();
      cat.setTableName(hibernateTable.getName().toLowerCase());
      cat.setCategoryName(catName);
      cat.setDisplayName(catName);
      cat.setShortDisplayName(catName);
      cat.setClassName(c.getName());
      List flds = new ArrayList();
      // List enums = null;
      int itemCount = 0;
      Property aProp = aPersistentClass.getIdentifierProperty();
      Iterator pcIt = aPersistentClass.getIdentifier().getColumnIterator();
      // while(pcIt.hasNext())
      // TODO fix for multi-column keys
      {
         Column acol = (Column) pcIt.next();
         addDerivedField(cat, aProp.getName(), acol, flds, itemCount++);
      }
      pcIt = aPersistentClass.getPropertyIterator();
      try
      {
         while (pcIt.hasNext())
         {
            aProp = (Property) pcIt.next();
            Iterator colIt = aProp.getColumnIterator();
            if (!aProp.getType().isEntityType() && !aProp.getType().isCollectionType())
            {
               // System.out.println("field: " + aProp.getName());
               if (!colIt.hasNext())
               {
                  continue;
               }
               Column acol = (Column) aProp.getColumnIterator().next();
               addDerivedField(cat, aProp.getName(), acol, flds, itemCount++);
            }
            else if (aProp.getType().isComponentType())
            {
               // System.out.println("Component prop: " + aProp.getName());
            }
            else if (aProp.getType().isEntityType())
            {
               // System.out.println("Entity prop: " + aProp.getName());
               StringBuffer sb = new StringBuffer();
               Value setVal = aProp.getValue();
               PersistentClass rpc = hcfg.getClassMapping(aProp.getType().getReturnedClass().getName());
               String referencedTableName = rpc.getTable().getName();
               if (setVal.getType() instanceof OneToOneType)
               {
                  OneToOne oto = (OneToOne) setVal;
                  sb.append(hibernateTable.getName()); // eg molecule_type
                  sb.append('.');
                  sb.append(((Column) hibernateTable.getPrimaryKey().getColumnIterator().next()).getName());
                  sb.append(" = ");
                  sb.append(referencedTableName.toLowerCase());
                  sb.append('.');
                  sb.append(oto.getReferencedPropertyName());
               }
               else
               {
                  Value mtoKey = rpc.getKey();
                  Iterator referencedTablePrimaryKeyIterator = mtoKey.getColumnIterator();
                  Iterator cci = setVal.getColumnIterator();
                  while (cci.hasNext() && referencedTablePrimaryKeyIterator.hasNext())
                  {
                     Column cc = (Column) cci.next();
                     Column rc = (Column) referencedTablePrimaryKeyIterator.next();
                     sb.append(hibernateTable.getName());
                     sb.append('.');
                     sb.append(cc.getName());
                     sb.append(" = ");
                     sb.append(referencedTableName.toLowerCase());
                     sb.append('.');
                     sb.append(rc.getName());
                     if (cci.hasNext() && referencedTablePrimaryKeyIterator.hasNext())
                     {
                        sb.append(" and ");
                     }
                  }
               }
               cat.setParentTableName(referencedTableName);
               cat.setParentClassName(aProp.getType().getName());
               cat.setJoinClause(sb.toString());
               // System.out.println("join: " + sb.toString());
            }
            else if (aProp.getType().isAssociationType())
            {
               // System.out.println("Association prop: " + aProp.getName());
               Value setVal = aProp.getValue();
               // System.out.println("setVal: " + setVal.toString());
               CollectionType pct = (CollectionType) setVal.getType();
               // System.out.println("pct: " + pct.toString());
               Collection setCollection = hcfg.getCollectionMapping(pct.getRole());
               // System.out.println("setCollection: " +
               // setCollection.toString());
               Value otmKey = setCollection.getKey();
               // System.out.println("otmKey: " + otmKey.toString());
               org.hibernate.mapping.Table setColTable = setCollection.getCollectionTable();
               // System.out.println("setColTable: " + setColTable.toString());
               String referencedTableName = setColTable.getName();
               Iterator referencedTablePrimaryKeyIterator = otmKey.getColumnIterator();
               Iterator kci = hibernateTable.getPrimaryKey().getColumnIterator();
               StringBuffer sb = new StringBuffer();
               while (kci.hasNext() && referencedTablePrimaryKeyIterator.hasNext())
               {
                  Column kc = (Column) kci.next();
                  Column rc = (Column) referencedTablePrimaryKeyIterator.next();
                  sb.append(hibernateTable.getName());
                  sb.append('.');
                  sb.append(kc.getName());
                  sb.append(" = ");
                  sb.append(referencedTableName.toLowerCase());
                  sb.append('.');
                  sb.append(rc.getName());
                  if (kci.hasNext() && referencedTablePrimaryKeyIterator.hasNext())
                  {
                     sb.append(" and ");
                  }
               }
               cat.setParentTableName(otmKey.getTable().getName());
               cat.setParentClassName(setCollection.getElement().getType().getReturnedClass().getName());
               cat.setJoinClause(sb.toString());
            }
         }
         cat.setMetadataItems(flds);
         allCats.add(cat);
      }
      catch (Exception e)
      {
         throw new RuntimeException(e);
      }
   }

   protected static void processTable(Table t, Table parentTable)
   {
      Iterator it = t.getTables().iterator();
      while (it.hasNext())
      {
         Table kid = (Table) it.next();
         processTable(kid, t);
      }
      String className = Field.toFirstLetterUpper(t.getName());
      MetadataCategory cat = new MetadataCategory();
      cat.setTableName(BeanBuilder.getSafeFieldName(t.getName()).toLowerCase());
      cat.setCategoryName(t.getName());
      // for now use category name for display
      cat.setDisplayName(t.getName());
      cat.setShortDisplayName(t.getName());
      cat.setClassName("org.pdb.ormapping." + className);
      if (!className.equalsIgnoreCase("datablock"))
      {
         cat.setParentClassName("org.pdb.ormapping.Datablock");
         cat.setParentTableName("datablock");
         cat.setJoinClause("datablock.obj_id = " + t.getName().toLowerCase() + ".parent_obj_id");
      }
      cat.setDescription(t.getDescription());
      List flds = new ArrayList();
      List enums = null;
      int itemCount = 0;
      it = t.getFields().iterator();
      // System.out.println(t.getName());
      try
      {
         while (it.hasNext())
         {
            Field f = (Field) it.next();
            StringFieldInfo.SingleFieldInfo sfi = sfiHelper.getFieldInfo(t.getName(), f.getName());
            MetadataItem item = new MetadataItem();
            item.setItemName(f.getName());
            item.setFieldName(BeanBuilder.getSafeFieldName(f.getName()).toLowerCase());
            item.setItemOrder(new Integer(itemCount++));
            String javaName = BeanBuilder.getSafeJavaName(Introspector.decapitalize(f.getName()));
            if (javaName.length() > 1 && Character.isUpperCase(javaName.charAt(1)))
            {
               javaName = Field.toFirstLetterUpper(javaName);
            }
            item.setJavaName(javaName);
            item.setDataType(f.getDataType());
            item.setDescription(f.getDescription());
            item.setIsNullable(Boolean.valueOf(f.isNullable()));
            item.setDataUnitOfMeasure(f.getUnits());
            item.setMinValue(f.getMinValue());
            item.setMaxValue(f.getMaxValue());
            if (sfi != null)
            {
               item.setDataLength(new Integer(sfi.getFieldLength()));
            }
            item.setMetadataCategory(cat);
            // for now use item name for display
            item.setDisplayName(f.getName());
            item.setShortDisplayName(f.getName());
            // handle any enums
            if (f.getEnumValues() != null)
            {
               enums = new ArrayList();
               int enumCount = 0;
               Iterator eit = f.getEnumValues().getValues().iterator();
               while (eit.hasNext())
               {
                  String aval = eit.next().toString();
                  // System.out.println(f.getName() + " - enumValue: " +
                  // aval);
                  MetadataEnumeration mde = new MetadataEnumeration();
                  mde.setEnumOrder(new Integer(enumCount++));
                  mde.setEnumString(aval);
                  mde.setMetadataItem(item);
                  enums.add(mde);
               }
               item.setMetadataEnums(enums);
            }
            flds.add(item);
         }
         cat.setMetadataItems(flds);
         allCats.add(cat);
      }
      catch (Exception e)
      {
         throw new RuntimeException(e);
      }
   }

   private static StringFieldInfo sfiHelper = null;

   protected static String getSchemaFile()
   {
      String[] schemaUrls = new String[2];
      schemaUrls[0] = "http://pdbml.pdb.org/schema/pdbx.xsd";
      schemaUrls[1] = "ftp://pdbx.org:10601/pdbx-v1.020.xsd";
      String ans = null;
      int i = 0;
      while (ans == null && i < schemaUrls.length)
      {
         try
         {
            ans = getSchemaFile(schemaUrls[i]);
         }
         catch (Exception e)
         {
            System.err.println("Could NOT get schema from: " + schemaUrls[i]);
            e.printStackTrace();
         }
         i++;
      }
      return ans;
   }

   protected static String getSchemaFile(String urlStringIn)
   {
      String ans = "";
      String urlString = "http://pdbml.pdb.org/schema/pdbx.xsd";
      if (urlStringIn != null)
      {
         urlString = urlStringIn;
      }
      InputStream in = null;
      OutputStream fout = null;
      try
      {
         in = new BufferedInputStream((new java.net.URL(urlString)).openStream());
         int len;
         byte[] buf = new byte[2048];
         File tf = File.createTempFile("schemafile", ".xml");
         tf.deleteOnExit();
         fout = new BufferedOutputStream(new FileOutputStream(tf));
         while ((len = in.read(buf)) >= 0)
         {
            fout.write(buf, 0, len);
         }
         in.close();
         in = null;
         fout.close();
         fout = null;
         // System.out.println("created:" + tf.getCanonicalPath());
         ans = tf.getCanonicalPath();
      }
      catch (IOException ioe)
      {
         ioe.printStackTrace();
         if (in != null)
         {
            try
            {
               in.close();
            }
            catch (IOException e1)
            {
            }
         }
         if (fout != null)
         {
            try
            {
               fout.close();
            }
            catch (IOException e1)
            {
            }
         }
         throw new RuntimeException(ioe);
      }
      return ans;
   }

   protected static List allCats = new ArrayList();

   public static void serializeCatsToFile(String outputDirIn)
   {
      String outputDir = "";
      if (outputDirIn != null)
      {
         outputDir = outputDirIn;
         if ((outputDir.length() > 0) && (!outputDir.endsWith(File.separator)))
         {
            outputDir += File.separator;
         }
      }
      File serObjFile = new File(outputDir + METADATA_SEROBJ);
      ObjectOutputStream oout = null;
      try
      {
         System.out.println("about to save it: " + serObjFile.getCanonicalPath());
         serObjFile.createNewFile();
         oout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serObjFile)));
         oout.writeObject(allCats);
         oout.flush();
         oout.close();
         System.out.println("saved it");
      }
      catch (Exception e)
      {
         try
         {
            if (oout != null) oout.close();
         }
         catch (Exception ce)
         {
         }
         String errMsg = "Problems saving metadata.serobj! " + e.getMessage();
         e.printStackTrace();
         System.err.println(errMsg);
      }
   }

   public static void generateMetadata(String schemaName)
   {
      BufferedReader ris = null;
      String aLine = null;
      Class aDerivedClass = null;
      sfiHelper = new StringFieldInfo();
      Table t = SchemaReader.getTopTable(schemaName);
      try
      {
         // first do tables based on mmCIF schema
         File schemaFile = new File(schemaName);
         if (!schemaFile.exists())
         {
            throw new RuntimeException("XML Schema file does NOT exist: " + schemaName);
         }
         processTable(t, null);
         
         // now do derived tables
         try
         {
            ris = new BufferedReader(new InputStreamReader(MetadataSerializer.class
                  .getResourceAsStream("/org/pdb/ormapping/hbmlist.txt")));
            if (ris != null)
            {
               while (ris.ready())
               {
                  aLine = ris.readLine();
                  System.err.println(aLine);
                  if (aLine.startsWith("org/pdb/derived/"))
                  {
                     int pos = aLine.indexOf('.');
                     aLine = aLine.substring(16, pos);
                     System.err.println(aLine);
                     aDerivedClass = null;
                     // in case people didnt name their hbm.xml file properly, need to catch it
                     try
                     {
                        aDerivedClass = Class.forName("org.pdb.derived." + aLine);
                     }
                     catch (Throwable e)
                     {
                        e.printStackTrace();
                     }
                     if (aDerivedClass != null)
                     {
                        processDerivedTable(aDerivedClass);
                     }
                  }
               }
               ris.close();
               ris = null;
            }
         }
         catch (Exception e)
         {
            e.printStackTrace();
            if (ris != null)
            {
               ris.close();
            }
         }

      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      System.out.println("Finished loading metadata.");
   }

   public static void test()
   {
      Session s = HibernateUtils.getTestSession();
      sfiHelper = new StringFieldInfo();
      Transaction tx = null;
      tx = s.beginTransaction();
      try
      {
         processDerivedTable(MoleculeType.class);
         processDerivedTable(ChemCompRef.class);
         processDerivedTable(Pubmed.class);
         processDerivedTable(MvStructure.class);
         processDerivedTable(PolyStats.class);
         processDerivedTable(DerivedStructConn.class);
         processDerivedTable(Model.class);
         processDerivedTable(VSequence.class);
         Iterator it = allCats.iterator();
         while (it.hasNext())
         {
            MetadataCategory aCat = (MetadataCategory) it.next();
            s.save(aCat);
         }
         tx.commit();
         s.close();
      }
      catch (Exception e)
      {
         if (tx != null) tx.rollback();
         HibernateUtils.HandleHibernateException(s, e);
      }
      System.out.println("Finished testing load of derived metadata.");
   }

}